/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.spotify.docker.client.messages.AttachedNetwork;
import com.spotify.docker.client.messages.PortBinding;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class NetworkSettings {
    @JsonProperty(value="IPAddress")
    private String ipAddress;
    @JsonProperty(value="IPPrefixLen")
    private Integer ipPrefixLen;
    @JsonProperty(value="Gateway")
    private String gateway;
    @JsonProperty(value="Bridge")
    private String bridge;
    @JsonProperty(value="PortMapping")
    private ImmutableMap<String, Map<String, String>> portMapping;
    @JsonProperty(value="Ports")
    private Map<String, List<PortBinding>> ports;
    @JsonProperty(value="MacAddress")
    private String macAddress;
    @JsonProperty(value="Networks")
    private ImmutableMap<String, AttachedNetwork> networks;

    private NetworkSettings(Builder builder) {
        this.ipAddress = builder.ipAddress;
        this.ipPrefixLen = builder.ipPrefixLen;
        this.gateway = builder.gateway;
        this.bridge = builder.bridge;
        this.portMapping = builder.portMapping;
        this.ports = builder.ports;
        this.macAddress = builder.macAddress;
        this.networks = builder.networks;
    }

    public NetworkSettings() {
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public Integer ipPrefixLen() {
        return this.ipPrefixLen;
    }

    public String gateway() {
        return this.gateway;
    }

    public String bridge() {
        return this.bridge;
    }

    public Map<String, Map<String, String>> portMapping() {
        return this.portMapping;
    }

    public Map<String, List<PortBinding>> ports() {
        return this.ports == null ? null : Collections.unmodifiableMap(this.ports);
    }

    public String macAddress() {
        return this.macAddress;
    }

    public Map<String, AttachedNetwork> networks() {
        return this.networks == null ? null : Collections.unmodifiableMap(this.networks);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkSettings that = (NetworkSettings)o;
        return Objects.equals(this.ipAddress, that.ipAddress) && Objects.equals(this.ipPrefixLen, that.ipPrefixLen) && Objects.equals(this.gateway, that.gateway) && Objects.equals(this.bridge, that.bridge) && Objects.equals(this.portMapping, that.portMapping) && Objects.equals(this.ports, that.ports) && Objects.equals(this.macAddress, that.macAddress) && Objects.equals(this.networks, that.networks);
    }

    public int hashCode() {
        return Objects.hash(this.ipAddress, this.ipPrefixLen, this.gateway, this.bridge, this.portMapping, this.ports, this.macAddress, this.networks);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ipAddress", (Object)this.ipAddress).add("ipPrefixLen", (Object)this.ipPrefixLen).add("gateway", (Object)this.gateway).add("bridge", (Object)this.bridge).add("portMapping", this.portMapping).add("ports", this.ports).add("macAddress", (Object)this.macAddress).add("networks", this.networks).toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String ipAddress;
        private Integer ipPrefixLen;
        private String gateway;
        private String bridge;
        private ImmutableMap<String, Map<String, String>> portMapping;
        private Map<String, List<PortBinding>> ports;
        private String macAddress;
        private ImmutableMap<String, AttachedNetwork> networks;

        private Builder() {
        }

        private Builder(NetworkSettings networkSettings) {
            this.ipAddress = networkSettings.ipAddress;
            this.ipPrefixLen = networkSettings.ipPrefixLen;
            this.gateway = networkSettings.gateway;
            this.bridge = networkSettings.bridge;
            this.portMapping = networkSettings.portMapping;
            this.ports = networkSettings.ports;
            this.macAddress = networkSettings.macAddress;
            this.networks = networkSettings.networks;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder ipPrefixLen(Integer ipPrefixLen) {
            this.ipPrefixLen = ipPrefixLen;
            return this;
        }

        public Builder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        public Builder bridge(String bridge) {
            this.bridge = bridge;
            return this;
        }

        public Builder portMapping(Map<String, Map<String, String>> portMapping) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<String, Map<String, String>> entry : portMapping.entrySet()) {
                builder.put((Object)entry.getKey(), (Object)ImmutableMap.copyOf(entry.getValue()));
            }
            this.portMapping = builder.build();
            return this;
        }

        public Builder ports(Map<String, List<PortBinding>> ports) {
            this.ports = ports == null ? null : Maps.newHashMap(ports);
            return this;
        }

        public Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public Builder networks(Map<String, AttachedNetwork> networks) {
            if (networks != null) {
                this.networks = ImmutableMap.copyOf(networks);
            }
            return this;
        }

        public NetworkSettings build() {
            return new NetworkSettings(this);
        }
    }
}

