/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.mount;

import com.google.common.base.MoreObjects;
import com.spotify.docker.client.messages.mount.BindOptions;
import com.spotify.docker.client.messages.mount.VolumeOptions;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class Mount {
    @JsonProperty(value="Type")
    private String type;
    @JsonProperty(value="Source")
    private String source;
    @JsonProperty(value="Target")
    private String target;
    @JsonProperty(value="ReadOnly")
    private Boolean readOnly;
    @JsonProperty(value="BindOptions")
    private BindOptions bindOptions;
    @JsonProperty(value="VolumeOptions")
    private VolumeOptions volumeOptions;

    public String type() {
        return this.type;
    }

    public String source() {
        return this.source;
    }

    public String target() {
        return this.target;
    }

    public Boolean readOnly() {
        return this.readOnly;
    }

    public BindOptions bindOptions() {
        return this.bindOptions;
    }

    public VolumeOptions volumeOptions() {
        return this.volumeOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mount that = (Mount)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.source, that.source) && Objects.equals(this.target, that.target) && Objects.equals(this.readOnly, that.readOnly) && Objects.equals(this.bindOptions, that.bindOptions) && Objects.equals(this.volumeOptions, that.volumeOptions);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.source, this.target, this.readOnly, this.bindOptions, this.volumeOptions);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("source", (Object)this.source).add("target", (Object)this.target).add("readOnly", (Object)this.readOnly).add("bindOptions", (Object)this.bindOptions).add("volumeOptions", (Object)this.volumeOptions).toString();
    }

    public static class Builder {
        private Mount mount = new Mount();

        public Builder withType(String type) {
            this.mount.type = type;
            return this;
        }

        public Builder withSource(String source) {
            this.mount.source = source;
            return this;
        }

        public Builder withTarget(String target) {
            this.mount.target = target;
            return this;
        }

        public Builder makeReadOnly() {
            this.mount.readOnly = true;
            return this;
        }

        public Builder makeReadOnly(boolean readOnly) {
            this.mount.readOnly = readOnly;
            return this;
        }

        public Builder withBindOptions(BindOptions bindOptions) {
            this.mount.bindOptions = bindOptions;
            return this;
        }

        public Builder withVolumeOptions(VolumeOptions volumeOptions) {
            this.mount.volumeOptions = volumeOptions;
            return this;
        }

        public Mount build() {
            return this.mount;
        }
    }
}

