/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.swarm;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class NetworkAttachmentConfig {
    @JsonProperty(value="Target")
    private String target;
    @JsonProperty(value="Aliases")
    private ImmutableList<String> aliases;

    public String target() {
        return this.target;
    }

    public List<String> aliases() {
        return this.aliases;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkAttachmentConfig that = (NetworkAttachmentConfig)o;
        return Objects.equals(this.target, that.target) && Objects.equals(this.aliases, that.aliases);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.aliases);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("target", (Object)this.target).add("aliases", this.aliases).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private NetworkAttachmentConfig config = new NetworkAttachmentConfig();

        public Builder withTarget(String target) {
            this.config.target = target;
            return this;
        }

        public Builder withAliases(String ... aliases) {
            if (aliases != null && aliases.length > 0) {
                this.config.aliases = ImmutableList.copyOf((Object[])aliases);
            }
            return this;
        }

        public Builder withAliases(List<String> aliases) {
            if (aliases != null && !aliases.isEmpty()) {
                this.config.aliases = ImmutableList.copyOf(aliases);
            }
            return this;
        }

        public NetworkAttachmentConfig build() {
            return this.config;
        }
    }
}

