/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.swarm;

import com.google.common.base.MoreObjects;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class PortConfig {
    public static final String PROTOCOL_TCP = "tcp";
    public static final String PROTOCOL_UDP = "udp";
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="Protocol")
    private String protocol;
    @JsonProperty(value="TargetPort")
    private Integer targetPort;
    @JsonProperty(value="PublishedPort")
    private Integer publishedPort;

    public String name() {
        return this.name;
    }

    public String protocol() {
        return this.protocol;
    }

    public Integer targetPort() {
        return this.targetPort;
    }

    public Integer publishedPort() {
        return this.publishedPort;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortConfig that = (PortConfig)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.targetPort, that.targetPort) && Objects.equals(this.publishedPort, that.publishedPort);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.protocol, this.targetPort, this.publishedPort);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("protocol", (Object)this.protocol).add("targetPort", (Object)this.targetPort).add("publishedPort", (Object)this.publishedPort).toString();
    }

    public static class Builder {
        private PortConfig config = new PortConfig();

        public Builder withName(String name) {
            this.config.name = name;
            return this;
        }

        public Builder withProtocol(String protocol) {
            this.config.protocol = protocol;
            return this;
        }

        public Builder withTargetPort(int targetPort) {
            this.config.targetPort = targetPort;
            return this;
        }

        public Builder withPublishedPort(int publishedPort) {
            this.config.publishedPort = publishedPort;
            return this;
        }

        public PortConfig build() {
            return this.config;
        }
    }
}

