/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.swarm;

import com.google.common.base.MoreObjects;
import com.spotify.docker.client.messages.swarm.Endpoint;
import com.spotify.docker.client.messages.swarm.ServiceSpec;
import com.spotify.docker.client.messages.swarm.UpdateStatus;
import com.spotify.docker.client.messages.swarm.Version;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class Service {
    @JsonProperty(value="ID")
    private String id;
    @JsonProperty(value="Version")
    private Version version;
    @JsonProperty(value="CreatedAt")
    private Date createdAt;
    @JsonProperty(value="UpdatedAt")
    private Date updatedAt;
    @JsonProperty(value="Spec")
    private ServiceSpec spec;
    @JsonProperty(value="Endpoint")
    private Endpoint endpoint;
    @JsonProperty(value="UpdateStatus")
    private UpdateStatus updateStatus;

    public String id() {
        return this.id;
    }

    public Version version() {
        return this.version;
    }

    public Date createdAt() {
        return this.createdAt == null ? null : new Date(this.createdAt.getTime());
    }

    public Date updatedAt() {
        return this.updatedAt == null ? null : new Date(this.updatedAt.getTime());
    }

    public ServiceSpec spec() {
        return this.spec;
    }

    public Endpoint endpoint() {
        return this.endpoint;
    }

    public UpdateStatus updateStatus() {
        return this.updateStatus;
    }

    public static Criteria.Builder find() {
        return Criteria.builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Service that = (Service)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.version, that.version) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.updatedAt, that.updatedAt) && Objects.equals(this.spec, that.spec) && Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.updateStatus, that.updateStatus);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.createdAt, this.updatedAt, this.spec, this.endpoint, this.updateStatus);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("version", (Object)this.version).add("createdAt", (Object)this.createdAt).add("updatedAt", (Object)this.updatedAt).add("spec", (Object)this.spec).add("endpoint", (Object)this.endpoint).add("updateStatus", (Object)this.updateStatus).toString();
    }

    public static class Criteria {
        String serviceId;
        String serviceName;

        private Criteria(Builder builder) {
            this.serviceId = builder.serviceId;
            this.serviceName = builder.serviceName;
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String serviceId;
            private String serviceName;

            public Builder withServiceId(String serviceId) {
                this.serviceId = serviceId;
                return this;
            }

            public Builder withServiceName(String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            public Criteria build() {
                return new Criteria(this);
            }
        }
    }
}

