/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.swarm;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.spotify.docker.client.messages.swarm.ContainerSpec;
import com.spotify.docker.client.messages.swarm.Driver;
import com.spotify.docker.client.messages.swarm.NetworkAttachmentConfig;
import com.spotify.docker.client.messages.swarm.Placement;
import com.spotify.docker.client.messages.swarm.ResourceRequirements;
import com.spotify.docker.client.messages.swarm.RestartPolicy;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class TaskSpec {
    @JsonProperty(value="ContainerSpec")
    private ContainerSpec containerSpec;
    @JsonProperty(value="Resources")
    private ResourceRequirements resources;
    @JsonProperty(value="RestartPolicy")
    private RestartPolicy restartPolicy;
    @JsonProperty(value="Placement")
    private Placement placement;
    @JsonProperty(value="Networks")
    private ImmutableList<NetworkAttachmentConfig> networks;
    @JsonProperty(value="LogDriver")
    private Driver logDriver;

    public ContainerSpec containerSpec() {
        return this.containerSpec;
    }

    public ResourceRequirements resources() {
        return this.resources;
    }

    public RestartPolicy restartPolicy() {
        return this.restartPolicy;
    }

    public Placement placement() {
        return this.placement;
    }

    public List<NetworkAttachmentConfig> networks() {
        return this.networks;
    }

    public Driver logDriver() {
        return this.logDriver;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskSpec that = (TaskSpec)o;
        return Objects.equals(this.containerSpec, that.containerSpec) && Objects.equals(this.resources, that.resources) && Objects.equals(this.restartPolicy, that.restartPolicy) && Objects.equals(this.placement, that.placement) && Objects.equals(this.networks, that.networks) && Objects.equals(this.logDriver, that.logDriver);
    }

    public int hashCode() {
        return Objects.hash(this.containerSpec, this.resources, this.restartPolicy, this.placement, this.networks, this.logDriver);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("containerSpec", (Object)this.containerSpec).add("resources", (Object)this.resources).add("restartPolicy", (Object)this.restartPolicy).add("placement", (Object)this.placement).add("networks", this.networks).add("logDriver", (Object)this.logDriver).toString();
    }

    public static class Builder {
        private TaskSpec spec = new TaskSpec();

        public Builder withContainerSpec(ContainerSpec containerSpec) {
            this.spec.containerSpec = containerSpec;
            return this;
        }

        public Builder withResources(ResourceRequirements resources) {
            this.spec.resources = resources;
            return this;
        }

        public Builder withRestartPolicy(RestartPolicy restartPolicy) {
            this.spec.restartPolicy = restartPolicy;
            return this;
        }

        public Builder withPlacement(Placement placement) {
            this.spec.placement = placement;
            return this;
        }

        public Builder withNetworks(NetworkAttachmentConfig ... networks) {
            if (networks != null && networks.length > 0) {
                this.spec.networks = ImmutableList.copyOf((Object[])networks);
            }
            return this;
        }

        public Builder withNetworks(List<NetworkAttachmentConfig> networks) {
            if (networks != null && !networks.isEmpty()) {
                this.spec.networks = ImmutableList.copyOf(networks);
            }
            return this;
        }

        public Builder withLogDriver(Driver logDriver) {
            this.spec.logDriver = logDriver;
            return this;
        }

        public TaskSpec build() {
            return this.spec;
        }
    }
}

