package com.spotify.fmt;

import io.norberg.automatter.AutoMatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.processing.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
@AutoMatter.Generated
final class FormattingResultBuilder {
  private List<String> processedFiles;

  private List<String> nonComplyingFiles;

  public FormattingResultBuilder() {
  }

  private FormattingResultBuilder(FormattingResult v) {
    List<String> _processedFiles = v.processedFiles();
    this.processedFiles = (_processedFiles == null) ? null : new ArrayList<String>(_processedFiles);
    List<String> _nonComplyingFiles = v.nonComplyingFiles();
    this.nonComplyingFiles = (_nonComplyingFiles == null) ? null : new ArrayList<String>(_nonComplyingFiles);
  }

  private FormattingResultBuilder(FormattingResultBuilder v) {
    this.processedFiles = new ArrayList<String>(v.processedFiles());
    this.nonComplyingFiles = new ArrayList<String>(v.nonComplyingFiles());
  }

  public List<String> processedFiles() {
    if (this.processedFiles == null) {
      this.processedFiles = new ArrayList<String>();
    }
    return processedFiles;
  }

  public FormattingResultBuilder processedFiles(List<? extends String> processedFiles) {
    return processedFiles((Collection<? extends String>) processedFiles);
  }

  public FormattingResultBuilder processedFiles(Collection<? extends String> processedFiles) {
    if (processedFiles == null) {
      throw new NullPointerException("processedFiles");
    }
    for (String item : processedFiles) {
      if (item == null) {
        throw new NullPointerException("processedFiles: null item");
      }
    }
    this.processedFiles = new ArrayList<String>(processedFiles);
    return this;
  }

  public FormattingResultBuilder processedFiles(Iterable<? extends String> processedFiles) {
    if (processedFiles == null) {
      throw new NullPointerException("processedFiles");
    }
    if (processedFiles instanceof Collection) {
      return processedFiles((Collection<? extends String>) processedFiles);
    }
    return processedFiles(processedFiles.iterator());
  }

  public FormattingResultBuilder processedFiles(Iterator<? extends String> processedFiles) {
    if (processedFiles == null) {
      throw new NullPointerException("processedFiles");
    }
    this.processedFiles = new ArrayList<String>();
    while (processedFiles.hasNext()) {
      String item = processedFiles.next();
      if (item == null) {
        throw new NullPointerException("processedFiles: null item");
      }
      this.processedFiles.add(item);
    }
    return this;
  }

  @SafeVarargs
  @SuppressWarnings("varargs")
  public final FormattingResultBuilder processedFiles(String... processedFiles) {
    if (processedFiles == null) {
      throw new NullPointerException("processedFiles");
    }
    return processedFiles(Arrays.asList(processedFiles));
  }

  public FormattingResultBuilder addProcessedFile(String processedFile) {
    if (processedFile == null) {
      throw new NullPointerException("processedFile");
    }
    if (this.processedFiles == null) {
      this.processedFiles = new ArrayList<String>();
    }
    processedFiles.add(processedFile);
    return this;
  }

  public List<String> nonComplyingFiles() {
    if (this.nonComplyingFiles == null) {
      this.nonComplyingFiles = new ArrayList<String>();
    }
    return nonComplyingFiles;
  }

  public FormattingResultBuilder nonComplyingFiles(List<? extends String> nonComplyingFiles) {
    return nonComplyingFiles((Collection<? extends String>) nonComplyingFiles);
  }

  public FormattingResultBuilder nonComplyingFiles(Collection<? extends String> nonComplyingFiles) {
    if (nonComplyingFiles == null) {
      throw new NullPointerException("nonComplyingFiles");
    }
    for (String item : nonComplyingFiles) {
      if (item == null) {
        throw new NullPointerException("nonComplyingFiles: null item");
      }
    }
    this.nonComplyingFiles = new ArrayList<String>(nonComplyingFiles);
    return this;
  }

  public FormattingResultBuilder nonComplyingFiles(Iterable<? extends String> nonComplyingFiles) {
    if (nonComplyingFiles == null) {
      throw new NullPointerException("nonComplyingFiles");
    }
    if (nonComplyingFiles instanceof Collection) {
      return nonComplyingFiles((Collection<? extends String>) nonComplyingFiles);
    }
    return nonComplyingFiles(nonComplyingFiles.iterator());
  }

  public FormattingResultBuilder nonComplyingFiles(Iterator<? extends String> nonComplyingFiles) {
    if (nonComplyingFiles == null) {
      throw new NullPointerException("nonComplyingFiles");
    }
    this.nonComplyingFiles = new ArrayList<String>();
    while (nonComplyingFiles.hasNext()) {
      String item = nonComplyingFiles.next();
      if (item == null) {
        throw new NullPointerException("nonComplyingFiles: null item");
      }
      this.nonComplyingFiles.add(item);
    }
    return this;
  }

  @SafeVarargs
  @SuppressWarnings("varargs")
  public final FormattingResultBuilder nonComplyingFiles(String... nonComplyingFiles) {
    if (nonComplyingFiles == null) {
      throw new NullPointerException("nonComplyingFiles");
    }
    return nonComplyingFiles(Arrays.asList(nonComplyingFiles));
  }

  public FormattingResultBuilder addNonComplyingFile(String nonComplyingFile) {
    if (nonComplyingFile == null) {
      throw new NullPointerException("nonComplyingFile");
    }
    if (this.nonComplyingFiles == null) {
      this.nonComplyingFiles = new ArrayList<String>();
    }
    nonComplyingFiles.add(nonComplyingFile);
    return this;
  }

  public FormattingResult build() {
    List<String> _processedFiles = (processedFiles != null) ? Collections.unmodifiableList(new ArrayList<String>(processedFiles)) : Collections.<String>emptyList();
    List<String> _nonComplyingFiles = (nonComplyingFiles != null) ? Collections.unmodifiableList(new ArrayList<String>(nonComplyingFiles)) : Collections.<String>emptyList();
    return new Value(_processedFiles, _nonComplyingFiles);
  }

  public static FormattingResultBuilder from(FormattingResult v) {
    return new FormattingResultBuilder(v);
  }

  public static FormattingResultBuilder from(FormattingResultBuilder v) {
    return new FormattingResultBuilder(v);
  }

  @AutoMatter.Generated
  private static final class Value implements FormattingResult {
    private final List<String> processedFiles;

    private final List<String> nonComplyingFiles;

    private Value(@AutoMatter.Field("processedFiles") List<String> processedFiles,
        @AutoMatter.Field("nonComplyingFiles") List<String> nonComplyingFiles) {
      this.processedFiles = (processedFiles != null) ? processedFiles : Collections.<String>emptyList();
      this.nonComplyingFiles = (nonComplyingFiles != null) ? nonComplyingFiles : Collections.<String>emptyList();
    }

    @AutoMatter.Field
    @Override
    public List<String> processedFiles() {
      return processedFiles;
    }

    @AutoMatter.Field
    @Override
    public List<String> nonComplyingFiles() {
      return nonComplyingFiles;
    }

    public FormattingResultBuilder builder() {
      return new FormattingResultBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof FormattingResult)) {
        return false;
      }
      final FormattingResult that = (FormattingResult) o;
      if (processedFiles != null ? !processedFiles.equals(that.processedFiles()) : that.processedFiles() != null) {
        return false;
      }
      if (nonComplyingFiles != null ? !nonComplyingFiles.equals(that.nonComplyingFiles()) : that.nonComplyingFiles() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      result = 31 * result + (this.processedFiles != null ? this.processedFiles.hashCode() : 0);
      result = 31 * result + (this.nonComplyingFiles != null ? this.nonComplyingFiles.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "FormattingResult{" +
      "processedFiles=" + processedFiles +
      ", nonComplyingFiles=" + nonComplyingFiles +
      '}';
    }
  }
}
