/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.fmt;

import com.spotify.fmt.SerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

class Serialization {
    private Serialization() {
        throw new UnsupportedOperationException();
    }

    static void serialize(Object object, Path file) throws SerializationException {
        try (OutputStream os = Files.newOutputStream(file, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);){
            Serialization.serialize(object, os);
        }
        catch (IOException e) {
            throw new SerializationException("Serialization failed", e);
        }
    }

    static void serialize(Object object, OutputStream outputStream) throws SerializationException {
        try (ObjectOutputStream oos = new ObjectOutputStream(outputStream);){
            oos.writeObject(object);
        }
        catch (Throwable t) {
            throw new SerializationException("Serialization failed", t);
        }
    }

    static <T> T deserialize(Path filePath) throws SerializationException {
        try {
            return Serialization.deserialize(Files.newInputStream(filePath, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new SerializationException("Deserialization failed", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> T deserialize(InputStream inputStream) throws SerializationException {
        try (ObjectInputStream ois = new ObjectInputStream(inputStream);){
            Object object = ois.readObject();
            return (T)object;
        }
        catch (Throwable t) {
            throw new SerializationException("Deserialization failed", t);
        }
    }

    static {
        System.setProperty("sun.io.serialization.extendedDebugInfo", "true");
    }
}

