/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.hamcrest.pojo;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.spotify.hamcrest.pojo.AutoValue_IsPojo;
import com.spotify.hamcrest.pojo.AutoValue_IsPojo_MethodHandler;
import com.spotify.hamcrest.pojo.MethodReference;
import com.spotify.hamcrest.util.DescriptionUtils;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public abstract class IsPojo<A>
extends TypeSafeDiagnosingMatcher<A> {
    IsPojo() {
    }

    abstract Class<A> cls();

    abstract ImmutableMap<String, MethodHandler<A, ?>> methodHandlers();

    public static <A> IsPojo<A> pojo(Class<A> cls) {
        return IsPojo.builder(cls).build();
    }

    public <T> IsPojo<A> where(String methodName, Matcher<T> returnValueMatcher) {
        return this.where(methodName, self -> {
            Method method = this.methodWithName(methodName, self);
            method.setAccessible(true);
            Object returnValue = method.invoke(self, new Object[0]);
            return returnValue;
        }, returnValueMatcher);
    }

    public <T> IsPojo<A> where(MethodReference<A, T> methodReference, Matcher<T> returnValueMatcher) {
        SerializedLambda serializedLambda = IsPojo.serializeLambda(methodReference);
        IsPojo.ensureDirectMethodReference(serializedLambda);
        return this.where(serializedLambda.getImplMethodName(), methodReference, returnValueMatcher);
    }

    private <T> IsPojo<A> where(String methodName, MethodReference<A, T> valueExtractor, Matcher<T> matcher) {
        return this.toBuilder().methodHandler(methodName, MethodHandler.create(valueExtractor, matcher)).build();
    }

    private Method methodWithName(String methodName, A self) throws NoSuchMethodException {
        try {
            return self.getClass().getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return self.getClass().getMethod(methodName, new Class[0]);
        }
    }

    public IsPojo<A> withProperty(String property, Matcher<?> valueMatcher) {
        return this.where("get" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, property), valueMatcher);
    }

    private static <A> Builder<A> builder(Class<A> cls) {
        return new AutoValue_IsPojo.Builder<A>().cls(cls);
    }

    abstract Builder<A> toBuilder();

    protected boolean matchesSafely(A item, Description mismatchDescription) {
        if (!this.cls().isInstance(item)) {
            mismatchDescription.appendText("not an instance of " + this.cls().getName());
            return false;
        }
        LinkedHashMap mismatches = new LinkedHashMap();
        this.methodHandlers().forEach((methodName, handler) -> IsPojo.matchMethod(item, handler).ifPresent(descriptionConsumer -> mismatches.put(methodName, descriptionConsumer)));
        if (!mismatches.isEmpty()) {
            mismatchDescription.appendText(this.cls().getSimpleName()).appendText(" ");
            DescriptionUtils.describeNestedMismatches((Set)this.methodHandlers().keySet(), (Description)mismatchDescription, mismatches, IsPojo::describeMethod);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText(this.cls().getSimpleName()).appendText(" {\n");
        this.methodHandlers().forEach((methodName, handler) -> {
            Matcher matcher = handler.matcher();
            description.appendText("  ").appendText(methodName).appendText("(): ");
            StringDescription innerDescription = new StringDescription();
            matcher.describeTo((Description)innerDescription);
            this.indentDescription(description, (Description)innerDescription);
        });
        description.appendText("}");
    }

    private static <A> Optional<Consumer<Description>> matchMethod(A item, MethodHandler<A, ?> handler) {
        Matcher<?> matcher = handler.matcher();
        MethodReference<A, ?> reference = handler.reference();
        try {
            Object value = reference.apply(item);
            if (!matcher.matches(value)) {
                return Optional.of(d -> matcher.describeMismatch(value, d));
            }
            return Optional.empty();
        }
        catch (IllegalAccessException e) {
            return Optional.of(d -> d.appendText("not accessible"));
        }
        catch (NoSuchMethodException e) {
            return Optional.of(d -> d.appendText("did not exist"));
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            return Optional.of(d -> d.appendText("threw an exception: ").appendText(cause.getClass().getCanonicalName()).appendText(": ").appendText(cause.getMessage()));
        }
        catch (Exception e) {
            return Optional.of(d -> d.appendText("threw an exception: ").appendText(e.getClass().getCanonicalName()).appendText(": ").appendText(e.getMessage()));
        }
    }

    private static void describeMethod(String name, Description description) {
        description.appendText(name).appendText("()");
    }

    private void indentDescription(Description description, Description innerDescription) {
        description.appendText(Joiner.on((String)"\n  ").join(Splitter.on((char)'\n').split((CharSequence)innerDescription.toString()))).appendText("\n");
    }

    private static SerializedLambda serializeLambda(Object lambda) {
        Method writeReplace;
        Objects.requireNonNull(lambda);
        try {
            writeReplace = AccessController.doPrivileged(() -> {
                Method method = lambda.getClass().getDeclaredMethod("writeReplace", new Class[0]);
                method.setAccessible(true);
                return method;
            });
        }
        catch (PrivilegedActionException e) {
            throw new IllegalStateException("Cannot serialize lambdas in unprivileged context", e);
        }
        try {
            return (SerializedLambda)writeReplace.invoke(lambda, new Object[0]);
        }
        catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("Could not serialize as a lambda (is it a lambda?): " + lambda, e);
        }
    }

    private static void ensureDirectMethodReference(SerializedLambda serializedLambda) {
        try {
            Class<?> implClass = Class.forName(serializedLambda.getImplClass().replace('/', '.'));
            if (Arrays.stream(implClass.getMethods()).noneMatch(m -> m.getName().equals(serializedLambda.getImplMethodName()) && !m.isSynthetic())) {
                throw new IllegalArgumentException("The supplied lambda is not a direct method reference");
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("serializeLambda returned a SerializedLambda pointing to an invalid class", e);
        }
    }

    static abstract class MethodHandler<A, T> {
        MethodHandler() {
        }

        abstract MethodReference<A, T> reference();

        abstract Matcher<T> matcher();

        static <A, T> MethodHandler<A, T> create(MethodReference<A, T> reference, Matcher<T> matcher) {
            return new AutoValue_IsPojo_MethodHandler<A, T>(reference, matcher);
        }
    }

    static abstract class Builder<A> {
        Builder() {
        }

        abstract Builder<A> cls(Class<A> var1);

        abstract ImmutableMap.Builder<String, MethodHandler<A, ?>> methodHandlersBuilder();

        Builder<A> methodHandler(String methodName, MethodHandler<A, ?> handler) {
            this.methodHandlersBuilder().put((Object)methodName, handler);
            return this;
        }

        abstract IsPojo<A> build();
    }
}

