/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import android.app.Application;
import android.app.PendingIntent;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import com.squareup.leakcanary.core.R;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import leakcanary.OnHeapAnalyzedListener;
import leakcanary.internal.InternalLeakCanary;
import leakcanary.internal.NotificationType;
import leakcanary.internal.Notifications;
import leakcanary.internal.activity.LeakActivity;
import leakcanary.internal.activity.db.HeapAnalysisTable;
import leakcanary.internal.activity.db.LeaksDbHelper;
import leakcanary.internal.activity.screen.HeapAnalysisFailureScreen;
import leakcanary.internal.activity.screen.HeapDumpScreen;
import leakcanary.internal.activity.screen.HeapDumpsScreen;
import leakcanary.internal.navigation.Screen;
import org.jetbrains.annotations.NotNull;
import shark.HeapAnalysis;
import shark.HeapAnalysisFailure;
import shark.HeapAnalysisSuccess;
import shark.Leak;
import shark.SharkLog;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lleakcanary/DefaultOnHeapAnalyzedListener;", "Lleakcanary/OnHeapAnalyzedListener;", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "onHeapAnalyzed", "", "heapAnalysis", "Lshark/HeapAnalysis;", "Companion", "leakcanary-android-core_release"})
public final class DefaultOnHeapAnalyzedListener
implements OnHeapAnalyzedListener {
    private final Application application;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void onHeapAnalyzed(@NotNull HeapAnalysis heapAnalysis) {
        void contentTitle;
        Pair pair;
        boolean bl;
        Object logger$iv;
        Intrinsics.checkParameterIsNotNull((Object)heapAnalysis, (String)"heapAnalysis");
        SharkLog this_$iv = SharkLog.INSTANCE;
        boolean $i$f$d = false;
        SharkLog.Logger logger = this_$iv.getLogger();
        if (logger == null) {
        } else {
            SharkLog.Logger logger2 = logger$iv = logger;
            bl = false;
            String string2 = String.valueOf(heapAnalysis);
            logger2.d(string2);
        }
        logger$iv = (Closeable)new LeaksDbHelper((Context)this.application).getWritableDatabase();
        bl = false;
        Throwable throwable = null;
        try {
            SQLiteDatabase db22 = (SQLiteDatabase)logger$iv;
            boolean bl2 = false;
            SQLiteDatabase sQLiteDatabase = db22;
            Intrinsics.checkExpressionValueIsNotNull((Object)sQLiteDatabase, (String)"db");
            long db22 = HeapAnalysisTable.INSTANCE.insert(sQLiteDatabase, heapAnalysis);
        }
        catch (Throwable db22) {
            throwable = db22;
            throw db22;
        }
        finally {
            CloseableKt.closeFinally((Closeable)logger$iv, (Throwable)throwable);
        }
        long id2 = db22;
        HeapAnalysis db22 = heapAnalysis;
        if (db22 instanceof HeapAnalysisFailure) {
            pair = TuplesKt.to((Object)this.application.getString(R.string.leak_canary_analysis_failed), (Object)new HeapAnalysisFailureScreen(id2));
        } else if (db22 instanceof HeapAnalysisSuccess) {
            Sequence $this$sumBy$iv = ((HeapAnalysisSuccess)heapAnalysis).getAllLeaks();
            boolean $i$f$sumBy = false;
            int sum$iv = 0;
            for (Object element$iv : $this$sumBy$iv) {
                void it;
                Leak leak = (Leak)element$iv;
                int n = sum$iv;
                boolean bl3 = false;
                int n2 = it.getLeakTraces().size();
                sum$iv = n + n2;
            }
            int retainedObjectCount = sum$iv;
            int leakTypeCount = ((HeapAnalysisSuccess)heapAnalysis).getApplicationLeaks().size() + ((HeapAnalysisSuccess)heapAnalysis).getLibraryLeaks().size();
            pair = TuplesKt.to((Object)this.application.getString(R.string.leak_canary_analysis_success_notification, new Object[]{retainedObjectCount, leakTypeCount}), (Object)new HeapDumpScreen(id2));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        throwable = pair;
        logger$iv = (String)throwable.component1();
        Screen screenToShow = (Screen)throwable.component2();
        PendingIntent pendingIntent = LeakActivity.Companion.createPendingIntent((Context)this.application, CollectionsKt.arrayListOf((Object[])new Screen[]{new HeapDumpsScreen(), screenToShow}));
        String string3 = this.application.getString(R.string.leak_canary_notification_message);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"application.getString(R.\u2026ary_notification_message)");
        String contentText = string3;
        Context context = (Context)this.application;
        void v5 = contentTitle;
        Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"contentTitle");
        Notifications.INSTANCE.showNotification(context, (CharSequence)v5, contentText, pendingIntent, R.id.leak_canary_notification_analysis_result, NotificationType.LEAKCANARY_MAX);
    }

    public DefaultOnHeapAnalyzedListener(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        this.application = application;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lleakcanary/DefaultOnHeapAnalyzedListener$Companion;", "", "()V", "create", "Lleakcanary/OnHeapAnalyzedListener;", "leakcanary-android-core_release"})
    public static final class Companion {
        @NotNull
        public final OnHeapAnalyzedListener create() {
            return new DefaultOnHeapAnalyzedListener(InternalLeakCanary.INSTANCE.getApplication());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

