/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.View;
import com.squareup.leakcanary.core.R;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.internal.DisplayLeakConnectorView$WhenMappings;
import leakcanary.internal.navigation.ViewsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0002\"#B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J$\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0016H\u0014J\u000e\u0010!\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lleakcanary/internal/DisplayLeakConnectorView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "cache", "Landroid/graphics/Bitmap;", "circleY", "", "classNamePaint", "Landroid/graphics/Paint;", "clearPaint", "leakPaint", "referencePaint", "strokeSize", "type", "Lleakcanary/internal/DisplayLeakConnectorView$Type;", "drawArrowHead", "", "cacheCanvas", "Landroid/graphics/Canvas;", "paint", "drawGcRoot", "drawInstanceCircle", "drawItems", "arrowHeadPaint", "nextArrowPaint", "drawNextArrowLine", "drawStartLine", "onDraw", "canvas", "setType", "Companion", "Type", "leakcanary-android-core_release"})
public final class DisplayLeakConnectorView
extends View {
    private final Paint classNamePaint;
    private final Paint leakPaint;
    private final Paint clearPaint;
    private final Paint referencePaint;
    private final float strokeSize;
    private final float circleY;
    private Type type;
    private Bitmap cache;
    private static final float SQRT_TWO;
    private static final PorterDuffXfermode CLEAR_XFER_MODE;
    public static final Companion Companion;

    /*
     * Unable to fully structure code
     */
    protected void onDraw(@NotNull Canvas canvas) {
        block22: {
            block20: {
                block21: {
                    Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
                    width = this.getMeasuredWidth();
                    height = this.getMeasuredHeight();
                    if (this.cache == null) break block20;
                    v0 = this.cache;
                    if (v0 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (v0.getWidth() != width) break block21;
                    v1 = this.cache;
                    if (v1 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (v1.getHeight() == height) break block20;
                }
                v2 = this.cache;
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                v2.recycle();
                this.cache = null;
            }
            if (this.cache != null) break block22;
            v3 = this.cache = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            if (v3 == null) {
                Intrinsics.throwNpe();
            }
            cacheCanvas = new Canvas(v3);
            v4 = this.type;
            if (v4 == null) ** GOTO lbl-1000
            switch (DisplayLeakConnectorView$WhenMappings.$EnumSwitchMapping$0[v4.ordinal()]) {
                case 1: {
                    this.drawItems(cacheCanvas, this.leakPaint, this.leakPaint);
                    break;
                }
                case 2: 
                case 3: {
                    this.drawItems(cacheCanvas, this.referencePaint, this.referencePaint);
                    break;
                }
                case 4: {
                    this.drawItems(cacheCanvas, this.leakPaint, this.referencePaint);
                    break;
                }
                case 5: {
                    this.drawItems(cacheCanvas, this.referencePaint, this.leakPaint);
                    break;
                }
                case 6: {
                    this.drawStartLine(cacheCanvas);
                    this.drawItems(cacheCanvas, null, this.referencePaint);
                    break;
                }
                case 7: {
                    this.drawStartLine(cacheCanvas);
                    this.drawItems(cacheCanvas, null, this.leakPaint);
                    break;
                }
                case 8: {
                    this.drawItems(cacheCanvas, this.referencePaint, null);
                    break;
                }
                case 9: {
                    this.drawItems(cacheCanvas, this.leakPaint, null);
                    break;
                }
                case 10: {
                    this.drawGcRoot(cacheCanvas);
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v5 = new StringBuilder().append("Unknown type ");
                    v6 = this.type;
                    if (v6 == null) {
                        Intrinsics.throwNpe();
                    }
                    throw (Throwable)new UnsupportedOperationException(v5.append((Object)v6).toString());
                }
            }
        }
        v7 = this.cache;
        if (v7 == null) {
            Intrinsics.throwNpe();
        }
        canvas.drawBitmap(v7, 0.0f, 0.0f, null);
    }

    private final void drawStartLine(Canvas cacheCanvas) {
        int width = this.getMeasuredWidth();
        float halfWidth = (float)width / 2.0f;
        cacheCanvas.drawLine(halfWidth, 0.0f, halfWidth, this.circleY, this.classNamePaint);
    }

    private final void drawGcRoot(Canvas cacheCanvas) {
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        float halfWidth = (float)width / 2.0f;
        cacheCanvas.drawLine(halfWidth, 0.0f, halfWidth, (float)height, this.classNamePaint);
    }

    private final void drawItems(Canvas cacheCanvas, Paint arrowHeadPaint, Paint nextArrowPaint) {
        if (arrowHeadPaint != null) {
            this.drawArrowHead(cacheCanvas, arrowHeadPaint);
        }
        if (nextArrowPaint != null) {
            this.drawNextArrowLine(cacheCanvas, nextArrowPaint);
        }
        this.drawInstanceCircle(cacheCanvas);
    }

    private final void drawArrowHead(Canvas cacheCanvas, Paint paint) {
        int width = this.getMeasuredWidth();
        float halfWidth = (float)width / 2.0f;
        float circleRadius = (float)width / 3.0f;
        float arrowHeight = halfWidth / (float)2 * SQRT_TWO;
        float halfStrokeSize = this.strokeSize / (float)2;
        float translateY = this.circleY - arrowHeight - circleRadius * (float)2 - this.strokeSize;
        float lineYEnd = this.circleY - circleRadius - this.strokeSize / (float)2;
        cacheCanvas.drawLine(halfWidth, 0.0f, halfWidth, lineYEnd, paint);
        cacheCanvas.translate(halfWidth, translateY);
        cacheCanvas.rotate(45.0f);
        cacheCanvas.drawLine(0.0f, halfWidth, halfWidth + halfStrokeSize, halfWidth, paint);
        cacheCanvas.drawLine(halfWidth, 0.0f, halfWidth, halfWidth, paint);
        cacheCanvas.rotate(-45.0f);
        cacheCanvas.translate(-halfWidth, -translateY);
    }

    private final void drawNextArrowLine(Canvas cacheCanvas, Paint paint) {
        int height = this.getMeasuredHeight();
        int width = this.getMeasuredWidth();
        float centerX = (float)width / 2.0f;
        cacheCanvas.drawLine(centerX, this.circleY, centerX, (float)height, paint);
    }

    private final void drawInstanceCircle(Canvas cacheCanvas) {
        int width = this.getMeasuredWidth();
        float circleX = (float)width / 2.0f;
        float circleRadius = (float)width / 3.0f;
        cacheCanvas.drawCircle(circleX, this.circleY, circleRadius, this.classNamePaint);
    }

    public final void setType(@NotNull Type type) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        if (type != this.type) {
            this.type = type;
            if (this.cache != null) {
                Bitmap bitmap = this.cache;
                if (bitmap == null) {
                    Intrinsics.throwNpe();
                }
                bitmap.recycle();
                this.cache = null;
            }
            this.invalidate();
        }
    }

    public DisplayLeakConnectorView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        Resources resources = this.getResources();
        this.type = Type.NODE_UNKNOWN;
        this.circleY = resources.getDimensionPixelSize(R.dimen.leak_canary_connector_center_y);
        this.strokeSize = resources.getDimensionPixelSize(R.dimen.leak_canary_connector_stroke_size);
        this.classNamePaint = new Paint(1);
        this.classNamePaint.setColor(ViewsKt.getColorCompat(context, R.color.leak_canary_class_name));
        this.classNamePaint.setStrokeWidth(this.strokeSize);
        this.leakPaint = new Paint(1);
        this.leakPaint.setColor(ViewsKt.getColorCompat(context, R.color.leak_canary_leak));
        this.leakPaint.setStyle(Paint.Style.STROKE);
        this.leakPaint.setStrokeWidth(this.strokeSize);
        float pathLines = resources.getDimensionPixelSize(R.dimen.leak_canary_connector_leak_dash_line);
        float pathGaps = resources.getDimensionPixelSize(R.dimen.leak_canary_connector_leak_dash_gap);
        this.leakPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{pathLines, pathGaps}, 0.0f));
        this.clearPaint = new Paint(1);
        this.clearPaint.setColor(0);
        this.clearPaint.setXfermode((Xfermode)CLEAR_XFER_MODE);
        this.referencePaint = new Paint(1);
        this.referencePaint.setColor(ViewsKt.getColorCompat(context, R.color.leak_canary_reference));
        this.referencePaint.setStrokeWidth(this.strokeSize);
    }

    static {
        Companion = new Companion(null);
        double d = 2.0;
        boolean bl = false;
        SQRT_TWO = (float)Math.sqrt(d);
        CLEAR_XFER_MODE = new PorterDuffXfermode(PorterDuff.Mode.CLEAR);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\f\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lleakcanary/internal/DisplayLeakConnectorView$Type;", "", "(Ljava/lang/String;I)V", "GC_ROOT", "START", "START_LAST_REACHABLE", "NODE_UNKNOWN", "NODE_FIRST_UNREACHABLE", "NODE_UNREACHABLE", "NODE_REACHABLE", "NODE_LAST_REACHABLE", "END", "END_FIRST_UNREACHABLE", "leakcanary-android-core_release"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type GC_ROOT;
        public static final /* enum */ Type START;
        public static final /* enum */ Type START_LAST_REACHABLE;
        public static final /* enum */ Type NODE_UNKNOWN;
        public static final /* enum */ Type NODE_FIRST_UNREACHABLE;
        public static final /* enum */ Type NODE_UNREACHABLE;
        public static final /* enum */ Type NODE_REACHABLE;
        public static final /* enum */ Type NODE_LAST_REACHABLE;
        public static final /* enum */ Type END;
        public static final /* enum */ Type END_FIRST_UNREACHABLE;
        private static final /* synthetic */ Type[] $VALUES;

        static {
            Type[] typeArray = new Type[10];
            Type[] typeArray2 = typeArray;
            typeArray[0] = GC_ROOT = new Type();
            typeArray[1] = START = new Type();
            typeArray[2] = START_LAST_REACHABLE = new Type();
            typeArray[3] = NODE_UNKNOWN = new Type();
            typeArray[4] = NODE_FIRST_UNREACHABLE = new Type();
            typeArray[5] = NODE_UNREACHABLE = new Type();
            typeArray[6] = NODE_REACHABLE = new Type();
            typeArray[7] = NODE_LAST_REACHABLE = new Type();
            typeArray[8] = END = new Type();
            typeArray[9] = END_FIRST_UNREACHABLE = new Type();
            $VALUES = typeArray;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string2) {
            return Enum.valueOf(Type.class, string2);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lleakcanary/internal/DisplayLeakConnectorView$Companion;", "", "()V", "CLEAR_XFER_MODE", "Landroid/graphics/PorterDuffXfermode;", "SQRT_TWO", "", "leakcanary-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

