/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Process;
import com.squareup.leakcanary.core.R;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import leakcanary.LeakCanary;
import leakcanary.internal.ForegroundService;
import leakcanary.internal.LeakDirectoryProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.HeapAnalysis;
import shark.HeapAnalysisException;
import shark.HeapAnalysisFailure;
import shark.HeapAnalyzer;
import shark.OnAnalysisProgressListener;
import shark.ProguardMapping;
import shark.ProguardMappingReader;
import shark.SharkLog;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014\u00a8\u0006\u0014"}, d2={"Lleakcanary/internal/HeapAnalyzerService;", "Lleakcanary/internal/ForegroundService;", "Lshark/OnAnalysisProgressListener;", "()V", "analyzeHeap", "Lshark/HeapAnalysis;", "heapDumpFile", "Ljava/io/File;", "config", "Lleakcanary/LeakCanary$Config;", "missingFileFailure", "Lshark/HeapAnalysisFailure;", "onAnalysisProgress", "", "step", "Lshark/OnAnalysisProgressListener$Step;", "onHandleIntentInForeground", "intent", "Landroid/content/Intent;", "Companion", "leakcanary-android-core_release"})
public final class HeapAnalyzerService
extends ForegroundService
implements OnAnalysisProgressListener {
    private static final String HEAPDUMP_FILE_EXTRA = "HEAPDUMP_FILE_EXTRA";
    private static final String PROGUARD_MAPPING_FILE_NAME = "leakCanaryObfuscationMapping.txt";
    public static final Companion Companion = new Companion(null);

    @Override
    protected void onHandleIntentInForeground(@Nullable Intent intent) {
        if (intent == null || !intent.hasExtra(HEAPDUMP_FILE_EXTRA)) {
            SharkLog this_$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger = this_$iv.getLogger();
            if (logger == null) {
            } else {
                SharkLog.Logger logger$iv;
                SharkLog.Logger logger2 = logger$iv = logger;
                boolean bl = false;
                String string2 = "HeapAnalyzerService received a null or empty intent, ignoring.";
                logger2.d(string2);
            }
            return;
        }
        Process.setThreadPriority((int)10);
        Serializable serializable = intent.getSerializableExtra(HEAPDUMP_FILE_EXTRA);
        if (serializable == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.io.File");
        }
        File heapDumpFile = (File)serializable;
        LeakCanary.Config config = LeakCanary.INSTANCE.getConfig();
        HeapAnalysis heapAnalysis = heapDumpFile.exists() ? this.analyzeHeap(heapDumpFile, config) : (HeapAnalysis)this.missingFileFailure(heapDumpFile);
        this.onAnalysisProgress(OnAnalysisProgressListener.Step.REPORTING_HEAP_ANALYSIS);
        config.getOnHeapAnalyzedListener().onHeapAnalyzed(heapAnalysis);
    }

    private final HeapAnalysis analyzeHeap(File heapDumpFile, LeakCanary.Config config) {
        ProguardMappingReader proguardMappingReader;
        HeapAnalyzer heapAnalyzer = new HeapAnalyzer((OnAnalysisProgressListener)this);
        try {
            InputStream inputStream = this.getAssets().open(PROGUARD_MAPPING_FILE_NAME);
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"assets.open(PROGUARD_MAPPING_FILE_NAME)");
            proguardMappingReader = new ProguardMappingReader(inputStream);
        }
        catch (IOException e) {
            proguardMappingReader = null;
        }
        ProguardMappingReader proguardMappingReader2 = proguardMappingReader;
        ProguardMappingReader proguardMappingReader3 = proguardMappingReader2;
        return heapAnalyzer.analyze(heapDumpFile, config.getLeakingObjectFinder(), config.getReferenceMatchers(), config.getComputeRetainedHeapSize(), config.getObjectInspectors(), config.getMetatadaExtractor(), (ProguardMapping)(proguardMappingReader3 != null ? proguardMappingReader3.readProguardMapping() : null));
    }

    private final HeapAnalysisFailure missingFileFailure(File heapDumpFile) {
        String deletedReason = LeakDirectoryProvider.Companion.hprofDeleteReason(heapDumpFile);
        IllegalStateException exception = new IllegalStateException("Hprof file " + heapDumpFile + " missing, deleted because: " + deletedReason);
        return new HeapAnalysisFailure(heapDumpFile, System.currentTimeMillis(), 0L, new HeapAnalysisException((Throwable)exception));
    }

    public void onAnalysisProgress(@NotNull OnAnalysisProgressListener.Step step) {
        String string2;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)step, (String)"step");
        int percent = (int)(100.0f * (float)step.ordinal() / (float)OnAnalysisProgressListener.Step.values().length);
        SharkLog this_$iv = SharkLog.INSTANCE;
        boolean $i$f$d22 = false;
        SharkLog.Logger logger = this_$iv.getLogger();
        if (logger == null) {
        } else {
            SharkLog.Logger logger$iv = logger;
            object = logger$iv;
            boolean bl = false;
            string2 = "Analysis in progress, working on: " + step.name();
            object.d(string2);
        }
        String $i$f$d22 = StringsKt.replace$default((String)step.name(), (String)"_", (String)" ", (boolean)false, (int)4, null);
        Locale locale = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
        Object object2 = locale;
        int n = 0;
        String string3 = $i$f$d22;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase((Locale)object2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        String lowercase = string4;
        object2 = lowercase;
        n = 0;
        int n2 = 1;
        object = new StringBuilder();
        boolean bl = false;
        Object object3 = object2;
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = ((String)object3).substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string2 = string5;
        object2 = string2;
        Locale locale2 = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"Locale.US");
        Locale locale3 = locale2;
        n2 = 0;
        Object object4 = object2;
        if (object4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = ((String)object4).toUpperCase(locale3);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toUpperCase(locale)");
        string2 = string6;
        object2 = lowercase;
        int n3 = 1;
        object = ((StringBuilder)object).append(string2);
        n2 = 0;
        Object object5 = object2;
        if (object5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string7 = ((String)object5).substring(n3);
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
        string2 = string7;
        String message = ((StringBuilder)object).append(string2).toString();
        this.showForegroundNotification(100, percent, false, message);
    }

    public HeapAnalyzerService() {
        String string2 = HeapAnalyzerService.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"HeapAnalyzerService::class.java.simpleName");
        super(string2, R.string.leak_canary_notification_analysing, R.id.leak_canary_notification_analyzing_heap);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lleakcanary/internal/HeapAnalyzerService$Companion;", "", "()V", "HEAPDUMP_FILE_EXTRA", "", "PROGUARD_MAPPING_FILE_NAME", "runAnalysis", "", "context", "Landroid/content/Context;", "heapDumpFile", "Ljava/io/File;", "startForegroundService", "intent", "Landroid/content/Intent;", "leakcanary-android-core_release"})
    public static final class Companion {
        public final void runAnalysis(@NotNull Context context, @NotNull File heapDumpFile) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)heapDumpFile, (String)"heapDumpFile");
            Intent intent = new Intent(context, HeapAnalyzerService.class);
            intent.putExtra(HeapAnalyzerService.HEAPDUMP_FILE_EXTRA, (Serializable)heapDumpFile);
            this.startForegroundService(context, intent);
        }

        private final void startForegroundService(Context context, Intent intent) {
            if (Build.VERSION.SDK_INT >= 26) {
                context.startForegroundService(intent);
            } else {
                context.startService(intent);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

