/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import android.app.Application;
import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.os.SystemClock;
import com.squareup.leakcanary.core.R;
import java.io.File;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.AppWatcher;
import leakcanary.GcTrigger;
import leakcanary.KeyedWeakReference;
import leakcanary.LeakCanary;
import leakcanary.ObjectWatcher;
import leakcanary.internal.DebuggerControl;
import leakcanary.internal.HeapAnalyzerService;
import leakcanary.internal.HeapDumpTrigger$sam$java_lang_Runnable$0;
import leakcanary.internal.HeapDumper;
import leakcanary.internal.NotificationReceiver;
import leakcanary.internal.NotificationType;
import leakcanary.internal.Notifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.AndroidResourceIdNames;
import shark.SharkLog;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0013\b\u0000\u0018\u0000 :2\u00020\u0001:\u0001:B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001aH\u0002J\u0010\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020!H\u0002J\b\u0010*\u001a\u00020!H\u0002J\u0018\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u0013H\u0002J\u000e\u0010.\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0013J\u000e\u0010/\u001a\u00020!2\u0006\u00100\u001a\u00020\u0013J\u0006\u00101\u001a\u00020!J\b\u00102\u001a\u00020!H\u0002J\"\u00103\u001a\u00020!2\u0006\u0010'\u001a\u00020(2\u0006\u00104\u001a\u00020\u00132\b\b\u0002\u00105\u001a\u00020\u0011H\u0002J\b\u00106\u001a\u00020!H\u0002J\u0018\u00107\u001a\u00020!2\u0006\u00108\u001a\u00020\u001a2\u0006\u00109\u001a\u00020(H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lleakcanary/internal/HeapDumpTrigger;", "", "application", "Landroid/app/Application;", "backgroundHandler", "Landroid/os/Handler;", "objectWatcher", "Lleakcanary/ObjectWatcher;", "gcTrigger", "Lleakcanary/GcTrigger;", "heapDumper", "Lleakcanary/internal/HeapDumper;", "configProvider", "Lkotlin/Function0;", "Lleakcanary/LeakCanary$Config;", "(Landroid/app/Application;Landroid/os/Handler;Lleakcanary/ObjectWatcher;Lleakcanary/GcTrigger;Lleakcanary/internal/HeapDumper;Lkotlin/jvm/functions/Function0;)V", "applicationInvisibleAt", "", "applicationInvisibleLessThanWatchPeriod", "", "getApplicationInvisibleLessThanWatchPeriod", "()Z", "applicationVisible", "getApplicationVisible", "checkScheduledAt", "lastDisplayedRetainedObjectCount", "", "lastHeapDumpUptimeMillis", "notificationManager", "Landroid/app/NotificationManager;", "getNotificationManager", "()Landroid/app/NotificationManager;", "scheduleDismissNoRetainedOnTapNotification", "", "scheduleDismissRetainedCountNotification", "checkRetainedCount", "retainedKeysCount", "retainedVisibleThreshold", "checkRetainedObjects", "reason", "", "dismissNoRetainedOnTapNotification", "dismissRetainedCountNotification", "dumpHeap", "retainedReferenceCount", "retry", "onApplicationVisibilityChanged", "onDumpHeapReceived", "forceDump", "onObjectRetained", "saveResourceIdNamesToMemory", "scheduleRetainedObjectCheck", "rescheduling", "delayMillis", "showNoMoreRetainedObjectNotification", "showRetainedCountNotification", "objectCount", "contentText", "Companion", "leakcanary-android-core_release"})
public final class HeapDumpTrigger {
    private volatile long checkScheduledAt;
    private int lastDisplayedRetainedObjectCount;
    private long lastHeapDumpUptimeMillis;
    private final Function0<Unit> scheduleDismissRetainedCountNotification;
    private final Function0<Unit> scheduleDismissNoRetainedOnTapNotification;
    private volatile long applicationInvisibleAt;
    private final Application application;
    private final Handler backgroundHandler;
    private final ObjectWatcher objectWatcher;
    private final GcTrigger gcTrigger;
    private final HeapDumper heapDumper;
    private final Function0<LeakCanary.Config> configProvider;
    private static final long WAIT_FOR_DEBUG_MILLIS = 20000L;
    private static final long WAIT_AFTER_DUMP_FAILED_MILLIS = 5000L;
    private static final long WAIT_FOR_OBJECT_THRESHOLD_MILLIS = 2000L;
    private static final long DISMISS_NO_RETAINED_OBJECT_NOTIFICATION_MILLIS = 30000L;
    private static final long WAIT_BETWEEN_HEAP_DUMPS_MILLIS = 60000L;
    public static final Companion Companion = new Companion(null);

    private final NotificationManager getNotificationManager() {
        Object object = this.application.getSystemService("notification");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        return (NotificationManager)object;
    }

    private final boolean getApplicationVisible() {
        return this.applicationInvisibleAt == -1L;
    }

    private final boolean getApplicationInvisibleLessThanWatchPeriod() {
        long applicationInvisibleAt = this.applicationInvisibleAt;
        return applicationInvisibleAt != -1L && SystemClock.uptimeMillis() - applicationInvisibleAt < AppWatcher.INSTANCE.getConfig().getWatchDurationMillis();
    }

    public final void onApplicationVisibilityChanged(boolean applicationVisible) {
        if (applicationVisible) {
            this.applicationInvisibleAt = -1L;
        } else {
            this.applicationInvisibleAt = SystemClock.uptimeMillis();
            this.scheduleRetainedObjectCheck("app became invisible", false, AppWatcher.INSTANCE.getConfig().getWatchDurationMillis());
        }
    }

    public final void onObjectRetained() {
        HeapDumpTrigger.scheduleRetainedObjectCheck$default(this, "found new object retained", false, 0L, 4, null);
    }

    private final void checkRetainedObjects(String reason) {
        LeakCanary.Config config = (LeakCanary.Config)this.configProvider.invoke();
        if (!config.getDumpHeap()) {
            SharkLog this_$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger = this_$iv.getLogger();
            if (logger == null) {
            } else {
                SharkLog.Logger logger$iv;
                SharkLog.Logger logger2 = logger$iv = logger;
                boolean bl = false;
                String string2 = "Ignoring check for retained objects scheduled because " + reason + ": LeakCanary.Config.dumpHeap is false";
                logger2.d(string2);
            }
            return;
        }
        int retainedReferenceCount = this.objectWatcher.getRetainedObjectCount();
        if (retainedReferenceCount > 0) {
            this.gcTrigger.runGc();
            retainedReferenceCount = this.objectWatcher.getRetainedObjectCount();
        }
        if (this.checkRetainedCount(retainedReferenceCount, config.getRetainedVisibleThreshold())) {
            return;
        }
        if (!config.getDumpHeapWhenDebugging() && DebuggerControl.INSTANCE.isDebuggerAttached()) {
            String string3 = this.application.getString(R.string.leak_canary_notification_retained_debugger_attached);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"application.getString(\n \u2026gger_attached\n          )");
            this.showRetainedCountNotification(retainedReferenceCount, string3);
            this.scheduleRetainedObjectCheck("debugger is attached", true, 20000L);
            return;
        }
        long now = SystemClock.uptimeMillis();
        long elapsedSinceLastDumpMillis = now - this.lastHeapDumpUptimeMillis;
        if (elapsedSinceLastDumpMillis < 60000L) {
            String string4 = this.application.getString(R.string.leak_canary_notification_retained_dump_wait);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"application.getString(R.\u2026ation_retained_dump_wait)");
            this.showRetainedCountNotification(retainedReferenceCount, string4);
            this.scheduleRetainedObjectCheck("previous heap dump was " + elapsedSinceLastDumpMillis + "ms ago (< 60000ms)", true, 60000L - elapsedSinceLastDumpMillis);
            return;
        }
        SharkLog this_$iv = SharkLog.INSTANCE;
        boolean $i$f$d = false;
        SharkLog.Logger logger = this_$iv.getLogger();
        if (logger == null) {
        } else {
            SharkLog.Logger logger$iv;
            SharkLog.Logger logger3 = logger$iv = logger;
            boolean bl = false;
            String string5 = "Check for retained objects found " + retainedReferenceCount + " objects, dumping the heap";
            logger3.d(string5);
        }
        this.dismissRetainedCountNotification();
        this.dumpHeap(retainedReferenceCount, true);
    }

    private final void dumpHeap(int retainedReferenceCount, boolean retry) {
        this.saveResourceIdNamesToMemory();
        long heapDumpUptimeMillis = SystemClock.uptimeMillis();
        KeyedWeakReference.Companion.setHeapDumpUptimeMillis(heapDumpUptimeMillis);
        File heapDumpFile = this.heapDumper.dumpHeap();
        if (heapDumpFile == null) {
            if (retry) {
                SharkLog this_$iv = SharkLog.INSTANCE;
                boolean $i$f$d = false;
                SharkLog.Logger logger = this_$iv.getLogger();
                if (logger == null) {
                } else {
                    SharkLog.Logger logger$iv;
                    SharkLog.Logger logger2 = logger$iv = logger;
                    boolean bl = false;
                    String string2 = "Failed to dump heap, will retry in 5000 ms";
                    logger2.d(string2);
                }
                this.scheduleRetainedObjectCheck("failed to dump heap", true, 5000L);
            } else {
                SharkLog this_$iv = SharkLog.INSTANCE;
                boolean $i$f$d = false;
                SharkLog.Logger logger = this_$iv.getLogger();
                if (logger == null) {
                } else {
                    SharkLog.Logger logger$iv;
                    SharkLog.Logger logger3 = logger$iv = logger;
                    boolean bl = false;
                    String string3 = "Failed to dump heap, will not automatically retry";
                    logger3.d(string3);
                }
            }
            String string4 = this.application.getString(R.string.leak_canary_notification_retained_dump_failed);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"application.getString(\n \u2026d_dump_failed\n          )");
            this.showRetainedCountNotification(retainedReferenceCount, string4);
            return;
        }
        this.lastDisplayedRetainedObjectCount = 0;
        this.lastHeapDumpUptimeMillis = SystemClock.uptimeMillis();
        this.objectWatcher.clearObjectsWatchedBefore(heapDumpUptimeMillis);
        HeapAnalyzerService.Companion.runAnalysis((Context)this.application, heapDumpFile);
    }

    private final void saveResourceIdNamesToMemory() {
        Resources resources = this.application.getResources();
        AndroidResourceIdNames.Companion.saveToMemory((Function1)new Function1<Integer, String>(resources){
            final /* synthetic */ Resources $resources;

            @Nullable
            public final String invoke(int id2) {
                String string2;
                try {
                    string2 = this.$resources.getResourceTypeName(id2);
                }
                catch (Resources.NotFoundException e) {
                    string2 = null;
                }
                return string2;
            }
            {
                this.$resources = resources;
                super(1);
            }
        }, (Function1)new Function1<Integer, String>(resources){
            final /* synthetic */ Resources $resources;

            @Nullable
            public final String invoke(int id2) {
                String string2;
                try {
                    string2 = this.$resources.getResourceEntryName(id2);
                }
                catch (Resources.NotFoundException e) {
                    string2 = null;
                }
                return string2;
            }
            {
                this.$resources = resources;
                super(1);
            }
        });
    }

    public final void onDumpHeapReceived(boolean forceDump) {
        this.backgroundHandler.post(new Runnable(this, forceDump){
            final /* synthetic */ HeapDumpTrigger this$0;
            final /* synthetic */ boolean $forceDump;

            public final void run() {
                HeapDumpTrigger.access$dismissNoRetainedOnTapNotification(this.this$0);
                HeapDumpTrigger.access$getGcTrigger$p(this.this$0).runGc();
                int retainedReferenceCount = HeapDumpTrigger.access$getObjectWatcher$p(this.this$0).getRetainedObjectCount();
                if (!this.$forceDump && retainedReferenceCount == 0) {
                    SharkLog.Logger logger$iv;
                    SharkLog this_$iv = SharkLog.INSTANCE;
                    boolean $i$f$d = false;
                    SharkLog.Logger logger = this_$iv.getLogger();
                    if (logger == null) {
                    } else {
                        SharkLog.Logger logger2 = logger$iv = logger;
                        boolean bl = false;
                        String string2 = "Ignoring user request to dump heap: no retained objects remaining after GC";
                        logger2.d(string2);
                    }
                    Notification.Builder builder = new Notification.Builder((Context)HeapDumpTrigger.access$getApplication$p(this.this$0)).setContentTitle((CharSequence)HeapDumpTrigger.access$getApplication$p(this.this$0).getString(R.string.leak_canary_notification_no_retained_object_title)).setContentText((CharSequence)HeapDumpTrigger.access$getApplication$p(this.this$0).getString(R.string.leak_canary_notification_no_retained_object_content)).setAutoCancel(true).setContentIntent(NotificationReceiver.Companion.pendingIntent((Context)HeapDumpTrigger.access$getApplication$p(this.this$0), NotificationReceiver.Action.CANCEL_NOTIFICATION));
                    Context context = (Context)HeapDumpTrigger.access$getApplication$p(this.this$0);
                    Notification.Builder builder2 = builder;
                    Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"builder");
                    Notification notification = Notifications.INSTANCE.buildNotification(context, builder2, NotificationType.LEAKCANARY_LOW);
                    HeapDumpTrigger.access$getNotificationManager$p(this.this$0).notify(R.id.leak_canary_notification_no_retained_object_on_tap, notification);
                    Handler handler = HeapDumpTrigger.access$getBackgroundHandler$p(this.this$0);
                    Object object = HeapDumpTrigger.access$getScheduleDismissNoRetainedOnTapNotification$p(this.this$0);
                    if (object != null) {
                        logger$iv = object;
                        object = new HeapDumpTrigger$sam$java_lang_Runnable$0((Function0)logger$iv);
                    }
                    handler.postDelayed((Runnable)object, 30000L);
                    HeapDumpTrigger.access$setLastDisplayedRetainedObjectCount$p(this.this$0, 0);
                    return;
                }
                SharkLog this_$iv = SharkLog.INSTANCE;
                boolean $i$f$d = false;
                SharkLog.Logger logger = this_$iv.getLogger();
                if (logger == null) {
                } else {
                    SharkLog.Logger logger$iv;
                    SharkLog.Logger logger3 = logger$iv = logger;
                    boolean bl = false;
                    String string3 = "Dumping the heap because user requested it";
                    logger3.d(string3);
                }
                HeapDumpTrigger.access$dumpHeap(this.this$0, retainedReferenceCount, false);
            }
            {
                this.this$0 = heapDumpTrigger;
                this.$forceDump = bl;
            }
        });
    }

    private final boolean checkRetainedCount(int retainedKeysCount, int retainedVisibleThreshold) {
        boolean countChanged = this.lastDisplayedRetainedObjectCount != retainedKeysCount;
        this.lastDisplayedRetainedObjectCount = retainedKeysCount;
        if (retainedKeysCount == 0) {
            SharkLog this_$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger = this_$iv.getLogger();
            if (logger == null) {
            } else {
                SharkLog.Logger logger$iv;
                SharkLog.Logger logger2 = logger$iv = logger;
                boolean bl = false;
                String string2 = "Check for retained object found no objects remaining";
                logger2.d(string2);
            }
            if (countChanged) {
                this.showNoMoreRetainedObjectNotification();
            }
            return true;
        }
        if (retainedKeysCount < retainedVisibleThreshold && (this.getApplicationVisible() || this.getApplicationInvisibleLessThanWatchPeriod())) {
            String string3 = this.application.getString(R.string.leak_canary_notification_retained_visible, new Object[]{retainedVisibleThreshold});
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"application.getString(\n \u2026leThreshold\n            )");
            this.showRetainedCountNotification(retainedKeysCount, string3);
            this.scheduleRetainedObjectCheck("found only " + retainedKeysCount + " retained objects (< " + retainedVisibleThreshold + " while app visible)", true, 2000L);
            return true;
        }
        return false;
    }

    private final void scheduleRetainedObjectCheck(String reason, boolean rescheduling, long delayMillis) {
        long checkCurrentlyScheduledAt = this.checkScheduledAt;
        if (checkCurrentlyScheduledAt > 0L) {
            long scheduledIn = checkCurrentlyScheduledAt - SystemClock.uptimeMillis();
            SharkLog this_$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger = this_$iv.getLogger();
            if (logger == null) {
            } else {
                SharkLog.Logger logger$iv;
                SharkLog.Logger logger2 = logger$iv = logger;
                boolean bl = false;
                String string2 = "Ignoring request to check for retained objects (" + reason + "), already scheduled in " + scheduledIn + "ms";
                logger2.d(string2);
            }
            return;
        }
        String verb = rescheduling ? "Rescheduling" : "Scheduling";
        String delay = delayMillis > 0L ? " in " + delayMillis + "ms" : "";
        SharkLog this_$iv = SharkLog.INSTANCE;
        boolean $i$f$d = false;
        SharkLog.Logger logger = this_$iv.getLogger();
        if (logger == null) {
        } else {
            SharkLog.Logger logger$iv;
            SharkLog.Logger logger3 = logger$iv = logger;
            boolean bl = false;
            String string3 = verb + " check for retained objects" + delay + " because " + reason;
            logger3.d(string3);
        }
        this.checkScheduledAt = SystemClock.uptimeMillis() + delayMillis;
        this.backgroundHandler.postDelayed(new Runnable(this, reason){
            final /* synthetic */ HeapDumpTrigger this$0;
            final /* synthetic */ String $reason;

            public final void run() {
                HeapDumpTrigger.access$setCheckScheduledAt$p(this.this$0, 0L);
                HeapDumpTrigger.access$checkRetainedObjects(this.this$0, this.$reason);
            }
            {
                this.this$0 = heapDumpTrigger;
                this.$reason = string2;
            }
        }, delayMillis);
    }

    static /* synthetic */ void scheduleRetainedObjectCheck$default(HeapDumpTrigger heapDumpTrigger, String string2, boolean bl, long l, int n, Object object) {
        if ((n & 4) != 0) {
            l = 0L;
        }
        heapDumpTrigger.scheduleRetainedObjectCheck(string2, bl, l);
    }

    private final void showNoMoreRetainedObjectNotification() {
        Object object = this.scheduleDismissRetainedCountNotification;
        if (object != null) {
            Function0<Unit> function0 = object;
            object = new HeapDumpTrigger$sam$java_lang_Runnable$0(function0);
        }
        this.backgroundHandler.removeCallbacks((Runnable)object);
        if (!Notifications.INSTANCE.getCanShowNotification()) {
            return;
        }
        Notification.Builder builder = new Notification.Builder((Context)this.application).setContentTitle((CharSequence)this.application.getString(R.string.leak_canary_notification_no_retained_object_title)).setContentText((CharSequence)this.application.getString(R.string.leak_canary_notification_no_retained_object_content)).setAutoCancel(true).setContentIntent(NotificationReceiver.Companion.pendingIntent((Context)this.application, NotificationReceiver.Action.CANCEL_NOTIFICATION));
        Context context = (Context)this.application;
        Notification.Builder builder2 = builder;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"builder");
        Notification notification = Notifications.INSTANCE.buildNotification(context, builder2, NotificationType.LEAKCANARY_LOW);
        this.getNotificationManager().notify(R.id.leak_canary_notification_retained_objects, notification);
        Object object2 = this.scheduleDismissRetainedCountNotification;
        if (object2 != null) {
            Function0<Unit> function0 = object2;
            object2 = new HeapDumpTrigger$sam$java_lang_Runnable$0(function0);
        }
        this.backgroundHandler.postDelayed((Runnable)object2, 30000L);
    }

    private final void showRetainedCountNotification(int objectCount, String contentText) {
        Object object = this.scheduleDismissRetainedCountNotification;
        if (object != null) {
            Function0<Unit> function0 = object;
            object = new HeapDumpTrigger$sam$java_lang_Runnable$0(function0);
        }
        this.backgroundHandler.removeCallbacks((Runnable)object);
        if (!Notifications.INSTANCE.getCanShowNotification()) {
            return;
        }
        Notification.Builder builder = new Notification.Builder((Context)this.application).setContentTitle((CharSequence)this.application.getString(R.string.leak_canary_notification_retained_title, new Object[]{objectCount})).setContentText((CharSequence)contentText).setAutoCancel(true).setContentIntent(NotificationReceiver.Companion.pendingIntent((Context)this.application, NotificationReceiver.Action.DUMP_HEAP));
        Context context = (Context)this.application;
        Notification.Builder builder2 = builder;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"builder");
        Notification notification = Notifications.INSTANCE.buildNotification(context, builder2, NotificationType.LEAKCANARY_LOW);
        this.getNotificationManager().notify(R.id.leak_canary_notification_retained_objects, notification);
    }

    private final void dismissRetainedCountNotification() {
        Object object = this.scheduleDismissRetainedCountNotification;
        if (object != null) {
            Function0<Unit> function0 = object;
            object = new HeapDumpTrigger$sam$java_lang_Runnable$0(function0);
        }
        this.backgroundHandler.removeCallbacks((Runnable)object);
        this.getNotificationManager().cancel(R.id.leak_canary_notification_retained_objects);
    }

    private final void dismissNoRetainedOnTapNotification() {
        Object object = this.scheduleDismissNoRetainedOnTapNotification;
        if (object != null) {
            Function0<Unit> function0 = object;
            object = new HeapDumpTrigger$sam$java_lang_Runnable$0(function0);
        }
        this.backgroundHandler.removeCallbacks((Runnable)object);
        this.getNotificationManager().cancel(R.id.leak_canary_notification_no_retained_object_on_tap);
    }

    public HeapDumpTrigger(@NotNull Application application, @NotNull Handler backgroundHandler, @NotNull ObjectWatcher objectWatcher, @NotNull GcTrigger gcTrigger, @NotNull HeapDumper heapDumper, @NotNull Function0<LeakCanary.Config> configProvider2) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)backgroundHandler, (String)"backgroundHandler");
        Intrinsics.checkParameterIsNotNull((Object)objectWatcher, (String)"objectWatcher");
        Intrinsics.checkParameterIsNotNull((Object)gcTrigger, (String)"gcTrigger");
        Intrinsics.checkParameterIsNotNull((Object)heapDumper, (String)"heapDumper");
        Intrinsics.checkParameterIsNotNull(configProvider2, (String)"configProvider");
        this.application = application;
        this.backgroundHandler = backgroundHandler;
        this.objectWatcher = objectWatcher;
        this.gcTrigger = gcTrigger;
        this.heapDumper = heapDumper;
        this.configProvider = configProvider2;
        this.scheduleDismissRetainedCountNotification = (Function0)new Function0<Unit>(this){
            final /* synthetic */ HeapDumpTrigger this$0;

            public final void invoke() {
                HeapDumpTrigger.access$dismissRetainedCountNotification(this.this$0);
            }
            {
                this.this$0 = heapDumpTrigger;
                super(0);
            }
        };
        this.scheduleDismissNoRetainedOnTapNotification = (Function0)new Function0<Unit>(this){
            final /* synthetic */ HeapDumpTrigger this$0;

            public final void invoke() {
                HeapDumpTrigger.access$dismissNoRetainedOnTapNotification(this.this$0);
            }
            {
                this.this$0 = heapDumpTrigger;
                super(0);
            }
        };
        this.applicationInvisibleAt = -1L;
    }

    public static final /* synthetic */ void access$dismissNoRetainedOnTapNotification(HeapDumpTrigger $this) {
        $this.dismissNoRetainedOnTapNotification();
    }

    public static final /* synthetic */ GcTrigger access$getGcTrigger$p(HeapDumpTrigger $this) {
        return $this.gcTrigger;
    }

    public static final /* synthetic */ ObjectWatcher access$getObjectWatcher$p(HeapDumpTrigger $this) {
        return $this.objectWatcher;
    }

    public static final /* synthetic */ Application access$getApplication$p(HeapDumpTrigger $this) {
        return $this.application;
    }

    public static final /* synthetic */ NotificationManager access$getNotificationManager$p(HeapDumpTrigger $this) {
        return $this.getNotificationManager();
    }

    public static final /* synthetic */ Handler access$getBackgroundHandler$p(HeapDumpTrigger $this) {
        return $this.backgroundHandler;
    }

    public static final /* synthetic */ Function0 access$getScheduleDismissNoRetainedOnTapNotification$p(HeapDumpTrigger $this) {
        return $this.scheduleDismissNoRetainedOnTapNotification;
    }

    public static final /* synthetic */ int access$getLastDisplayedRetainedObjectCount$p(HeapDumpTrigger $this) {
        return $this.lastDisplayedRetainedObjectCount;
    }

    public static final /* synthetic */ void access$setLastDisplayedRetainedObjectCount$p(HeapDumpTrigger $this, int n) {
        $this.lastDisplayedRetainedObjectCount = n;
    }

    public static final /* synthetic */ void access$dumpHeap(HeapDumpTrigger $this, int retainedReferenceCount, boolean retry) {
        $this.dumpHeap(retainedReferenceCount, retry);
    }

    public static final /* synthetic */ long access$getCheckScheduledAt$p(HeapDumpTrigger $this) {
        return $this.checkScheduledAt;
    }

    public static final /* synthetic */ void access$setCheckScheduledAt$p(HeapDumpTrigger $this, long l) {
        $this.checkScheduledAt = l;
    }

    public static final /* synthetic */ void access$checkRetainedObjects(HeapDumpTrigger $this, String reason) {
        $this.checkRetainedObjects(reason);
    }

    public static final /* synthetic */ void access$dismissRetainedCountNotification(HeapDumpTrigger $this) {
        $this.dismissRetainedCountNotification();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lleakcanary/internal/HeapDumpTrigger$Companion;", "", "()V", "DISMISS_NO_RETAINED_OBJECT_NOTIFICATION_MILLIS", "", "WAIT_AFTER_DUMP_FAILED_MILLIS", "WAIT_BETWEEN_HEAP_DUMPS_MILLIS", "WAIT_FOR_DEBUG_MILLIS", "WAIT_FOR_OBJECT_THRESHOLD_MILLIS", "leakcanary-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

