/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ShortcutInfo;
import android.content.pm.ShortcutManager;
import android.graphics.drawable.Icon;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import com.squareup.leakcanary.core.R;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import leakcanary.AppWatcher;
import leakcanary.GcTrigger;
import leakcanary.LeakCanary;
import leakcanary.OnHeapAnalyzedListener;
import leakcanary.OnObjectRetainedListener;
import leakcanary.internal.AndroidHeapDumper;
import leakcanary.internal.HeapDumpTrigger;
import leakcanary.internal.InternalLeakCanary;
import leakcanary.internal.LeakDirectoryProvider;
import leakcanary.internal.VisibilityTrackerKt;
import leakcanary.internal.activity.LeakActivity;
import org.jetbrains.annotations.NotNull;
import shark.HeapAnalysis;
import shark.LeakingObjectFinder;
import shark.MetadataExtractor;
import shark.SharkLog;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0000\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010+\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0002H\u0002J\b\u0010,\u001a\u00020\u0003H\u0002J\u0011\u0010-\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0002H\u0096\u0002J\u001a\u0010.\u001a\u0002H/\"\n\b\u0000\u0010/\u0018\u0001*\u000200H\u0086\b\u00a2\u0006\u0002\u00101J\u000e\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u000fJ\b\u00104\u001a\u00020\u0003H\u0016J\u0016\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\u0002X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0015\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0015\u0010\u0012R\u001b\u0010\u0018\u001a\u00020\u00198FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0017\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001b\u0010%\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u0017\u001a\u0004\b&\u0010'R\u0018\u0010)\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b*\u0010\u0005\u00a8\u00068"}, d2={"Lleakcanary/internal/InternalLeakCanary;", "Lkotlin/Function1;", "Landroid/app/Application;", "", "Lleakcanary/OnObjectRetainedListener;", "()V", "DYNAMIC_SHORTCUT_ID", "", "LEAK_CANARY_THREAD_NAME", "application", "getApplication", "()Landroid/app/Application;", "setApplication", "(Landroid/app/Application;)V", "<set-?>", "", "applicationVisible", "getApplicationVisible", "()Z", "heapDumpTrigger", "Lleakcanary/internal/HeapDumpTrigger;", "isRunningTests", "isRunningTests$delegate", "Lkotlin/Lazy;", "leakDirectoryProvider", "Lleakcanary/internal/LeakDirectoryProvider;", "getLeakDirectoryProvider", "()Lleakcanary/internal/LeakDirectoryProvider;", "leakDirectoryProvider$delegate", "leakDisplayActivityIntent", "Landroid/content/Intent;", "getLeakDisplayActivityIntent", "()Landroid/content/Intent;", "noInstallConfig", "Lleakcanary/LeakCanary$Config;", "getNoInstallConfig", "()Lleakcanary/LeakCanary$Config;", "testClassName", "getTestClassName", "()Ljava/lang/String;", "testClassName$delegate", "version", "version$annotations", "addDynamicShortcut", "disableDumpHeapInTests", "invoke", "noOpDelegate", "T", "", "()Ljava/lang/Object;", "onDumpHeapReceived", "forceDump", "onObjectRetained", "setEnabledBlocking", "componentClassName", "enabled", "leakcanary-android-core_release"})
public final class InternalLeakCanary
implements Function1<Application, Unit>,
OnObjectRetainedListener {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final String DYNAMIC_SHORTCUT_ID = "com.squareup.leakcanary.dynamic_shortcut";
    private static HeapDumpTrigger heapDumpTrigger;
    @NotNull
    public static Application application;
    private static String version;
    private static volatile boolean applicationVisible;
    private static final Lazy testClassName$delegate;
    private static final Lazy isRunningTests$delegate;
    @NotNull
    private static final Lazy leakDirectoryProvider$delegate;
    private static final String LEAK_CANARY_THREAD_NAME = "LeakCanary-Heap-Dump";
    public static final InternalLeakCanary INSTANCE;

    static {
        InternalLeakCanary internalLeakCanary;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(InternalLeakCanary.class), "testClassName", "getTestClassName()Ljava/lang/String;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(InternalLeakCanary.class), "isRunningTests", "isRunningTests()Z")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(InternalLeakCanary.class), "leakDirectoryProvider", "getLeakDirectoryProvider()Lleakcanary/internal/LeakDirectoryProvider;"))};
        INSTANCE = internalLeakCanary = new InternalLeakCanary();
        version = "2.1";
        testClassName$delegate = LazyKt.lazy((Function0)testClassName.2.INSTANCE);
        isRunningTests$delegate = LazyKt.lazy((Function0)isRunningTests.2.INSTANCE);
        leakDirectoryProvider$delegate = LazyKt.lazy((Function0)leakDirectoryProvider.2.INSTANCE);
    }

    @NotNull
    public final Application getApplication() {
        Application application = InternalLeakCanary.application;
        if (application == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"application");
        }
        return application;
    }

    public final void setApplication(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"<set-?>");
        InternalLeakCanary.application = application;
    }

    @JvmStatic
    private static /* synthetic */ void version$annotations() {
    }

    public final boolean getApplicationVisible() {
        return applicationVisible;
    }

    private final String getTestClassName() {
        Lazy lazy = testClassName$delegate;
        InternalLeakCanary internalLeakCanary = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (String)lazy.getValue();
    }

    private final boolean isRunningTests() {
        Lazy lazy = isRunningTests$delegate;
        InternalLeakCanary internalLeakCanary = this;
        KProperty kProperty = $$delegatedProperties[1];
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final LeakDirectoryProvider getLeakDirectoryProvider() {
        Lazy lazy = leakDirectoryProvider$delegate;
        InternalLeakCanary internalLeakCanary = this;
        KProperty kProperty = $$delegatedProperties[2];
        boolean bl = false;
        return (LeakDirectoryProvider)lazy.getValue();
    }

    @NotNull
    public final Intent getLeakDisplayActivityIntent() {
        Application application = InternalLeakCanary.application;
        if (application == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"application");
        }
        return LeakActivity.Companion.createIntent((Context)application);
    }

    @NotNull
    public final LeakCanary.Config getNoInstallConfig() {
        OnHeapAnalyzedListener.Companion companion = OnHeapAnalyzedListener.Companion;
        List list = CollectionsKt.emptyList();
        List list2 = CollectionsKt.emptyList();
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean $i$f$invoke = false;
        OnHeapAnalyzedListener onHeapAnalyzedListener = new OnHeapAnalyzedListener(){

            public void onHeapAnalyzed(@NotNull HeapAnalysis heapAnalysis) {
                Intrinsics.checkParameterIsNotNull((Object)heapAnalysis, (String)"heapAnalysis");
                HeapAnalysis it = heapAnalysis;
                boolean bl = false;
            }
        };
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n2 = 4038;
        boolean bl3 = false;
        LeakingObjectFinder leakingObjectFinder = null;
        boolean bl4 = false;
        int n3 = 0;
        boolean bl5 = false;
        MetadataExtractor metadataExtractor = null;
        OnHeapAnalyzedListener onHeapAnalyzedListener2 = onHeapAnalyzedListener;
        List list3 = list;
        List list4 = list2;
        int n4 = n;
        boolean bl6 = bl;
        boolean bl7 = bl2;
        return new LeakCanary.Config(bl7, bl6, n4, list4, list3, onHeapAnalyzedListener2, metadataExtractor, bl5, n3, bl4, leakingObjectFinder, bl3, n2, defaultConstructorMarker);
    }

    public void invoke(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        InternalLeakCanary.application = application;
        AppWatcher.INSTANCE.getObjectWatcher().addOnObjectRetainedListener((OnObjectRetainedListener)this);
        AndroidHeapDumper heapDumper = new AndroidHeapDumper((Context)application, this.getLeakDirectoryProvider());
        GcTrigger.Default gcTrigger = GcTrigger.Default.INSTANCE;
        Function0 configProvider2 = invoke.configProvider.1.INSTANCE;
        HandlerThread handlerThread = new HandlerThread(LEAK_CANARY_THREAD_NAME);
        handlerThread.start();
        Handler backgroundHandler = new Handler(handlerThread.getLooper());
        heapDumpTrigger = new HeapDumpTrigger(application, backgroundHandler, AppWatcher.INSTANCE.getObjectWatcher(), (GcTrigger)gcTrigger, heapDumper, (Function0<LeakCanary.Config>)configProvider2);
        VisibilityTrackerKt.registerVisibilityListener(application, (Function1<? super Boolean, Unit>)((Function1)invoke.1.INSTANCE));
        this.addDynamicShortcut(application);
        this.disableDumpHeapInTests();
    }

    private final void disableDumpHeapInTests() {
        new Handler().post((Runnable)disableDumpHeapInTests.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final void addDynamicShortcut(Application application) {
        int n;
        int count$iv;
        int n2;
        void $this$filterTo$iv$iv;
        boolean shortcutInstalled;
        Object shortcut;
        List dynamicShortcuts;
        ShortcutManager shortcutManager;
        block27: {
            boolean bl;
            if (Build.VERSION.SDK_INT < 25) {
                return;
            }
            if (!application.getResources().getBoolean(R.bool.leak_canary_add_dynamic_shortcut)) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 26) {
                PackageManager packageManager = application.getPackageManager();
                Intrinsics.checkExpressionValueIsNotNull((Object)packageManager, (String)"application.packageManager");
                if (packageManager.isInstantApp()) {
                    return;
                }
            }
            Object object = application.getSystemService(ShortcutManager.class);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            shortcutManager = (ShortcutManager)object;
            List list = shortcutManager.getDynamicShortcuts();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"shortcutManager.dynamicShortcuts");
            dynamicShortcuts = list;
            Iterable $this$any$iv = dynamicShortcuts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    shortcut = (ShortcutInfo)element$iv;
                    boolean bl2 = false;
                    ShortcutInfo shortcutInfo = shortcut;
                    Intrinsics.checkExpressionValueIsNotNull((Object)shortcutInfo, (String)"shortcut");
                    if (!Intrinsics.areEqual((Object)shortcutInfo.getId(), (Object)DYNAMIC_SHORTCUT_ID)) continue;
                    bl = true;
                    break block27;
                }
                bl = shortcutInstalled = false;
            }
        }
        if (shortcutInstalled) {
            return;
        }
        Intent mainIntent = new Intent("android.intent.action.MAIN", null);
        mainIntent.addCategory("android.intent.category.LAUNCHER");
        mainIntent.setPackage(application.getPackageName());
        List list = application.getPackageManager().queryIntentActivities(mainIntent, 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"application.packageManag\u2026Activities(mainIntent, 0)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        shortcut = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ResolveInfo it = (ResolveInfo)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.activityInfo.name, (Object)"leakcanary.internal.activity.LeakLauncherActivity") ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List activities = (List)destination$iv$iv;
        if (activities.isEmpty()) {
            return;
        }
        ActivityInfo firstMainActivity = ((ResolveInfo)CollectionsKt.first((List)activities)).activityInfo;
        String longLabel = null;
        String shortLabel = null;
        String string2 = application.getString(R.string.leak_canary_shortcut_label);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"application.getString(R.\u2026ak_canary_shortcut_label)");
        String leakActivityLabel = string2;
        if (activities.isEmpty()) {
            longLabel = leakActivityLabel;
            shortLabel = leakActivityLabel;
        } else {
            CharSequence firstLauncherActivityLabel = firstMainActivity.labelRes != 0 ? (CharSequence)application.getString(firstMainActivity.labelRes) : application.getPackageManager().getApplicationLabel(application.getApplicationInfo());
            String fullLengthLabel = firstLauncherActivityLabel + ' ' + leakActivityLabel;
            if (fullLengthLabel.length() > 10) {
                if (fullLengthLabel.length() <= 25) {
                    longLabel = fullLengthLabel;
                    shortLabel = leakActivityLabel;
                } else {
                    longLabel = leakActivityLabel;
                    shortLabel = leakActivityLabel;
                }
            } else {
                longLabel = fullLengthLabel;
                shortLabel = fullLengthLabel;
            }
        }
        ComponentName componentName = new ComponentName(firstMainActivity.packageName, firstMainActivity.name);
        Iterable $this$count$iv = dynamicShortcuts;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                ShortcutInfo shortcutInfo22 = (ShortcutInfo)element$iv;
                boolean bl = false;
                ShortcutInfo shortcutInfo = shortcutInfo22;
                Intrinsics.checkExpressionValueIsNotNull((Object)shortcutInfo, (String)"shortcutInfo");
                if (!Intrinsics.areEqual((Object)shortcutInfo.getActivity(), (Object)componentName)) continue;
                int shortcutInfo22 = ++count$iv;
                bl = false;
                if (shortcutInfo22 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        List list2 = shortcutManager.getManifestShortcuts();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"shortcutManager.manifestShortcuts");
        $this$count$iv = list2;
        int n3 = n2;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                ShortcutInfo shortcutInfo32 = (ShortcutInfo)element$iv;
                boolean bl = false;
                ShortcutInfo shortcutInfo = shortcutInfo32;
                Intrinsics.checkExpressionValueIsNotNull((Object)shortcutInfo, (String)"shortcutInfo");
                if (!Intrinsics.areEqual((Object)shortcutInfo.getActivity(), (Object)componentName)) continue;
                int shortcutInfo32 = ++count$iv;
                bl = false;
                if (shortcutInfo32 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n4 = n;
        int shortcutCount = n3 + n4;
        if (shortcutCount >= shortcutManager.getMaxShortcutCountPerActivity()) {
            return;
        }
        Intent intent = this.getLeakDisplayActivityIntent();
        intent.setAction("Dummy Action because Android is stupid");
        ShortcutInfo shortcutInfo = new ShortcutInfo.Builder((Context)application, DYNAMIC_SHORTCUT_ID).setLongLabel((CharSequence)longLabel).setShortLabel((CharSequence)shortLabel).setActivity(componentName).setIcon(Icon.createWithResource((Context)((Context)application), (int)R.mipmap.leak_canary_icon)).setIntent(intent).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)shortcutInfo, (String)"Builder(application, DYN\u2026(intent)\n        .build()");
        ShortcutInfo shortcut2 = shortcutInfo;
        try {
            shortcutManager.addDynamicShortcuts(CollectionsKt.listOf((Object)shortcut2));
        }
        catch (Throwable ignored) {
            SharkLog this_$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger = this_$iv.getLogger();
            if (logger == null) {
            }
            SharkLog.Logger logger$iv = logger;
            Throwable throwable = ignored;
            SharkLog.Logger logger2 = logger$iv;
            boolean bl = false;
            String string3 = "Could not add dynamic shortcut. " + "shortcutCount=" + shortcutCount + ", " + "maxShortcutCountPerActivity=" + shortcutManager.getMaxShortcutCountPerActivity();
            logger2.d(throwable, string3);
        }
    }

    public void onObjectRetained() {
        if (heapDumpTrigger != null) {
            HeapDumpTrigger heapDumpTrigger = InternalLeakCanary.heapDumpTrigger;
            if (heapDumpTrigger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"heapDumpTrigger");
            }
            heapDumpTrigger.onObjectRetained();
        }
    }

    public final void onDumpHeapReceived(boolean forceDump) {
        if (heapDumpTrigger != null) {
            HeapDumpTrigger heapDumpTrigger = InternalLeakCanary.heapDumpTrigger;
            if (heapDumpTrigger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"heapDumpTrigger");
            }
            heapDumpTrigger.onDumpHeapReceived(forceDump);
        }
    }

    public final void setEnabledBlocking(@NotNull String componentClassName, boolean enabled) {
        Intrinsics.checkParameterIsNotNull((Object)componentClassName, (String)"componentClassName");
        Application application = InternalLeakCanary.application;
        if (application == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"application");
        }
        ComponentName component = new ComponentName((Context)application, componentClassName);
        int newState = enabled ? 1 : 2;
        Application application2 = InternalLeakCanary.application;
        if (application2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"application");
        }
        application2.getPackageManager().setComponentEnabledSetting(component, newState, 1);
    }

    @NotNull
    public final /* synthetic */ <T> T noOpDelegate() {
        int $i$f$noOpDelegate = 0;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Class<Object> javaClass = Object.class;
        InvocationHandler noOpHandler2 = noOpDelegate.noOpHandler.1.INSTANCE;
        Object object = Proxy.newProxyInstance(javaClass.getClassLoader(), new Class[]{javaClass}, noOpHandler2);
        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
        return (T)object;
    }

    private InternalLeakCanary() {
    }

    public static final /* synthetic */ boolean access$getApplicationVisible$p(InternalLeakCanary $this) {
        InternalLeakCanary internalLeakCanary = $this;
        return applicationVisible;
    }

    public static final /* synthetic */ void access$setApplicationVisible$p(InternalLeakCanary $this, boolean bl) {
        InternalLeakCanary internalLeakCanary = $this;
        applicationVisible = bl;
    }

    public static final /* synthetic */ HeapDumpTrigger access$getHeapDumpTrigger$p(InternalLeakCanary $this) {
        InternalLeakCanary internalLeakCanary = $this;
        HeapDumpTrigger heapDumpTrigger = InternalLeakCanary.heapDumpTrigger;
        if (heapDumpTrigger == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"heapDumpTrigger");
        }
        return heapDumpTrigger;
    }

    public static final /* synthetic */ void access$setHeapDumpTrigger$p(InternalLeakCanary $this, HeapDumpTrigger heapDumpTrigger) {
        InternalLeakCanary internalLeakCanary = $this;
        InternalLeakCanary.heapDumpTrigger = heapDumpTrigger;
    }

    public static final /* synthetic */ boolean access$isRunningTests$p(InternalLeakCanary $this) {
        return $this.isRunningTests();
    }

    public static final /* synthetic */ String access$getTestClassName$p(InternalLeakCanary $this) {
        return $this.getTestClassName();
    }
}

