/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.content.res.XmlResourceParser;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 $2\u00020\u0001:\u0003$%&B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J/\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0010H\u0016JK\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00122\b\u0010 \u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010!J9\u0010\"\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010#R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lleakcanary/internal/LeakCanaryFileProvider;", "Landroid/content/ContentProvider;", "()V", "mStrategy", "Lleakcanary/internal/LeakCanaryFileProvider$PathStrategy;", "attachInfo", "", "context", "Landroid/content/Context;", "info", "Landroid/content/pm/ProviderInfo;", "delete", "", "uri", "Landroid/net/Uri;", "selection", "", "selectionArgs", "", "(Landroid/net/Uri;Ljava/lang/String;[Ljava/lang/String;)I", "getType", "insert", "values", "Landroid/content/ContentValues;", "onCreate", "", "openFile", "Landroid/os/ParcelFileDescriptor;", "mode", "query", "Landroid/database/Cursor;", "projectionArg", "sortOrder", "(Landroid/net/Uri;[Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;)Landroid/database/Cursor;", "update", "(Landroid/net/Uri;Landroid/content/ContentValues;Ljava/lang/String;[Ljava/lang/String;)I", "Companion", "PathStrategy", "SimplePathStrategy", "leakcanary-android-core_release"})
public final class LeakCanaryFileProvider
extends ContentProvider {
    private PathStrategy mStrategy;
    private static final String[] COLUMNS;
    private static final String META_DATA_FILE_PROVIDER_PATHS = "android.support.FILE_PROVIDER_PATHS";
    private static final String TAG_ROOT_PATH = "root-path";
    private static final String TAG_FILES_PATH = "files-path";
    private static final String TAG_CACHE_PATH = "cache-path";
    private static final String TAG_EXTERNAL = "external-path";
    private static final String TAG_EXTERNAL_FILES = "external-files-path";
    private static final String TAG_EXTERNAL_CACHE = "external-cache-path";
    private static final String TAG_EXTERNAL_MEDIA = "external-media-path";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PATH = "path";
    private static final File DEVICE_ROOT;
    private static final HashMap<String, PathStrategy> sCache;
    public static final Companion Companion;

    public boolean onCreate() {
        return true;
    }

    public void attachInfo(@NotNull Context context, @NotNull ProviderInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        super.attachInfo(context, info);
        if (info.exported) {
            throw (Throwable)new SecurityException("Provider must not be exported");
        }
        if (!info.grantUriPermissions) {
            throw (Throwable)new SecurityException("Provider must grant uri permissions");
        }
        String string2 = info.authority;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"info.authority");
        this.mStrategy = LeakCanaryFileProvider.Companion.getPathStrategy(context, string2);
    }

    @Nullable
    public Cursor query(@NotNull Uri uri, @Nullable String[] projectionArg, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        String[] stringArray = projectionArg;
        if (projectionArg == null) {
            stringArray = COLUMNS;
        }
        String[] projection = stringArray;
        PathStrategy pathStrategy = this.mStrategy;
        if (pathStrategy == null) {
            Intrinsics.throwNpe();
        }
        File file = pathStrategy.getFileForUri(uri);
        String[] cols = new String[projection.length];
        Object[] values = new Object[projection.length];
        int i = 0;
        for (String col : projection) {
            if (Intrinsics.areEqual((Object)"_display_name", (Object)col)) {
                cols[i] = "_display_name";
                values[i++] = file.getName();
                continue;
            }
            if (!Intrinsics.areEqual((Object)"_size", (Object)col)) continue;
            cols[i] = "_size";
            values[i++] = file.length();
        }
        cols = LeakCanaryFileProvider.Companion.copyOfStringArray(cols, i);
        values = LeakCanaryFileProvider.Companion.copyOfAnyArray(values, i);
        MatrixCursor cursor = new MatrixCursor(cols, 1);
        cursor.addRow(values);
        return (Cursor)cursor;
    }

    @Nullable
    public String getType(@NotNull Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        PathStrategy pathStrategy = this.mStrategy;
        if (pathStrategy == null) {
            Intrinsics.throwNpe();
        }
        File file = pathStrategy.getFileForUri(uri);
        String string2 = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.name");
        int lastDot = StringsKt.lastIndexOf$default((CharSequence)string2, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (lastDot >= 0) {
            String string3 = file.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"file.name");
            String string4 = string3;
            int n = lastDot + 1;
            boolean bl = false;
            String string5 = string4;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            String extension = string6;
            String mime = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
            if (mime != null) {
                return mime;
            }
        }
        return "application/octet-stream";
    }

    @Nullable
    public Uri insert(@NotNull Uri uri, @Nullable ContentValues values) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        throw (Throwable)new UnsupportedOperationException("No external inserts");
    }

    public int update(@NotNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        throw (Throwable)new UnsupportedOperationException("No external updates");
    }

    public int delete(@NotNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        PathStrategy pathStrategy = this.mStrategy;
        if (pathStrategy == null) {
            Intrinsics.throwNpe();
        }
        return (file = pathStrategy.getFileForUri(uri)).delete() ? 1 : 0;
    }

    @Nullable
    public ParcelFileDescriptor openFile(@NotNull Uri uri, @NotNull String mode) throws FileNotFoundException {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
        PathStrategy pathStrategy = this.mStrategy;
        if (pathStrategy == null) {
            Intrinsics.throwNpe();
        }
        File file = pathStrategy.getFileForUri(uri);
        int fileMode = LeakCanaryFileProvider.Companion.modeToMode(mode);
        return ParcelFileDescriptor.open((File)file, (int)fileMode);
    }

    static {
        Companion = new Companion(null);
        COLUMNS = new String[]{"_display_name", "_size"};
        META_DATA_FILE_PROVIDER_PATHS = META_DATA_FILE_PROVIDER_PATHS;
        TAG_ROOT_PATH = TAG_ROOT_PATH;
        TAG_FILES_PATH = TAG_FILES_PATH;
        TAG_CACHE_PATH = TAG_CACHE_PATH;
        TAG_EXTERNAL = TAG_EXTERNAL;
        TAG_EXTERNAL_FILES = TAG_EXTERNAL_FILES;
        TAG_EXTERNAL_CACHE = TAG_EXTERNAL_CACHE;
        TAG_EXTERNAL_MEDIA = TAG_EXTERNAL_MEDIA;
        ATTR_NAME = ATTR_NAME;
        ATTR_PATH = ATTR_PATH;
        DEVICE_ROOT = new File("/");
        sCache = new HashMap();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b`\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0003H&\u00a8\u0006\b"}, d2={"Lleakcanary/internal/LeakCanaryFileProvider$PathStrategy;", "", "getFileForUri", "Ljava/io/File;", "uri", "Landroid/net/Uri;", "getUriForFile", "file", "leakcanary-android-core_release"})
    public static interface PathStrategy {
        @NotNull
        public Uri getUriForFile(@NotNull File var1);

        @NotNull
        public File getFileForUri(@NotNull Uri var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0007J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lleakcanary/internal/LeakCanaryFileProvider$SimplePathStrategy;", "Lleakcanary/internal/LeakCanaryFileProvider$PathStrategy;", "mAuthority", "", "(Ljava/lang/String;)V", "mRoots", "Ljava/util/HashMap;", "Ljava/io/File;", "addRoot", "", "name", "root", "getFileForUri", "uri", "Landroid/net/Uri;", "getUriForFile", "file", "leakcanary-android-core_release"})
    public static final class SimplePathStrategy
    implements PathStrategy {
        private final HashMap<String, File> mRoots;
        private final String mAuthority;

        /*
         * WARNING - void declaration
         */
        public final void addRoot(@NotNull String name, @NotNull File root) {
            File file;
            String string2;
            Map map;
            Intrinsics.checkParameterIsNotNull((Object)name, (String)LeakCanaryFileProvider.ATTR_NAME);
            Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
            if (TextUtils.isEmpty((CharSequence)name)) {
                throw (Throwable)new IllegalArgumentException("Name must not be empty");
            }
            String string3 = name;
            Map map2 = this.mRoots;
            try {
                map = map2;
                string2 = string3;
                file = root.getCanonicalFile();
            }
            catch (IOException iOException) {
                void e;
                Map map3 = map2;
                String string4 = string3;
                throw (Throwable)new IllegalArgumentException("Failed to resolve canonical path for " + root, (Throwable)e);
            }
            File file2 = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"try {\n        // Resolve\u2026oot\", e\n        )\n      }");
            map.put(string2, file2);
        }

        @Override
        @NotNull
        public Uri getUriForFile(@NotNull File file) {
            Object object;
            String rootPath;
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            String path = null;
            try {
                String string2 = file.getCanonicalPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.canonicalPath");
                path = string2;
            }
            catch (IOException e) {
                throw (Throwable)new IllegalArgumentException("Failed to resolve canonical path for " + file);
            }
            Map.Entry<String, File> mostSpecific = null;
            for (Map.Entry<String, File> root : this.mRoots.entrySet()) {
                String rootPath2;
                File file2 = root.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"root.value");
                String string3 = rootPath2 = file2.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"rootPath");
                if (!StringsKt.startsWith$default((String)path, (String)string3, (boolean)false, (int)2, null) || mostSpecific != null && rootPath2.length() <= mostSpecific.getValue().getPath().length()) continue;
                mostSpecific = root;
            }
            if (mostSpecific == null) {
                throw (Throwable)new IllegalArgumentException("Failed to find configured root that contains " + path);
            }
            String string4 = rootPath = ((File)mostSpecific.getValue()).getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"rootPath");
            if (StringsKt.endsWith$default((String)string4, (String)"/", (boolean)false, (int)2, null)) {
                object = path;
                int n = rootPath.length();
                boolean bl = false;
                Object object2 = object;
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = ((String)object2).substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                path = string5;
            } else {
                object = path;
                int n = rootPath.length() + 1;
                boolean bl = false;
                Object object3 = object;
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = ((String)object3).substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                path = string6;
            }
            path = Uri.encode((String)mostSpecific.getKey()) + "/" + Uri.encode((String)path, (String)"/");
            Uri uri = new Uri.Builder().scheme("content").authority(this.mAuthority).encodedPath(path).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.Builder()\n          \u2026(path)\n          .build()");
            return uri;
        }

        @Override
        @NotNull
        public File getFileForUri(@NotNull Uri uri) {
            String path;
            Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
            String string2 = path = uri.getEncodedPath();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            int splitIndex = StringsKt.indexOf$default((CharSequence)string2, (char)'/', (int)1, (boolean)false, (int)4, null);
            String string3 = path;
            int n = 1;
            boolean bl = false;
            String string4 = string3.substring(n, splitIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String tag = Uri.decode((String)string4);
            string3 = path;
            n = splitIndex + 1;
            bl = false;
            String string5 = string3.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            path = Uri.decode((String)string5);
            File file = this.mRoots.get(tag);
            if (file == null) {
                throw (Throwable)new IllegalArgumentException("Unable to find configured root for " + uri);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"mRoots[tag] ?: throw Ill\u2026onfigured root for $uri\")");
            File root = file;
            String string6 = path;
            if (string6 == null) {
                Intrinsics.throwNpe();
            }
            File file2 = new File(root, string6);
            try {
                File file3 = file2.getCanonicalFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"file.canonicalFile");
                file2 = file3;
            }
            catch (IOException e) {
                throw (Throwable)new IllegalArgumentException("Failed to resolve canonical path for " + file2);
            }
            String string7 = file2.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"file.path");
            String string8 = root.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"root.path");
            if (!StringsKt.startsWith$default((String)string7, (String)string8, (boolean)false, (int)2, null)) {
                throw (Throwable)new SecurityException("Resolved path jumped beyond configured root");
            }
            return file2;
        }

        public SimplePathStrategy(@NotNull String mAuthority) {
            Intrinsics.checkParameterIsNotNull((Object)mAuthority, (String)"mAuthority");
            this.mAuthority = mAuthority;
            this.mRoots = new HashMap();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0007\"\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0019J-\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00072\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eJ-\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00072\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010 J\u001b\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\"\u001a\u00020#H\u0002\u00a2\u0006\u0002\u0010$J%\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\"\u001a\u00020#2\b\u0010&\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010'J\u001a\u0010(\u001a\u0004\u0018\u00010\u00152\u0006\u0010\"\u001a\u00020#2\u0006\u0010)\u001a\u00020\u0004H\u0002J\u001e\u0010*\u001a\u00020+2\u0006\u0010\"\u001a\u00020#2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\nJ\u0010\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u0004H\u0002J\u0018\u0010/\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#2\u0006\u0010)\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lleakcanary/internal/LeakCanaryFileProvider$Companion;", "", "()V", "ATTR_NAME", "", "ATTR_PATH", "COLUMNS", "", "[Ljava/lang/String;", "DEVICE_ROOT", "Ljava/io/File;", "META_DATA_FILE_PROVIDER_PATHS", "TAG_CACHE_PATH", "TAG_EXTERNAL", "TAG_EXTERNAL_CACHE", "TAG_EXTERNAL_FILES", "TAG_EXTERNAL_MEDIA", "TAG_FILES_PATH", "TAG_ROOT_PATH", "sCache", "Ljava/util/HashMap;", "Lleakcanary/internal/LeakCanaryFileProvider$PathStrategy;", "buildPath", "base", "segments", "(Ljava/io/File;[Ljava/lang/String;)Ljava/io/File;", "copyOfAnyArray", "original", "newLength", "", "([Ljava/lang/Object;I)[Ljava/lang/Object;", "copyOfStringArray", "([Ljava/lang/String;I)[Ljava/lang/String;", "getExternalCacheDirs", "context", "Landroid/content/Context;", "(Landroid/content/Context;)[Ljava/io/File;", "getExternalFilesDirs", "type", "(Landroid/content/Context;Ljava/lang/String;)[Ljava/io/File;", "getPathStrategy", "authority", "getUriForFile", "Landroid/net/Uri;", "file", "modeToMode", "mode", "parsePathStrategy", "leakcanary-android-core_release"})
    public static final class Companion {
        @NotNull
        public final Uri getUriForFile(@NotNull Context context, @NotNull String authority, @NotNull File file) {
            PathStrategy strategy;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)authority, (String)"authority");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            PathStrategy pathStrategy = strategy = this.getPathStrategy(context, authority);
            if (pathStrategy == null) {
                Intrinsics.throwNpe();
            }
            return pathStrategy.getUriForFile(file);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final PathStrategy getPathStrategy(Context context, String authority) {
            Ref.ObjectRef strat = new Ref.ObjectRef();
            HashMap hashMap = sCache;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (hashMap) {
                boolean bl3 = false;
                strat.element = (PathStrategy)sCache.get(authority);
                if ((PathStrategy)strat.element == null) {
                    try {
                        strat.element = Companion.parsePathStrategy(context, authority);
                    }
                    catch (IOException e) {
                        throw (Throwable)new IllegalArgumentException("Failed to parse " + META_DATA_FILE_PROVIDER_PATHS + " meta-data", e);
                    }
                    catch (XmlPullParserException e) {
                        throw (Throwable)new IllegalArgumentException("Failed to parse " + META_DATA_FILE_PROVIDER_PATHS + " meta-data", e);
                    }
                    Map map = sCache;
                    PathStrategy pathStrategy = (PathStrategy)strat.element;
                    if (pathStrategy == null) {
                        Intrinsics.throwNpe();
                    }
                    map.put(authority, pathStrategy);
                }
                Unit unit = Unit.INSTANCE;
            }
            return (PathStrategy)strat.element;
        }

        /*
         * WARNING - void declaration
         */
        private final PathStrategy parsePathStrategy(Context context, String authority) throws IOException, XmlPullParserException {
            void type;
            SimplePathStrategy strat = new SimplePathStrategy(authority);
            ProviderInfo providerInfo = context.getPackageManager().resolveContentProvider(authority, 128);
            if (providerInfo == null) {
                Intrinsics.throwNpe();
            }
            ProviderInfo info = providerInfo;
            XmlResourceParser xmlResourceParser = info.loadXmlMetaData(context.getPackageManager(), META_DATA_FILE_PROVIDER_PATHS);
            if (xmlResourceParser == null) {
                throw (Throwable)new IllegalArgumentException("Missing " + META_DATA_FILE_PROVIDER_PATHS + " meta-data");
            }
            XmlResourceParser resourceParser = xmlResourceParser;
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            while (((Number)((Function0)new Function0<Integer>((Ref.IntRef)type, resourceParser){
                final /* synthetic */ Ref.IntRef $type;
                final /* synthetic */ XmlResourceParser $resourceParser;

                public final int invoke() {
                    this.$type.element = this.$resourceParser.next();
                    return this.$type.element;
                }
                {
                    this.$type = intRef;
                    this.$resourceParser = xmlResourceParser;
                    super(0);
                }
            }).invoke()).intValue() != 1) {
                boolean bl;
                File[] fileArray;
                boolean bl2;
                File[] fileArray2;
                if (type.element != 2) continue;
                String tag = resourceParser.getName();
                String name = resourceParser.getAttributeValue(null, ATTR_NAME);
                String path = resourceParser.getAttributeValue(null, ATTR_PATH);
                File target = null;
                if (Intrinsics.areEqual((Object)TAG_ROOT_PATH, (Object)tag)) {
                    target = DEVICE_ROOT;
                } else if (Intrinsics.areEqual((Object)TAG_FILES_PATH, (Object)tag)) {
                    target = context.getFilesDir();
                } else if (Intrinsics.areEqual((Object)TAG_CACHE_PATH, (Object)tag)) {
                    target = context.getCacheDir();
                } else if (Intrinsics.areEqual((Object)TAG_EXTERNAL, (Object)tag)) {
                    target = Environment.getExternalStorageDirectory();
                } else if (Intrinsics.areEqual((Object)TAG_EXTERNAL_FILES, (Object)tag)) {
                    File[] externalFilesDirs;
                    fileArray2 = externalFilesDirs = this.getExternalFilesDirs(context, null);
                    bl2 = false;
                    fileArray = fileArray2;
                    bl = false;
                    if (!(fileArray.length == 0)) {
                        target = externalFilesDirs[0];
                    }
                } else if (Intrinsics.areEqual((Object)TAG_EXTERNAL_CACHE, (Object)tag)) {
                    File[] externalCacheDirs = this.getExternalCacheDirs(context);
                    fileArray2 = externalCacheDirs;
                    bl2 = false;
                    fileArray = fileArray2;
                    bl = false;
                    if (!(fileArray.length == 0)) {
                        target = externalCacheDirs[0];
                    }
                } else if (Build.VERSION.SDK_INT >= 21 && Intrinsics.areEqual((Object)TAG_EXTERNAL_MEDIA, (Object)tag)) {
                    File[] externalMediaDirs = context.getExternalMediaDirs();
                    Intrinsics.checkExpressionValueIsNotNull((Object)externalMediaDirs, (String)"externalMediaDirs");
                    fileArray2 = externalMediaDirs;
                    bl2 = false;
                    fileArray = fileArray2;
                    bl = false;
                    if (!(fileArray.length == 0)) {
                        target = externalMediaDirs[0];
                    }
                }
                if (target == null) continue;
                String string2 = name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)LeakCanaryFileProvider.ATTR_NAME);
                String[] stringArray = new String[1];
                String string3 = path;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)LeakCanaryFileProvider.ATTR_PATH);
                stringArray[0] = string3;
                strat.addRoot(string2, this.buildPath(target, stringArray));
            }
            return strat;
        }

        private final File[] getExternalFilesDirs(Context context, String type) {
            File[] fileArray;
            if (Build.VERSION.SDK_INT >= 19) {
                File[] fileArray2 = context.getExternalFilesDirs(type);
                fileArray = fileArray2;
                Intrinsics.checkExpressionValueIsNotNull((Object)fileArray2, (String)"context.getExternalFilesDirs(type)");
            } else {
                File[] fileArray3 = new File[1];
                fileArray = fileArray3;
                File file = context.getExternalFilesDir(type);
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.getExternalFilesDir(type)!!");
                fileArray3[0] = file;
            }
            return fileArray;
        }

        private final File[] getExternalCacheDirs(Context context) {
            File[] fileArray;
            if (Build.VERSION.SDK_INT >= 19) {
                File[] fileArray2 = context.getExternalCacheDirs();
                fileArray = fileArray2;
                Intrinsics.checkExpressionValueIsNotNull((Object)fileArray2, (String)"context.externalCacheDirs");
            } else {
                File[] fileArray3 = new File[1];
                fileArray = fileArray3;
                File file = context.getExternalCacheDir();
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.externalCacheDir!!");
                fileArray3[0] = file;
            }
            return fileArray;
        }

        private final int modeToMode(String mode) {
            int modeBits = 0;
            if (Intrinsics.areEqual((Object)"r", (Object)mode)) {
                modeBits = 0x10000000;
            } else if (Intrinsics.areEqual((Object)"w", (Object)mode) || Intrinsics.areEqual((Object)"wt", (Object)mode)) {
                modeBits = 0x2C000000;
            } else if (Intrinsics.areEqual((Object)"wa", (Object)mode)) {
                modeBits = 0x2A000000;
            } else if (Intrinsics.areEqual((Object)"rw", (Object)mode)) {
                modeBits = 0x38000000;
            } else if (Intrinsics.areEqual((Object)"rwt", (Object)mode)) {
                modeBits = 0x3C000000;
            } else {
                throw (Throwable)new IllegalArgumentException("Invalid mode: " + mode);
            }
            return modeBits;
        }

        private final File buildPath(File base, String ... segments) {
            File cur = base;
            for (String segment : segments) {
                cur = new File(cur, segment);
            }
            return cur;
        }

        private final String[] copyOfStringArray(String[] original, int newLength) {
            String[] result = new String[newLength];
            System.arraycopy(original, 0, result, 0, newLength);
            return result;
        }

        private final Object[] copyOfAnyArray(Object[] original, int newLength) {
            Object[] result = new Object[newLength];
            System.arraycopy(original, 0, result, 0, newLength);
            return result;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

