/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import com.squareup.leakcanary.core.R;
import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.internal.LeakDirectoryProvider;
import leakcanary.internal.NotificationType;
import leakcanary.internal.Notifications;
import leakcanary.internal.RequestStoragePermissionActivity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.SharkLog;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\u000fJ\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\rH\u0002J\b\u0010\u0013\u001a\u00020\rH\u0002J\b\u0010\u0014\u001a\u00020\bH\u0007J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u0004\u0018\u00010\rJ\u0006\u0010\u001a\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lleakcanary/internal/LeakDirectoryProvider;", "", "context", "Landroid/content/Context;", "maxStoredHeapDumps", "Lkotlin/Function0;", "", "requestExternalStoragePermission", "", "(Landroid/content/Context;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "permissionNotificationDisplayed", "writeExternalStorageGranted", "appStorageDirectory", "Ljava/io/File;", "cleanupOldHeapDumps", "", "clearLeakDirectory", "directoryWritableAfterMkdirs", "directory", "externalStorageDirectory", "hasStoragePermission", "listFiles", "", "filter", "Ljava/io/FilenameFilter;", "newHeapDumpFile", "requestWritePermissionNotification", "Companion", "leakcanary-android-core_release"})
public final class LeakDirectoryProvider {
    private final Context context;
    private volatile boolean writeExternalStorageGranted;
    private volatile boolean permissionNotificationDisplayed;
    private final Function0<Integer> maxStoredHeapDumps;
    private final Function0<Boolean> requestExternalStoragePermission;
    private static final List<String> filesDeletedTooOld;
    private static final List<String> filesDeletedClearDirectory;
    @NotNull
    private static final List<String> filesDeletedRemoveLeak;
    private static final String HPROF_SUFFIX = ".hprof";
    public static final Companion Companion;

    @NotNull
    public final List<File> listFiles(@NotNull FilenameFilter filter) {
        Object[] appFiles;
        Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
        if (!this.hasStoragePermission() && ((Boolean)this.requestExternalStoragePermission.invoke()).booleanValue()) {
            this.requestWritePermissionNotification();
        }
        ArrayList files = new ArrayList();
        Object[] externalFiles = this.externalStorageDirectory().listFiles(filter);
        if (externalFiles != null) {
            CollectionsKt.addAll((Collection)files, (Object[])externalFiles);
        }
        if ((appFiles = this.appStorageDirectory().listFiles(filter)) != null) {
            CollectionsKt.addAll((Collection)files, (Object[])appFiles);
        }
        return files;
    }

    @Nullable
    public final File newHeapDumpFile() {
        this.cleanupOldHeapDumps();
        File storageDirectory = this.externalStorageDirectory();
        if (!this.directoryWritableAfterMkdirs(storageDirectory)) {
            String string2;
            SharkLog.Logger logger;
            SharkLog this_$iv;
            if (!this.hasStoragePermission()) {
                if (((Boolean)this.requestExternalStoragePermission.invoke()).booleanValue()) {
                    this_$iv = SharkLog.INSTANCE;
                    boolean $i$f$d = false;
                    SharkLog.Logger logger2 = this_$iv.getLogger();
                    if (logger2 == null) {
                    } else {
                        SharkLog.Logger logger$iv;
                        logger = logger$iv = logger2;
                        boolean bl = false;
                        string2 = "WRITE_EXTERNAL_STORAGE permission not granted, requesting";
                        logger.d(string2);
                    }
                    this.requestWritePermissionNotification();
                } else {
                    this_$iv = SharkLog.INSTANCE;
                    boolean $i$f$d = false;
                    SharkLog.Logger logger3 = this_$iv.getLogger();
                    if (logger3 == null) {
                    } else {
                        SharkLog.Logger logger$iv;
                        logger = logger$iv = logger3;
                        boolean bl = false;
                        string2 = "WRITE_EXTERNAL_STORAGE permission not granted, ignoring";
                        logger.d(string2);
                    }
                }
            } else {
                String state = Environment.getExternalStorageState();
                if (Intrinsics.areEqual((Object)"mounted", (Object)state) ^ true) {
                    SharkLog this_$iv2 = SharkLog.INSTANCE;
                    boolean $i$f$d = false;
                    SharkLog.Logger logger4 = this_$iv2.getLogger();
                    if (logger4 == null) {
                    } else {
                        SharkLog.Logger logger$iv;
                        logger = logger$iv = logger4;
                        boolean bl = false;
                        string2 = "External storage not mounted, state: " + state;
                        logger.d(string2);
                    }
                } else {
                    SharkLog this_$iv3 = SharkLog.INSTANCE;
                    boolean $i$f$d = false;
                    SharkLog.Logger logger5 = this_$iv3.getLogger();
                    if (logger5 == null) {
                    } else {
                        SharkLog.Logger logger$iv;
                        logger = logger$iv = logger5;
                        boolean bl = false;
                        string2 = "Could not create heap dump directory in external storage: [" + storageDirectory.getAbsolutePath() + ']';
                        logger.d(string2);
                    }
                }
            }
            storageDirectory = this.appStorageDirectory();
            if (!this.directoryWritableAfterMkdirs(storageDirectory)) {
                this_$iv = SharkLog.INSTANCE;
                boolean $i$f$d = false;
                SharkLog.Logger logger6 = this_$iv.getLogger();
                if (logger6 == null) {
                } else {
                    SharkLog.Logger logger$iv;
                    logger = logger$iv = logger6;
                    boolean bl = false;
                    string2 = "Could not create heap dump directory in app storage: [" + storageDirectory.getAbsolutePath() + ']';
                    logger.d(string2);
                }
                return null;
            }
        }
        String fileName = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss_SSS'.hprof'", Locale.US).format(new Date());
        return new File(storageDirectory, fileName);
    }

    public final void clearLeakDirectory() {
        List<File> allFilesExceptPending2 = this.listFiles(clearLeakDirectory.allFilesExceptPending.1.INSTANCE);
        for (File file : allFilesExceptPending2) {
            SharkLog.Logger logger$iv;
            String path = file.getAbsolutePath();
            boolean deleted = file.delete();
            if (deleted) {
                Collection collection = filesDeletedClearDirectory;
                boolean bl = false;
                collection.add(path);
            }
            if (deleted) continue;
            SharkLog this_$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            if (this_$iv.getLogger() == null) {
                continue;
            }
            SharkLog.Logger logger = logger$iv;
            boolean bl = false;
            String string2 = "Could not delete file " + file.getPath();
            logger.d(string2);
        }
    }

    @TargetApi(value=23)
    public final boolean hasStoragePermission() {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        if (this.writeExternalStorageGranted) {
            return true;
        }
        this.writeExternalStorageGranted = this.context.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0;
        return this.writeExternalStorageGranted;
    }

    public final void requestWritePermissionNotification() {
        if (this.permissionNotificationDisplayed) {
            return;
        }
        this.permissionNotificationDisplayed = true;
        PendingIntent pendingIntent = RequestStoragePermissionActivity.Companion.createPendingIntent(this.context);
        String string2 = this.context.getString(R.string.leak_canary_permission_notification_title);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.getString(\n     \u2026_notification_title\n    )");
        String contentTitle = string2;
        String packageName = this.context.getPackageName();
        String string3 = this.context.getString(R.string.leak_canary_permission_notification_text, new Object[]{packageName});
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"context.getString(R.stri\u2026cation_text, packageName)");
        String contentText = string3;
        Notifications.INSTANCE.showNotification(this.context, contentTitle, contentText, pendingIntent, R.id.leak_canary_notification_write_permission, NotificationType.LEAKCANARY_LOW);
    }

    private final File externalStorageDirectory() {
        File downloadsDirectory = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
        return new File(downloadsDirectory, "leakcanary-" + this.context.getPackageName());
    }

    private final File appStorageDirectory() {
        File appFilesDirectory = this.context.getFilesDir();
        return new File(appFilesDirectory, "leakcanary");
    }

    private final boolean directoryWritableAfterMkdirs(File directory) {
        boolean success = directory.mkdirs();
        return (success || directory.exists()) && directory.canWrite();
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanupOldHeapDumps() {
        List<File> hprofFiles2 = this.listFiles(cleanupOldHeapDumps.hprofFiles.1.INSTANCE);
        int maxStoredHeapDumps = ((Number)this.maxStoredHeapDumps.invoke()).intValue();
        if (maxStoredHeapDumps < 1) {
            throw (Throwable)new IllegalArgumentException("maxStoredHeapDumps must be at least 1");
        }
        int filesToRemove = hprofFiles2.size() - maxStoredHeapDumps;
        if (filesToRemove > 0) {
            String string2;
            SharkLog.Logger logger;
            SharkLog this_$iv22 = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger2 = this_$iv22.getLogger();
            if (logger2 == null) {
            } else {
                SharkLog.Logger logger$iv;
                logger = logger$iv = logger2;
                boolean bl = false;
                string2 = "Removing " + filesToRemove + " heap dumps";
                logger.d(string2);
            }
            CollectionsKt.sortWith(hprofFiles2, (Comparator)cleanupOldHeapDumps.2.INSTANCE);
            int this_$iv22 = 0;
            int n = filesToRemove;
            while (this_$iv22 < n) {
                void i;
                String path = hprofFiles2.get((int)i).getAbsolutePath();
                boolean deleted = hprofFiles2.get((int)i).delete();
                if (deleted) {
                    Collection collection = filesDeletedTooOld;
                    boolean bl = false;
                    collection.add(path);
                } else {
                    SharkLog this_$iv = SharkLog.INSTANCE;
                    boolean $i$f$d2 = false;
                    if (this_$iv.getLogger() == null) {
                    } else {
                        SharkLog.Logger logger$iv;
                        logger = logger$iv;
                        boolean bl = false;
                        string2 = "Could not delete old hprof file " + hprofFiles2.get((int)i).getPath();
                        logger.d(string2);
                    }
                }
                ++i;
            }
        }
    }

    public LeakDirectoryProvider(@NotNull Context context, @NotNull Function0<Integer> maxStoredHeapDumps, @NotNull Function0<Boolean> requestExternalStoragePermission) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(maxStoredHeapDumps, (String)"maxStoredHeapDumps");
        Intrinsics.checkParameterIsNotNull(requestExternalStoragePermission, (String)"requestExternalStoragePermission");
        this.maxStoredHeapDumps = maxStoredHeapDumps;
        this.requestExternalStoragePermission = requestExternalStoragePermission;
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
        this.context = context2;
    }

    static {
        Companion = new Companion(null);
        boolean bl = false;
        filesDeletedTooOld = new ArrayList();
        bl = false;
        filesDeletedClearDirectory = new ArrayList();
        bl = false;
        filesDeletedRemoveLeak = new ArrayList();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lleakcanary/internal/LeakDirectoryProvider$Companion;", "", "()V", "HPROF_SUFFIX", "", "filesDeletedClearDirectory", "", "filesDeletedRemoveLeak", "getFilesDeletedRemoveLeak", "()Ljava/util/List;", "filesDeletedTooOld", "hprofDeleteReason", "file", "Ljava/io/File;", "leakcanary-android-core_release"})
    public static final class Companion {
        @NotNull
        public final List<String> getFilesDeletedRemoveLeak() {
            return filesDeletedRemoveLeak;
        }

        @NotNull
        public final String hprofDeleteReason(@NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            String path = file.getAbsolutePath();
            return filesDeletedTooOld.contains(path) ? "older than all other hprof files" : (filesDeletedClearDirectory.contains(path) ? "hprof directory cleared" : (this.getFilesDeletedRemoveLeak().contains(path) ? "leak manually removed" : "unknown"));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

