/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal.activity.db;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.AsyncTask;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import leakcanary.internal.InternalLeakCanary;
import leakcanary.internal.LeakDirectoryProvider;
import leakcanary.internal.Serializables;
import leakcanary.internal.SerializablesKt;
import leakcanary.internal.activity.db.LeakTable;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.HeapAnalysis;
import shark.HeapAnalysisFailure;
import shark.HeapAnalysisSuccess;
import shark.Leak;
import shark.SharkLog;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011J,\u0010\u0012\u001a\u0004\u0018\u0001H\u0013\"\n\b\u0000\u0010\u0013\u0018\u0001*\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000bH\u0086\b\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\b\u001a\u00020\tR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lleakcanary/internal/activity/db/HeapAnalysisTable;", "", "()V", "create", "", "drop", "delete", "", "db", "Landroid/database/sqlite/SQLiteDatabase;", "heapAnalysisId", "", "heapDumpFile", "Ljava/io/File;", "deleteAll", "insert", "heapAnalysis", "Lshark/HeapAnalysis;", "retrieve", "T", "id", "(Landroid/database/sqlite/SQLiteDatabase;J)Lshark/HeapAnalysis;", "retrieveAll", "", "Lleakcanary/internal/activity/db/HeapAnalysisTable$Projection;", "Projection", "leakcanary-android-core_release"})
public final class HeapAnalysisTable {
    @Language(value="RoomSql")
    @NotNull
    public static final String create = "CREATE TABLE heap_analysis\n        (\n        id INTEGER PRIMARY KEY AUTOINCREMENT,\n        created_at_time_millis INTEGER,\n        leak_count INTEGER DEFAULT 0,\n        exception_summary TEXT DEFAULT NULL,\n        object BLOB\n        )";
    @Language(value="RoomSql")
    @NotNull
    public static final String drop = "DROP TABLE IF EXISTS heap_analysis";
    public static final HeapAnalysisTable INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long insert(@NotNull SQLiteDatabase db, @NotNull HeapAnalysis heapAnalysis) {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        Intrinsics.checkParameterIsNotNull((Object)heapAnalysis, (String)"heapAnalysis");
        ContentValues values = new ContentValues();
        values.put("created_at_time_millis", Long.valueOf(heapAnalysis.getCreatedAtTimeMillis()));
        values.put("object", SerializablesKt.toByteArray((Serializable)heapAnalysis));
        HeapAnalysis heapAnalysis2 = heapAnalysis;
        if (heapAnalysis2 instanceof HeapAnalysisSuccess) {
            int leakCount = ((HeapAnalysisSuccess)heapAnalysis).getApplicationLeaks().size() + ((HeapAnalysisSuccess)heapAnalysis).getLibraryLeaks().size();
            values.put("leak_count", Integer.valueOf(leakCount));
        } else if (heapAnalysis2 instanceof HeapAnalysisFailure) {
            Throwable throwable = ((HeapAnalysisFailure)heapAnalysis).getException().getCause();
            if (throwable == null) {
                Intrinsics.throwNpe();
            }
            Throwable cause = throwable;
            String exceptionSummary = cause.getClass().getSimpleName() + ' ' + cause.getMessage();
            values.put("exception_summary", exceptionSummary);
        }
        SQLiteDatabase $this$inTransaction$iv = db;
        boolean $i$f$inTransaction = false;
        try {
            $this$inTransaction$iv.beginTransaction();
            SQLiteDatabase $this$inTransaction = $this$inTransaction$iv;
            boolean bl = false;
            long heapAnalysisId = db.insertOrThrow("heap_analysis", null, values);
            if (heapAnalysis instanceof HeapAnalysisSuccess) {
                Sequence $this$forEach$iv = ((HeapAnalysisSuccess)heapAnalysis).getAllLeaks();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Leak leakingInstance = (Leak)element$iv;
                    boolean bl2 = false;
                    LeakTable.INSTANCE.insert(db, heapAnalysisId, leakingInstance);
                }
            }
            long result$iv = heapAnalysisId;
            $this$inTransaction$iv.setTransactionSuccessful();
            l = result$iv;
        }
        finally {
            $this$inTransaction$iv.endTransaction();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final /* synthetic */ <T extends HeapAnalysis> T retrieve(@NotNull SQLiteDatabase db, long id2) {
        Cursor cursor;
        SQLiteDatabase $this$inTransaction$iv;
        block16: {
            T t;
            int $i$f$retrieve = 0;
            Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
            $this$inTransaction$iv = db;
            boolean $i$f$inTransaction = false;
            try {
                Cursor cursor2;
                $this$inTransaction$iv.beginTransaction();
                SQLiteDatabase $this$inTransaction = $this$inTransaction$iv;
                boolean bl = false;
                Cursor cursor3 = db.rawQuery("\n              SELECT\n              object\n              FROM heap_analysis\n              WHERE id=" + id2 + "\n              ", null);
                Intrinsics.checkExpressionValueIsNotNull((Object)cursor3, (String)"db.rawQuery(\n          \"\u2026        \"\"\", null\n      )");
                Cursor $this$use$iv = cursor3;
                boolean $i$f$use = false;
                Throwable exception$iv = null;
                try {
                    HeapAnalysis heapAnalysis;
                    cursor2 = $this$use$iv;
                    boolean bl2 = false;
                    if (cursor2.moveToNext()) {
                        Object object;
                        Serializables serializables = Serializables.INSTANCE;
                        byte[] byArray = cursor2.getBlob(0);
                        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cursor.getBlob(0)");
                        byte[] byteArray$iv = byArray;
                        boolean $i$f$fromByteArray = false;
                        ByteArrayInputStream inputStream$iv = new ByteArrayInputStream(byteArray$iv);
                        try {
                            Object object2 = new ObjectInputStream(inputStream$iv).readObject();
                            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
                            object = object2;
                        }
                        catch (Throwable ignored$iv) {
                            object = null;
                        }
                        HeapAnalysis analysis = (HeapAnalysis)object;
                        if (analysis == null) {
                            INSTANCE.delete(db, id2, null);
                        }
                        heapAnalysis = analysis;
                    } else {
                        heapAnalysis = null;
                    }
                    cursor2 = heapAnalysis;
                }
                catch (Throwable e$iv) {
                    try {
                        exception$iv = e$iv;
                        throw e$iv;
                    }
                    catch (Throwable throwable) {
                        InlineMarker.finallyStart((int)1);
                        Throwable throwable2 = exception$iv;
                        if (throwable2 == null) {
                            $this$use$iv.close();
                        } else {
                            try {
                                $this$use$iv.close();
                            }
                            catch (Throwable throwable3) {
                                // empty catch block
                            }
                        }
                        InlineMarker.finallyEnd((int)1);
                        throw throwable;
                    }
                }
                InlineMarker.finallyStart((int)1);
                Throwable throwable = exception$iv;
                $this$use$iv.close();
                InlineMarker.finallyEnd((int)1);
                if (cursor2 != null) break block16;
                t = null;
            }
            catch (Throwable throwable) {
                InlineMarker.finallyStart((int)1);
                $this$inTransaction$iv.endTransaction();
                InlineMarker.finallyEnd((int)1);
                throw throwable;
            }
            InlineMarker.finallyStart((int)3);
            $this$inTransaction$iv.endTransaction();
            InlineMarker.finallyEnd((int)3);
            return t;
        }
        Cursor cursor4 = cursor;
        InlineMarker.finallyStart((int)2);
        $this$inTransaction$iv.endTransaction();
        InlineMarker.finallyEnd((int)2);
        return (T)cursor4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Projection> retrieveAll(@NotNull SQLiteDatabase db) {
        Object cursor;
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        Cursor cursor2 = db.rawQuery("\n          SELECT\n          id\n          , created_at_time_millis\n          , leak_count\n          , exception_summary\n          FROM heap_analysis\n          ORDER BY created_at_time_millis DESC\n          ", null);
        Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"db.rawQuery(\n        \"\"\"\u2026          \"\"\", null\n    )");
        Cursor $this$use$iv = cursor2;
        boolean $i$f$use = false;
        Throwable exception$iv = null;
        try {
            cursor = $this$use$iv;
            boolean bl = false;
            boolean bl2 = false;
            List all = new ArrayList();
            while (cursor.moveToNext()) {
                Projection summary = new Projection(cursor.getLong(0), cursor.getLong(1), cursor.getInt(2), cursor.getString(3));
                all.add(summary);
            }
            cursor = all;
            Throwable throwable = exception$iv;
        }
        catch (Throwable e$iv) {
            try {
                exception$iv = e$iv;
                throw e$iv;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = exception$iv;
                if (throwable2 == null) {
                    $this$use$iv.close();
                } else {
                    try {
                        $this$use$iv.close();
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        $this$use$iv.close();
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void delete(@NotNull SQLiteDatabase db, long heapAnalysisId, @Nullable File heapDumpFile) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        if (heapDumpFile != null) {
            AsyncTask.SERIAL_EXECUTOR.execute(new Runnable(heapDumpFile){
                final /* synthetic */ File $heapDumpFile;

                public final void run() {
                    String path = this.$heapDumpFile.getAbsolutePath();
                    boolean heapDumpDeleted = this.$heapDumpFile.delete();
                    if (heapDumpDeleted) {
                        Collection collection = LeakDirectoryProvider.Companion.getFilesDeletedRemoveLeak();
                        boolean bl = false;
                        collection.add(path);
                    } else {
                        SharkLog this_$iv = SharkLog.INSTANCE;
                        boolean $i$f$d = false;
                        SharkLog.Logger logger = this_$iv.getLogger();
                        if (logger == null) {
                        } else {
                            SharkLog.Logger logger$iv;
                            SharkLog.Logger logger2 = logger$iv = logger;
                            boolean bl = false;
                            String string2 = "Could not delete heap dump file " + this.$heapDumpFile.getPath();
                            logger2.d(string2);
                        }
                    }
                }
                {
                    this.$heapDumpFile = file;
                }
            });
        }
        SQLiteDatabase $this$inTransaction$iv = db;
        boolean $i$f$inTransaction = false;
        try {
            $this$inTransaction$iv.beginTransaction();
            SQLiteDatabase $this$inTransaction = $this$inTransaction$iv;
            boolean bl = false;
            db.delete("heap_analysis", "id=" + heapAnalysisId, null);
            LeakTable.INSTANCE.deleteByHeapAnalysisId(db, heapAnalysisId);
            Unit result$iv = Unit.INSTANCE;
            $this$inTransaction$iv.setTransactionSuccessful();
            Unit unit = result$iv;
        }
        finally {
            $this$inTransaction$iv.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteAll(@NotNull SQLiteDatabase db) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        LeakDirectoryProvider leakDirectoryProvider2 = InternalLeakCanary.INSTANCE.getLeakDirectoryProvider();
        AsyncTask.SERIAL_EXECUTOR.execute(new Runnable(leakDirectoryProvider2){
            final /* synthetic */ LeakDirectoryProvider $leakDirectoryProvider;

            public final void run() {
                this.$leakDirectoryProvider.clearLeakDirectory();
            }
            {
                this.$leakDirectoryProvider = leakDirectoryProvider2;
            }
        });
        SQLiteDatabase $this$inTransaction$iv = db;
        boolean $i$f$inTransaction = false;
        try {
            $this$inTransaction$iv.beginTransaction();
            SQLiteDatabase $this$inTransaction = $this$inTransaction$iv;
            boolean bl = false;
            db.delete("heap_analysis", null, null);
            LeakTable.INSTANCE.deleteAll(db);
            Unit result$iv = Unit.INSTANCE;
            $this$inTransaction$iv.setTransactionSuccessful();
            Unit unit = result$iv;
        }
        finally {
            $this$inTransaction$iv.endTransaction();
        }
    }

    private HeapAnalysisTable() {
    }

    static {
        HeapAnalysisTable heapAnalysisTable;
        INSTANCE = heapAnalysisTable = new HeapAnalysisTable();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lleakcanary/internal/activity/db/HeapAnalysisTable$Projection;", "", "id", "", "createdAtTimeMillis", "leakCount", "", "exceptionSummary", "", "(JJILjava/lang/String;)V", "getCreatedAtTimeMillis", "()J", "getExceptionSummary", "()Ljava/lang/String;", "getId", "getLeakCount", "()I", "leakcanary-android-core_release"})
    public static final class Projection {
        private final long id;
        private final long createdAtTimeMillis;
        private final int leakCount;
        @Nullable
        private final String exceptionSummary;

        public final long getId() {
            return this.id;
        }

        public final long getCreatedAtTimeMillis() {
            return this.createdAtTimeMillis;
        }

        public final int getLeakCount() {
            return this.leakCount;
        }

        @Nullable
        public final String getExceptionSummary() {
            return this.exceptionSummary;
        }

        public Projection(long id2, long createdAtTimeMillis, int leakCount, @Nullable String exceptionSummary) {
            this.id = id2;
            this.createdAtTimeMillis = createdAtTimeMillis;
            this.leakCount = leakCount;
            this.exceptionSummary = exceptionSummary;
        }
    }
}

