/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal.activity.db;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import leakcanary.internal.activity.db.LeakTable;
import leakcanary.internal.activity.db.LeakTraceTable;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.Leak;
import shark.LeakTrace;
import shark.LibraryLeak;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0003\u001d\u001e\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0004J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0004J(\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001cR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lleakcanary/internal/activity/db/LeakTable;", "", "()V", "create", "", "createSignatureIndex", "drop", "deleteAll", "", "db", "Landroid/database/sqlite/SQLiteDatabase;", "deleteByHeapAnalysisId", "heapAnalysisId", "", "insert", "leak", "Lshark/Leak;", "markAsRead", "signature", "retrieveAllLeaks", "", "Lleakcanary/internal/activity/db/LeakTable$AllLeaksProjection;", "retrieveLeakBySignature", "Lleakcanary/internal/activity/db/LeakTable$LeakProjection;", "retrieveLeakReadStatuses", "", "", "signatures", "", "AllLeaksProjection", "LeakProjection", "LeakTraceProjection", "leakcanary-android-core_release"})
public final class LeakTable {
    @Language(value="RoomSql")
    @NotNull
    public static final String create = "\n        CREATE TABLE leak\n        (\n        id INTEGER PRIMARY KEY,\n        signature TEXT UNIQUE,\n        short_description TEXT,\n        is_library_leak INTEGER,\n        is_read INTEGER\n        )";
    @Language(value="RoomSql")
    @NotNull
    public static final String createSignatureIndex = "\n        CREATE INDEX leak_signature\n        on leak (signature)\n    ";
    @Language(value="RoomSql")
    @NotNull
    public static final String drop = "DROP TABLE IF EXISTS leak";
    public static final LeakTable INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final long insert(@NotNull SQLiteDatabase db, long heapAnalysisId, @NotNull Leak leak) {
        long cursor22;
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        Intrinsics.checkParameterIsNotNull((Object)leak, (String)"leak");
        ContentValues values = new ContentValues();
        values.put("signature", leak.getSignature());
        values.put("short_description", leak.getShortDescription());
        values.put("is_library_leak", Integer.valueOf(leak instanceof LibraryLeak ? 1 : 0));
        values.put("is_read", Integer.valueOf(0));
        db.insertWithOnConflict("leak", null, values, 4);
        Cursor cursor = db.rawQuery("SELECT id from leak WHERE signature = '" + leak.getSignature() + "' LIMIT 1", null);
        Intrinsics.checkExpressionValueIsNotNull((Object)cursor, (String)"db.rawQuery(\"SELECT id f\u2026gnature}' LIMIT 1\", null)");
        Cursor $this$use$iv = cursor;
        boolean $i$f$use = false;
        Throwable exception$iv = null;
        try {
            Cursor cursor22 = $this$use$iv;
            boolean $i$a$-use-LeakTable$insert$leakId$22 = false;
            if (!cursor22.moveToFirst()) {
                throw (Throwable)new IllegalStateException("No id found for leak with signature '" + leak.getSignature() + '\'');
            }
            cursor22 = cursor22.getLong(0);
            Throwable $i$a$-use-LeakTable$insert$leakId$22 = exception$iv;
        }
        catch (Throwable e$iv) {
            try {
                exception$iv = e$iv;
                throw e$iv;
            }
            catch (Throwable throwable) {
                Throwable $i$a$-use-LeakTable$insert$leakId$22 = exception$iv;
                if ($i$a$-use-LeakTable$insert$leakId$22 == null) {
                    $this$use$iv.close();
                } else {
                    try {
                        $this$use$iv.close();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        $this$use$iv.close();
        long leakId = cursor22;
        Iterable $this$forEachIndexed$iv = leak.getLeakTraces();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void leakTrace;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            LeakTrace leakTrace2 = (LeakTrace)item$iv;
            int index = n2;
            boolean bl2 = false;
            LeakTraceTable.INSTANCE.insert(db, leakId, heapAnalysisId, index, leakTrace.getLeakingObject().getClassSimpleName());
        }
        return leakId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Map<String, Boolean> retrieveLeakReadStatuses(@NotNull SQLiteDatabase db, @NotNull Set<String> signatures2) {
        Object cursor;
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        Intrinsics.checkParameterIsNotNull(signatures2, (String)"signatures");
        Cursor cursor2 = db.rawQuery("\n      SELECT\n      signature\n      , is_read\n      FROM leak\n      WHERE signature IN (" + CollectionsKt.joinToString$default((Iterable)signatures2, null, null, null, (int)0, null, (Function1)retrieveLeakReadStatuses.1.INSTANCE, (int)31, null) + ")\n    ", null);
        Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"db.rawQuery(\n        \"\"\"\u2026\" }})\n    \"\"\", null\n    )");
        Cursor $this$use$iv = cursor2;
        boolean $i$f$use = false;
        Throwable exception$iv = null;
        try {
            cursor = $this$use$iv;
            boolean bl = false;
            boolean bl2 = false;
            Map leakReadStatuses = new LinkedHashMap();
            while (cursor.moveToNext()) {
                String signature = cursor.getString(0);
                boolean isRead = cursor.getInt(1) == 1;
                String string2 = signature;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"signature");
                leakReadStatuses.put(string2, isRead);
            }
            cursor = leakReadStatuses;
            Throwable throwable = exception$iv;
        }
        catch (Throwable e$iv) {
            try {
                exception$iv = e$iv;
                throw e$iv;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = exception$iv;
                if (throwable2 == null) {
                    $this$use$iv.close();
                } else {
                    try {
                        $this$use$iv.close();
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        $this$use$iv.close();
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<AllLeaksProjection> retrieveAllLeaks(@NotNull SQLiteDatabase db) {
        Object cursor;
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        Cursor cursor2 = db.rawQuery("\n          SELECT\n          l.signature\n          , MIN(l.short_description)\n          , MAX(h.created_at_time_millis) as created_at_time_millis\n          , COUNT(*) as leak_trace_count\n          , MIN(l.is_library_leak) as is_library_leak\n          , MAX(l.is_read) as is_read\n          FROM leak_trace lt\n          LEFT JOIN leak l on lt.leak_id = l.id\n          LEFT JOIN heap_analysis h ON lt.heap_analysis_id = h.id\n          GROUP BY 1\n          ORDER BY leak_trace_count DESC, created_at_time_millis DESC\n          ", null);
        Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"db.rawQuery(\n        \"\"\"\u2026          \"\"\", null\n    )");
        Cursor $this$use$iv = cursor2;
        boolean $i$f$use = false;
        Throwable exception$iv = null;
        try {
            cursor = $this$use$iv;
            boolean bl = false;
            boolean bl2 = false;
            List all = new ArrayList();
            while (cursor.moveToNext()) {
                String string2 = cursor.getString(0);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"cursor.getString(0)");
                String string3 = cursor.getString(1);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"cursor.getString(1)");
                AllLeaksProjection group = new AllLeaksProjection(string2, string3, cursor.getLong(2), cursor.getInt(3), cursor.getInt(4) == 1, cursor.getInt(5) == 0);
                all.add(group);
            }
            cursor = all;
            Throwable throwable = exception$iv;
        }
        catch (Throwable e$iv) {
            try {
                exception$iv = e$iv;
                throw e$iv;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = exception$iv;
                if (throwable2 == null) {
                    $this$use$iv.close();
                } else {
                    try {
                        $this$use$iv.close();
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        $this$use$iv.close();
        return cursor;
    }

    public final void markAsRead(@NotNull SQLiteDatabase db, @NotNull String signature) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        Intrinsics.checkParameterIsNotNull((Object)signature, (String)"signature");
        ContentValues contentValues = new ContentValues();
        boolean bl = false;
        boolean bl2 = false;
        ContentValues $this$apply = contentValues;
        boolean bl3 = false;
        $this$apply.put("is_read", Integer.valueOf(1));
        ContentValues values = contentValues;
        db.update("leak", values, "signature = ?", new String[]{signature});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final LeakProjection retrieveLeakBySignature(@NotNull SQLiteDatabase db, @NotNull String signature) {
        LeakProjection leakProjection;
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        Intrinsics.checkParameterIsNotNull((Object)signature, (String)"signature");
        Cursor cursor = db.rawQuery("\n          SELECT\n          lt.leak_trace_index\n          , lt.heap_analysis_id\n          , lt.class_simple_name\n          , h.created_at_time_millis\n          , l.short_description\n          , l.is_read\n          , l.is_library_leak\n          FROM leak_trace lt\n          LEFT JOIN leak l on lt.leak_id = l.id\n          LEFT JOIN heap_analysis h ON lt.heap_analysis_id = h.id\n          WHERE l.signature = ?\n          ORDER BY h.created_at_time_millis DESC\n          ", new String[]{signature});
        Intrinsics.checkExpressionValueIsNotNull((Object)cursor, (String)"db.rawQuery(\n        \"\"\"\u2026 arrayOf(signature)\n    )");
        Cursor $this$use$iv = cursor;
        boolean $i$f$use = false;
        Throwable exception$iv = null;
        try {
            LeakProjection leakProjection2;
            Cursor cursor2 = $this$use$iv;
            boolean bl = false;
            if (cursor2.moveToFirst()) {
                boolean bl2 = false;
                List leakTraces = new ArrayList();
                String string2 = cursor2.getString(4);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"cursor.getString(4)");
                LeakProjection leakProjection3 = new LeakProjection(string2, cursor2.getInt(5) == 0, cursor2.getInt(6) == 1, leakTraces);
                CollectionsKt.addAll((Collection)leakTraces, (Sequence)SequencesKt.map((Sequence)SequencesKt.generateSequence((Object)cursor2, (Function1)((Function1)new Function1<Cursor, Cursor>(cursor2){
                    final /* synthetic */ Cursor $cursor;

                    @Nullable
                    public final Cursor invoke(@NotNull Cursor it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return this.$cursor.moveToNext() ? this.$cursor : null;
                    }
                    {
                        this.$cursor = cursor;
                        super(1);
                    }
                })), (Function1)((Function1)new Function1<Cursor, LeakTraceProjection>(cursor2){
                    final /* synthetic */ Cursor $cursor;

                    @NotNull
                    public final LeakTraceProjection invoke(@NotNull Cursor it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        int n = this.$cursor.getInt(0);
                        long l = this.$cursor.getLong(1);
                        String string2 = this.$cursor.getString(2);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"cursor.getString(2)");
                        return new LeakTraceProjection(n, l, string2, this.$cursor.getLong(3));
                    }
                    {
                        this.$cursor = cursor;
                        super(1);
                    }
                })));
                leakProjection2 = leakProjection3;
            } else {
                leakProjection2 = null;
            }
            leakProjection = leakProjection2;
            Throwable throwable = exception$iv;
        }
        catch (Throwable e$iv) {
            try {
                exception$iv = e$iv;
                throw e$iv;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = exception$iv;
                if (throwable2 == null) {
                    $this$use$iv.close();
                } else {
                    try {
                        $this$use$iv.close();
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        $this$use$iv.close();
        return leakProjection;
    }

    public final void deleteByHeapAnalysisId(@NotNull SQLiteDatabase db, long heapAnalysisId) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        LeakTraceTable.INSTANCE.deleteByHeapAnalysisId(db, heapAnalysisId);
        db.execSQL("\n      DELETE\n      FROM leak\n      WHERE NOT EXISTS (\n      SELECT *\n      FROM leak_trace lt\n      WHERE leak.id = lt.leak_id)\n    ");
    }

    public final void deleteAll(@NotNull SQLiteDatabase db) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        db.delete("leak", null, null);
        LeakTraceTable.INSTANCE.deleteAll(db);
    }

    private LeakTable() {
    }

    static {
        LeakTable leakTable;
        INSTANCE = leakTable = new LeakTable();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lleakcanary/internal/activity/db/LeakTable$AllLeaksProjection;", "", "signature", "", "shortDescription", "createdAtTimeMillis", "", "leakTraceCount", "", "isLibraryLeak", "", "isNew", "(Ljava/lang/String;Ljava/lang/String;JIZZ)V", "getCreatedAtTimeMillis", "()J", "()Z", "getLeakTraceCount", "()I", "getShortDescription", "()Ljava/lang/String;", "getSignature", "leakcanary-android-core_release"})
    public static final class AllLeaksProjection {
        @NotNull
        private final String signature;
        @NotNull
        private final String shortDescription;
        private final long createdAtTimeMillis;
        private final int leakTraceCount;
        private final boolean isLibraryLeak;
        private final boolean isNew;

        @NotNull
        public final String getSignature() {
            return this.signature;
        }

        @NotNull
        public final String getShortDescription() {
            return this.shortDescription;
        }

        public final long getCreatedAtTimeMillis() {
            return this.createdAtTimeMillis;
        }

        public final int getLeakTraceCount() {
            return this.leakTraceCount;
        }

        public final boolean isLibraryLeak() {
            return this.isLibraryLeak;
        }

        public final boolean isNew() {
            return this.isNew;
        }

        public AllLeaksProjection(@NotNull String signature, @NotNull String shortDescription, long createdAtTimeMillis, int leakTraceCount, boolean isLibraryLeak, boolean isNew) {
            Intrinsics.checkParameterIsNotNull((Object)signature, (String)"signature");
            Intrinsics.checkParameterIsNotNull((Object)shortDescription, (String)"shortDescription");
            this.signature = signature;
            this.shortDescription = shortDescription;
            this.createdAtTimeMillis = createdAtTimeMillis;
            this.leakTraceCount = leakTraceCount;
            this.isLibraryLeak = isLibraryLeak;
            this.isNew = isNew;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lleakcanary/internal/activity/db/LeakTable$LeakProjection;", "", "shortDescription", "", "isNew", "", "isLibraryLeak", "leakTraces", "", "Lleakcanary/internal/activity/db/LeakTable$LeakTraceProjection;", "(Ljava/lang/String;ZZLjava/util/List;)V", "()Z", "getLeakTraces", "()Ljava/util/List;", "getShortDescription", "()Ljava/lang/String;", "leakcanary-android-core_release"})
    public static final class LeakProjection {
        @NotNull
        private final String shortDescription;
        private final boolean isNew;
        private final boolean isLibraryLeak;
        @NotNull
        private final List<LeakTraceProjection> leakTraces;

        @NotNull
        public final String getShortDescription() {
            return this.shortDescription;
        }

        public final boolean isNew() {
            return this.isNew;
        }

        public final boolean isLibraryLeak() {
            return this.isLibraryLeak;
        }

        @NotNull
        public final List<LeakTraceProjection> getLeakTraces() {
            return this.leakTraces;
        }

        public LeakProjection(@NotNull String shortDescription, boolean isNew, boolean isLibraryLeak, @NotNull List<LeakTraceProjection> leakTraces) {
            Intrinsics.checkParameterIsNotNull((Object)shortDescription, (String)"shortDescription");
            Intrinsics.checkParameterIsNotNull(leakTraces, (String)"leakTraces");
            this.shortDescription = shortDescription;
            this.isNew = isNew;
            this.isLibraryLeak = isLibraryLeak;
            this.leakTraces = leakTraces;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lleakcanary/internal/activity/db/LeakTable$LeakTraceProjection;", "", "leakTraceIndex", "", "heapAnalysisId", "", "classSimpleName", "", "createdAtTimeMillis", "(IJLjava/lang/String;J)V", "getClassSimpleName", "()Ljava/lang/String;", "getCreatedAtTimeMillis", "()J", "getHeapAnalysisId", "getLeakTraceIndex", "()I", "leakcanary-android-core_release"})
    public static final class LeakTraceProjection {
        private final int leakTraceIndex;
        private final long heapAnalysisId;
        @NotNull
        private final String classSimpleName;
        private final long createdAtTimeMillis;

        public final int getLeakTraceIndex() {
            return this.leakTraceIndex;
        }

        public final long getHeapAnalysisId() {
            return this.heapAnalysisId;
        }

        @NotNull
        public final String getClassSimpleName() {
            return this.classSimpleName;
        }

        public final long getCreatedAtTimeMillis() {
            return this.createdAtTimeMillis;
        }

        public LeakTraceProjection(int leakTraceIndex, long heapAnalysisId, @NotNull String classSimpleName, long createdAtTimeMillis) {
            Intrinsics.checkParameterIsNotNull((Object)classSimpleName, (String)"classSimpleName");
            this.leakTraceIndex = leakTraceIndex;
            this.heapAnalysisId = heapAnalysisId;
            this.classSimpleName = classSimpleName;
            this.createdAtTimeMillis = createdAtTimeMillis;
        }
    }
}

