/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal.activity.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import leakcanary.internal.Serializables;
import leakcanary.internal.activity.db.HeapAnalysisTable;
import leakcanary.internal.activity.db.LeaksDbHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.HeapAnalysis;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J \u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0010"}, d2={"Lleakcanary/internal/activity/db/LeaksDbHelper;", "Landroid/database/sqlite/SQLiteOpenHelper;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "onCreate", "", "db", "Landroid/database/sqlite/SQLiteDatabase;", "onDowngrade", "oldVersion", "", "newVersion", "onUpgrade", "recreateDb", "Companion", "leakcanary-android-core_release"})
public final class LeaksDbHelper
extends SQLiteOpenHelper {
    public static final int VERSION = 23;
    @NotNull
    public static final String DATABASE_NAME = "leaks.db";
    public static final Companion Companion = new Companion(null);

    public void onCreate(@NotNull SQLiteDatabase db) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        db.execSQL("CREATE TABLE heap_analysis\n        (\n        id INTEGER PRIMARY KEY AUTOINCREMENT,\n        created_at_time_millis INTEGER,\n        leak_count INTEGER DEFAULT 0,\n        exception_summary TEXT DEFAULT NULL,\n        object BLOB\n        )");
        db.execSQL("\n        CREATE TABLE leak\n        (\n        id INTEGER PRIMARY KEY,\n        signature TEXT UNIQUE,\n        short_description TEXT,\n        is_library_leak INTEGER,\n        is_read INTEGER\n        )");
        db.execSQL("\n        CREATE INDEX leak_signature\n        on leak (signature)\n    ");
        db.execSQL("\n        CREATE TABLE leak_trace\n        (\n        id INTEGER PRIMARY KEY,\n        heap_analysis_id REFERENCES heap_analysis(id),\n        leak_id REFERENCES leak(id),\n        class_simple_name TEXT,\n        leak_trace_index INTEGER\n        )");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpgrade(@NotNull SQLiteDatabase db, int oldVersion, int newVersion) {
        block13: {
            block14: {
                Object cursor;
                block12: {
                    Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
                    if (oldVersion >= 19) break block12;
                    this.recreateDb(db);
                    break block13;
                }
                if (oldVersion != 19) break block14;
                Cursor cursor2 = db.rawQuery("SELECT object FROM heap_analysis", null);
                Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"db.rawQuery(\"SELECT obje\u2026ROM heap_analysis\", null)");
                Cursor $this$use$iv = cursor2;
                boolean $i$f$use = false;
                Throwable exception$iv = null;
                try {
                    cursor = $this$use$iv;
                    boolean $i$a$-use-LeaksDbHelper$onUpgrade$allAnalysis$22 = false;
                    cursor = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<HeapAnalysis>(cursor){
                        final /* synthetic */ Cursor $cursor;

                        @Nullable
                        public final HeapAnalysis invoke() {
                            HeapAnalysis heapAnalysis;
                            if (this.$cursor.moveToNext()) {
                                HeapAnalysis heapAnalysis2;
                                Serializables serializables = Serializables.INSTANCE;
                                byte[] byArray = this.$cursor.getBlob(0);
                                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cursor.getBlob(0)");
                                byte[] byteArray$iv = byArray;
                                boolean $i$f$fromByteArray = false;
                                ByteArrayInputStream inputStream$iv = new ByteArrayInputStream(byteArray$iv);
                                try {
                                    Object object = new ObjectInputStream(inputStream$iv).readObject();
                                    if (!(object instanceof HeapAnalysis)) {
                                        object = null;
                                    }
                                    heapAnalysis2 = (HeapAnalysis)object;
                                }
                                catch (Throwable ignored$iv) {
                                    heapAnalysis2 = null;
                                }
                                heapAnalysis = heapAnalysis2;
                            } else {
                                heapAnalysis = null;
                            }
                            return heapAnalysis;
                        }
                        {
                            this.$cursor = cursor;
                            super(0);
                        }
                    })), (Function1)onUpgrade.allAnalysis.1.2.INSTANCE));
                    Throwable $i$a$-use-LeaksDbHelper$onUpgrade$allAnalysis$22 = exception$iv;
                }
                catch (Throwable e$iv2) {
                    try {
                        exception$iv = e$iv2;
                        throw e$iv2;
                    }
                    catch (Throwable e$iv2) {
                        Throwable $i$a$-use-LeaksDbHelper$onUpgrade$allAnalysis$22 = exception$iv;
                        if ($i$a$-use-LeaksDbHelper$onUpgrade$allAnalysis$22 == null) {
                            $this$use$iv.close();
                        } else {
                            try {
                                $this$use$iv.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        throw e$iv2;
                    }
                }
                $this$use$iv.close();
                Object allAnalysis2 = cursor;
                this.recreateDb(db);
                SQLiteDatabase $this$inTransaction$iv = db;
                boolean $i$f$inTransaction = false;
                try {
                    $this$inTransaction$iv.beginTransaction();
                    SQLiteDatabase $this$inTransaction = $this$inTransaction$iv;
                    boolean bl = false;
                    Iterable $this$forEach$iv = (Iterable)allAnalysis2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        HeapAnalysis it = (HeapAnalysis)element$iv;
                        boolean bl2 = false;
                        HeapAnalysisTable.INSTANCE.insert(db, it);
                    }
                    ContentValues contentValues = new ContentValues();
                    String string2 = "leak";
                    SQLiteDatabase sQLiteDatabase = db;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    ContentValues $this$apply = contentValues;
                    boolean bl5 = false;
                    $this$apply.put("is_read", Integer.valueOf(1));
                    ContentValues contentValues2 = contentValues;
                    int result$iv = sQLiteDatabase.update(string2, contentValues2, null, null);
                    $this$inTransaction$iv.setTransactionSuccessful();
                    int n = result$iv;
                }
                finally {
                    $this$inTransaction$iv.endTransaction();
                }
            }
            throw (Throwable)new IllegalStateException("Database migration from " + oldVersion + " not supported");
        }
    }

    public void onDowngrade(@NotNull SQLiteDatabase db, int oldVersion, int newVersion) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        this.recreateDb(db);
    }

    private final void recreateDb(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS heap_analysis");
        db.execSQL("DROP TABLE IF EXISTS leak");
        db.execSQL("DROP TABLE IF EXISTS leak_trace");
        this.onCreate(db);
    }

    public LeaksDbHelper(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, DATABASE_NAME, null, 23);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lleakcanary/internal/activity/db/LeaksDbHelper$Companion;", "", "()V", "DATABASE_NAME", "", "VERSION", "", "leakcanary-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

