/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal.activity.ui;

import android.content.Context;
import android.text.format.DateUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lleakcanary/internal/activity/ui/TimeFormatter;", "", "()V", "DAY_MILLIS", "", "FIFTY_MINUTES_MILLIS", "HOUR_MILLIS", "MINUTE_MILLIS", "NINETY_MINUTES_MILLIS", "TWO_DAYS_MILLIS", "TWO_MINUTES_MILLIS", "formatTimestamp", "", "context", "Landroid/content/Context;", "timestampMillis", "", "leakcanary-android-core_release"})
public final class TimeFormatter {
    private static final int MINUTE_MILLIS = 60000;
    private static final int TWO_MINUTES_MILLIS = 120000;
    private static final int FIFTY_MINUTES_MILLIS = 3000000;
    private static final int NINETY_MINUTES_MILLIS = 5400000;
    private static final int HOUR_MILLIS = 3600000;
    private static final int DAY_MILLIS = 86400000;
    private static final int TWO_DAYS_MILLIS = 172800000;
    public static final TimeFormatter INSTANCE;

    @NotNull
    public final String formatTimestamp(@NotNull Context context, long timestampMillis) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        long nowMillis = System.currentTimeMillis();
        long diff = nowMillis - timestampMillis;
        long l = diff;
        if (0L <= l && (long)60000 >= l) {
            string2 = "just now";
        } else {
            l = diff;
            if ((long)60000 <= l && (long)120000 >= l) {
                string2 = "a minute ago";
            } else {
                l = diff;
                if ((long)120000 <= l && (long)3000000 >= l) {
                    string2 = diff / (long)60000 + " minutes ago";
                } else {
                    l = diff;
                    if ((long)3000000 <= l && (long)5400000 >= l) {
                        string2 = "an hour ago";
                    } else {
                        l = diff;
                        if ((long)5400000 <= l && (long)86400000 >= l) {
                            string2 = diff / (long)3600000 + " hours ago";
                        } else {
                            l = diff;
                            if ((long)86400000 <= l && (long)172800000 >= l) {
                                string2 = "yesterday";
                            } else {
                                String string3 = DateUtils.formatDateTime((Context)context, (long)timestampMillis, (int)17);
                                string2 = string3;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"DateUtils.formatDateTime\u2026ORMAT_SHOW_DATE\n        )");
                            }
                        }
                    }
                }
            }
        }
        return string2;
    }

    private TimeFormatter() {
    }

    static {
        TimeFormatter timeFormatter;
        INSTANCE = timeFormatter = new TimeFormatter();
    }
}

