/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.mockwebserver;

import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLSocket;

public final class RecordedRequest {
    private final String requestLine;
    private final String method;
    private final String path;
    private final List<String> headers;
    private final List<Integer> chunkSizes;
    private final long bodySize;
    private final byte[] body;
    private final int sequenceNumber;
    private final String sslProtocol;

    public RecordedRequest(String requestLine, List<String> headers, List<Integer> chunkSizes, long bodySize, byte[] body, int sequenceNumber, Socket socket) {
        this.requestLine = requestLine;
        this.headers = headers;
        this.chunkSizes = chunkSizes;
        this.bodySize = bodySize;
        this.body = body;
        this.sequenceNumber = sequenceNumber;
        String string = this.sslProtocol = socket instanceof SSLSocket ? ((SSLSocket)socket).getSession().getProtocol() : null;
        if (requestLine != null) {
            int methodEnd = requestLine.indexOf(32);
            int pathEnd = requestLine.indexOf(32, methodEnd + 1);
            this.method = requestLine.substring(0, methodEnd);
            this.path = requestLine.substring(methodEnd + 1, pathEnd);
        } else {
            this.method = null;
            this.path = null;
        }
    }

    public String getRequestLine() {
        return this.requestLine;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public String getHeader(String name) {
        name = name + ":";
        for (String header : this.headers) {
            if (!name.regionMatches(true, 0, header, 0, name.length())) continue;
            return header.substring(name.length()).trim();
        }
        return null;
    }

    public List<String> getHeaders(String name) {
        ArrayList<String> result = new ArrayList<String>();
        name = name + ":";
        for (String header : this.headers) {
            if (!name.regionMatches(true, 0, header, 0, name.length())) continue;
            result.add(header.substring(name.length()).trim());
        }
        return result;
    }

    public List<Integer> getChunkSizes() {
        return this.chunkSizes;
    }

    public long getBodySize() {
        return this.bodySize;
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getUtf8Body() {
        try {
            return new String(this.body, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError();
        }
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public String toString() {
        return this.requestLine;
    }
}

