/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.builder;

import com.stratio.cassandra.lucene.builder.common.GeoShape;
import com.stratio.cassandra.lucene.builder.common.GeoTransformation;
import com.stratio.cassandra.lucene.builder.index.Index;
import com.stratio.cassandra.lucene.builder.index.Partitioner;
import com.stratio.cassandra.lucene.builder.index.schema.Schema;
import com.stratio.cassandra.lucene.builder.index.schema.analysis.ClasspathAnalyzer;
import com.stratio.cassandra.lucene.builder.index.schema.analysis.SnowballAnalyzer;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.BigDecimalMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.BigIntegerMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.BitemporalMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.BlobMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.BooleanMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.DateMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.DateRangeMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.DoubleMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.FloatMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.GeoPointMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.GeoShapeMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.InetMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.IntegerMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.LongMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.StringMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.TextMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.UUIDMapper;
import com.stratio.cassandra.lucene.builder.search.Search;
import com.stratio.cassandra.lucene.builder.search.condition.AllCondition;
import com.stratio.cassandra.lucene.builder.search.condition.BitemporalCondition;
import com.stratio.cassandra.lucene.builder.search.condition.BooleanCondition;
import com.stratio.cassandra.lucene.builder.search.condition.Condition;
import com.stratio.cassandra.lucene.builder.search.condition.ContainsCondition;
import com.stratio.cassandra.lucene.builder.search.condition.DateRangeCondition;
import com.stratio.cassandra.lucene.builder.search.condition.FuzzyCondition;
import com.stratio.cassandra.lucene.builder.search.condition.GeoBBoxCondition;
import com.stratio.cassandra.lucene.builder.search.condition.GeoDistanceCondition;
import com.stratio.cassandra.lucene.builder.search.condition.GeoShapeCondition;
import com.stratio.cassandra.lucene.builder.search.condition.LuceneCondition;
import com.stratio.cassandra.lucene.builder.search.condition.MatchCondition;
import com.stratio.cassandra.lucene.builder.search.condition.NoneCondition;
import com.stratio.cassandra.lucene.builder.search.condition.PhraseCondition;
import com.stratio.cassandra.lucene.builder.search.condition.PrefixCondition;
import com.stratio.cassandra.lucene.builder.search.condition.RangeCondition;
import com.stratio.cassandra.lucene.builder.search.condition.RegexpCondition;
import com.stratio.cassandra.lucene.builder.search.condition.WildcardCondition;
import com.stratio.cassandra.lucene.builder.search.sort.GeoDistanceSortField;
import com.stratio.cassandra.lucene.builder.search.sort.SimpleSortField;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class Builder {
    public static Index index(String table, String name) {
        return new Index(table, name);
    }

    public static Index index(String keyspace, String table, String name) {
        return new Index(table, name).keyspace(keyspace);
    }

    public static Schema schema() {
        return new Schema();
    }

    public static BigDecimalMapper bigDecimalMapper() {
        return new BigDecimalMapper();
    }

    public static BigIntegerMapper bigIntegerMapper() {
        return new BigIntegerMapper();
    }

    public static BitemporalMapper bitemporalMapper(String vtFrom, String vtTo, String ttFrom, String ttTo) {
        return new BitemporalMapper(vtFrom, vtTo, ttFrom, ttTo);
    }

    public static BlobMapper blobMapper() {
        return new BlobMapper();
    }

    public static BooleanMapper booleanMapper() {
        return new BooleanMapper();
    }

    public static DateMapper dateMapper() {
        return new DateMapper();
    }

    public static DateRangeMapper dateRangeMapper(String from, String to) {
        return new DateRangeMapper(from, to);
    }

    public static DoubleMapper doubleMapper() {
        return new DoubleMapper();
    }

    public static FloatMapper floatMapper() {
        return new FloatMapper();
    }

    public static GeoPointMapper geoPointMapper(String latitude, String longitude) {
        return new GeoPointMapper(latitude, longitude);
    }

    public static GeoShapeMapper geoShapeMapper() {
        return new GeoShapeMapper();
    }

    public static InetMapper inetMapper() {
        return new InetMapper();
    }

    public static IntegerMapper integerMapper() {
        return new IntegerMapper();
    }

    public static LongMapper longMapper() {
        return new LongMapper();
    }

    public static StringMapper stringMapper() {
        return new StringMapper();
    }

    public static TextMapper textMapper() {
        return new TextMapper();
    }

    public static UUIDMapper uuidMapper() {
        return new UUIDMapper();
    }

    public static ClasspathAnalyzer classpathAnalyzer(String className) {
        return new ClasspathAnalyzer(className);
    }

    public static SnowballAnalyzer snowballAnalyzer(String language) {
        return new SnowballAnalyzer(language);
    }

    public static Search search() {
        return new Search();
    }

    public static AllCondition all() {
        return new AllCondition();
    }

    public static BitemporalCondition bitemporal(String field) {
        return new BitemporalCondition(field);
    }

    public static BooleanCondition bool() {
        return new BooleanCondition();
    }

    public static BooleanCondition must(Condition<?> ... conditions) {
        return Builder.bool().must(conditions);
    }

    public static BooleanCondition should(Condition<?> ... conditions) {
        return Builder.bool().should(conditions);
    }

    public static BooleanCondition not(Condition<?> ... conditions) {
        return Builder.bool().not(conditions);
    }

    public static ContainsCondition contains(String field, Object ... values) {
        return new ContainsCondition(field, values);
    }

    public static FuzzyCondition fuzzy(String field, String value) {
        return new FuzzyCondition(field, value);
    }

    public static LuceneCondition lucene(String query) {
        return new LuceneCondition(query);
    }

    public static MatchCondition match(String field, Object value) {
        return new MatchCondition(field, value);
    }

    public static NoneCondition none() {
        return new NoneCondition();
    }

    public static PhraseCondition phrase(String field, String value) {
        return new PhraseCondition(field, value);
    }

    public static PrefixCondition prefix(String field, String value) {
        return new PrefixCondition(field, value);
    }

    public static RangeCondition range(String field) {
        return new RangeCondition(field);
    }

    public static RegexpCondition regexp(String field, String value) {
        return new RegexpCondition(field, value);
    }

    public static WildcardCondition wildcard(String field, String value) {
        return new WildcardCondition(field, value);
    }

    public static GeoBBoxCondition geoBBox(String field, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        return new GeoBBoxCondition(field, minLatitude, maxLatitude, minLongitude, maxLongitude);
    }

    public static GeoDistanceCondition geoDistance(String field, double latitude, double longitude, String maxDistance) {
        return new GeoDistanceCondition(field, latitude, longitude, maxDistance);
    }

    public static GeoShapeCondition geoShape(String field, GeoShape shape) {
        return new GeoShapeCondition(field, shape);
    }

    public static GeoShapeCondition geoShape(String field, String shape) {
        return Builder.geoShape(field, Builder.wkt(shape));
    }

    public static DateRangeCondition dateRange(String field) {
        return new DateRangeCondition(field);
    }

    public static SimpleSortField field(String field) {
        return new SimpleSortField(field);
    }

    public static GeoDistanceSortField geoDistance(String field, double latitude, double longitude) {
        return new GeoDistanceSortField(field, latitude, longitude);
    }

    public static GeoTransformation.BBox bbox() {
        return new GeoTransformation.BBox();
    }

    public static GeoTransformation.Buffer buffer() {
        return new GeoTransformation.Buffer();
    }

    public static GeoTransformation.Centroid centroid() {
        return new GeoTransformation.Centroid();
    }

    public static GeoTransformation.ConvexHull convexHull() {
        return new GeoTransformation.ConvexHull();
    }

    public static GeoShape.WKT wkt(String value) {
        return new GeoShape.WKT(value);
    }

    public static GeoShape.BBox bbox(GeoShape shape) {
        return new GeoShape.BBox(shape);
    }

    public static GeoShape.BBox bbox(String shape) {
        return Builder.bbox(Builder.wkt(shape));
    }

    public static GeoShape.Buffer buffer(GeoShape shape) {
        return new GeoShape.Buffer(shape);
    }

    public static GeoShape.Buffer buffer(String shape) {
        return Builder.buffer(Builder.wkt(shape));
    }

    public static GeoShape.Centroid centroid(GeoShape shape) {
        return new GeoShape.Centroid(shape);
    }

    public static GeoShape.Centroid centroid(String shape) {
        return Builder.centroid(Builder.wkt(shape));
    }

    public static GeoShape.ConvexHull convexHull(GeoShape shape) {
        return new GeoShape.ConvexHull(shape);
    }

    public static GeoShape.ConvexHull convexHull(String shape) {
        return Builder.convexHull(Builder.wkt(shape));
    }

    public static GeoShape.Difference difference() {
        return new GeoShape.Difference(new GeoShape[0]);
    }

    public static GeoShape.Difference difference(GeoShape ... shapes) {
        return new GeoShape.Difference(shapes);
    }

    public static GeoShape.Difference difference(List<GeoShape> shapes) {
        return new GeoShape.Difference(shapes);
    }

    public static GeoShape.Difference difference(String ... shapes) {
        return Builder.difference(Stream.of(shapes).map(Builder::wkt).collect(Collectors.toList()));
    }

    public static GeoShape.Intersection intersection() {
        return new GeoShape.Intersection(new GeoShape[0]);
    }

    public static GeoShape.Intersection intersection(GeoShape ... shapes) {
        return new GeoShape.Intersection(shapes);
    }

    public static GeoShape.Intersection intersection(List<GeoShape> shapes) {
        return new GeoShape.Intersection(shapes);
    }

    public static GeoShape.Intersection intersection(String ... shapes) {
        return Builder.intersection(Stream.of(shapes).map(Builder::wkt).collect(Collectors.toList()));
    }

    public static GeoShape.Union union() {
        return new GeoShape.Union(new GeoShape[0]);
    }

    public static GeoShape.Union union(GeoShape ... shapes) {
        return new GeoShape.Union(shapes);
    }

    public static GeoShape.Union union(List<GeoShape> shapes) {
        return new GeoShape.Union(shapes);
    }

    public static GeoShape.Union union(String ... shapes) {
        return Builder.union(Stream.of(shapes).map(Builder::wkt).collect(Collectors.toList()));
    }

    public static Partitioner.None nonePartitioner() {
        return new Partitioner.None();
    }

    public static Partitioner.OnToken partitionerOnToken(int partitions) {
        return new Partitioner.OnToken(partitions);
    }

    public static Partitioner.OnColumn partitionerOnColumn(int partitions, String column) {
        return new Partitioner.OnColumn(partitions, column);
    }

    public static Partitioner.OnVirtualNode partitionerOnVirtualNodes(int virtualNodesPerPartition) {
        return new Partitioner.OnVirtualNode(virtualNodesPerPartition);
    }
}

