/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.builder;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.stratio.cassandra.lucene.builder.BuilderException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class JSONBuilder {
    private static final ObjectMapper mapper = new ObjectMapper();

    public String toString() {
        return this.build();
    }

    public String build() {
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new BuilderException(e, "Error formatting JSON", new Object[0]);
        }
    }

    @SafeVarargs
    protected static <T> List<T> add(List<T> l, T ... a) {
        if (l == null) {
            l = new ArrayList<T>(a.length);
        }
        l.addAll(Arrays.asList(a));
        return l;
    }

    static {
        mapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(MapperFeature.AUTO_DETECT_IS_GETTERS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

