/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.builder.common;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.stratio.cassandra.lucene.builder.JSONBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=WKT.class, name="wkt"), @JsonSubTypes.Type(value=BBox.class, name="bbox"), @JsonSubTypes.Type(value=Buffer.class, name="buffer"), @JsonSubTypes.Type(value=Centroid.class, name="centroid"), @JsonSubTypes.Type(value=ConvexHull.class, name="convex_hull"), @JsonSubTypes.Type(value=Difference.class, name="difference"), @JsonSubTypes.Type(value=Intersection.class, name="intersection"), @JsonSubTypes.Type(value=Union.class, name="union")})
public abstract class GeoShape
extends JSONBuilder {

    public static class Union
    extends GeoShape {
        @JsonProperty(value="shapes")
        public final List<GeoShape> shapes;

        public Union(GeoShape ... shapes) {
            this(new ArrayList<GeoShape>(Arrays.asList(shapes)));
        }

        public Union(List<GeoShape> shapes) {
            this.shapes = shapes;
        }

        public Union add(GeoShape shape) {
            this.shapes.add(shape);
            return this;
        }

        public Union add(String shape) {
            this.shapes.add(new WKT(shape));
            return this;
        }
    }

    public static class Intersection
    extends GeoShape {
        @JsonProperty(value="shapes")
        public final List<GeoShape> shapes;

        public Intersection(GeoShape ... shapes) {
            this(new ArrayList<GeoShape>(Arrays.asList(shapes)));
        }

        public Intersection(List<GeoShape> shapes) {
            this.shapes = shapes;
        }

        public Intersection add(GeoShape shape) {
            this.shapes.add(shape);
            return this;
        }

        public Intersection add(String shape) {
            this.shapes.add(new WKT(shape));
            return this;
        }
    }

    public static class Difference
    extends GeoShape {
        @JsonProperty(value="shapes")
        public final List<GeoShape> shapes;

        public Difference(GeoShape ... shapes) {
            this(new ArrayList<GeoShape>(Arrays.asList(shapes)));
        }

        public Difference(List<GeoShape> shapes) {
            this.shapes = shapes;
        }

        public Difference add(GeoShape shape) {
            this.shapes.add(shape);
            return this;
        }

        public Difference add(String shape) {
            this.shapes.add(new WKT(shape));
            return this;
        }
    }

    public static class ConvexHull
    extends GeoShape {
        @JsonProperty(value="shape")
        final GeoShape shape;

        public ConvexHull(GeoShape shape) {
            this.shape = shape;
        }
    }

    public static class Centroid
    extends GeoShape {
        @JsonProperty(value="shape")
        final GeoShape shape;

        public Centroid(GeoShape shape) {
            this.shape = shape;
        }
    }

    public static class Buffer
    extends GeoShape {
        @JsonProperty(value="shape")
        final GeoShape shape;
        @JsonProperty(value="max_distance")
        String maxDistance;
        @JsonProperty(value="min_distance")
        String minDistance;

        public Buffer(GeoShape shape) {
            this.shape = shape;
        }

        public Buffer maxDistance(String maxDistance) {
            this.maxDistance = maxDistance;
            return this;
        }

        public Buffer minDistance(String minDistance) {
            this.minDistance = minDistance;
            return this;
        }
    }

    public static class BBox
    extends GeoShape {
        @JsonProperty(value="shape")
        final GeoShape shape;

        public BBox(GeoShape shape) {
            this.shape = shape;
        }
    }

    public static class WKT
    extends GeoShape {
        @JsonProperty(value="value")
        final String value;

        public WKT(String value) {
            this.value = value;
        }
    }
}

