/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.builder.index;

import com.stratio.cassandra.lucene.builder.JSONBuilder;
import com.stratio.cassandra.lucene.builder.index.Partitioner;
import com.stratio.cassandra.lucene.builder.index.schema.Schema;
import com.stratio.cassandra.lucene.builder.index.schema.analysis.Analyzer;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.Mapper;

public class Index
extends JSONBuilder {
    private Schema schema = new Schema();
    private String keyspace;
    private String table;
    private String name;
    private String column;
    private Number refreshSeconds;
    private String directoryPath;
    private Integer ramBufferMb;
    private Integer maxMergeMb;
    private Integer maxCachedMb;
    private Integer indexingThreads;
    private Integer indexingQueuesSize;
    private String excludedDataCenters;
    private Partitioner partitioner;
    private Boolean sparse;

    public Index(String table, String name) {
        this.table = table;
        this.name = name;
    }

    public Index keyspace(String keyspace) {
        this.keyspace = keyspace;
        return this;
    }

    public Index column(String column) {
        this.column = column;
        return this;
    }

    public Index refreshSeconds(Number refreshSeconds) {
        this.refreshSeconds = refreshSeconds;
        return this;
    }

    public Index directoryPath(String directoryPath) {
        this.directoryPath = directoryPath;
        return this;
    }

    public Index ramBufferMb(Integer ramBufferMb) {
        this.ramBufferMb = ramBufferMb;
        return this;
    }

    public Index maxMergeMb(Integer maxMergeMb) {
        this.maxMergeMb = maxMergeMb;
        return this;
    }

    public Index maxCachedMb(Integer maxCachedMb) {
        this.maxCachedMb = maxCachedMb;
        return this;
    }

    public Index indexingThreads(Integer indexingThreads) {
        this.indexingThreads = indexingThreads;
        return this;
    }

    public Index indexingQueuesSize(Integer indexingQueuesSize) {
        this.indexingQueuesSize = indexingQueuesSize;
        return this;
    }

    public Index excludedDataCenters(String excludedDataCenters) {
        this.excludedDataCenters = excludedDataCenters;
        return this;
    }

    public Index defaultAnalyzer(String name) {
        this.schema.defaultAnalyzer(name);
        return this;
    }

    public Index analyzer(String name, Analyzer analyzer) {
        this.schema.analyzer(name, analyzer);
        return this;
    }

    public Index mapper(String field, Mapper mapper) {
        this.schema.mapper(field, mapper);
        return this;
    }

    public Index schema(Schema schema) {
        this.schema = schema;
        return this;
    }

    public Index partitioner(Partitioner partitioner) {
        this.partitioner = partitioner;
        return this;
    }

    public Index sparse(Boolean sparse) {
        this.sparse = sparse;
        return this;
    }

    @Override
    public String build() {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE CUSTOM INDEX ");
        sb.append(this.name).append(" ");
        String fullTable = this.keyspace == null ? this.table : this.keyspace + "." + this.table;
        sb.append(String.format("ON %s(%s) ", fullTable, this.column == null ? "" : this.column));
        sb.append("USING 'com.stratio.cassandra.lucene.Index' WITH OPTIONS = {");
        this.option(sb, "refresh_seconds", this.refreshSeconds);
        this.option(sb, "directory_path", this.directoryPath);
        this.option(sb, "ram_buffer_mb", this.ramBufferMb);
        this.option(sb, "max_merge_mb", this.maxMergeMb);
        this.option(sb, "max_cached_mb", this.maxCachedMb);
        this.option(sb, "indexing_threads", this.indexingThreads);
        this.option(sb, "indexing_queues_size", this.indexingQueuesSize);
        this.option(sb, "excluded_data_centers", this.excludedDataCenters);
        this.option(sb, "partitioner", this.partitioner);
        this.option(sb, "sparse", this.sparse);
        sb.append(String.format("'schema':'%s'}", this.schema));
        return sb.toString();
    }

    private void option(StringBuilder sb, String name, Object value) {
        if (value != null) {
            sb.append(String.format("'%s':'%s',", name, value));
        }
    }
}

