/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.stripe.Stripe;
import com.stripe.exception.InvalidRequestException;
import com.stripe.exception.StripeException;
import com.stripe.model.EphemeralKey;
import com.stripe.model.EphemeralKeyDeserializer;
import com.stripe.model.EventData;
import com.stripe.model.EventDataDeserializer;
import com.stripe.model.EventRequest;
import com.stripe.model.EventRequestDeserializer;
import com.stripe.model.ExpandableField;
import com.stripe.model.ExpandableFieldDeserializer;
import com.stripe.model.HasId;
import com.stripe.model.StripeCollectionInterface;
import com.stripe.model.StripeObject;
import com.stripe.model.StripeObjectInterface;
import com.stripe.model.StripeRawJsonObject;
import com.stripe.model.StripeRawJsonObjectDeserializer;
import com.stripe.model.StripeSearchResultInterface;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResourceTypeAdapterFactoryProvider;
import com.stripe.net.LiveStripeResponseGetter;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.util.StringUtils;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;

public abstract class ApiResource
extends StripeObject {
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    private static StripeResponseGetter stripeResponseGetter = new LiveStripeResponseGetter();
    public static final Gson GSON = ApiResource.createGson();

    public static void setStripeResponseGetter(StripeResponseGetter srg) {
        stripeResponseGetter = srg;
    }

    private static Gson createGson() {
        GsonBuilder builder = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(EphemeralKey.class, (Object)new EphemeralKeyDeserializer()).registerTypeAdapter(EventData.class, (Object)new EventDataDeserializer()).registerTypeAdapter(EventRequest.class, (Object)new EventRequestDeserializer()).registerTypeAdapter(ExpandableField.class, (Object)new ExpandableFieldDeserializer()).registerTypeAdapter(StripeRawJsonObject.class, (Object)new StripeRawJsonObjectDeserializer());
        for (TypeAdapterFactory factory : ApiResourceTypeAdapterFactoryProvider.getAll()) {
            builder.registerTypeAdapterFactory(factory);
        }
        return builder.create();
    }

    private static String className(Class<?> clazz) {
        String className = StringUtils.toSnakeCase(clazz.getSimpleName());
        String[] parts = clazz.getPackage().getName().split("\\.", -1);
        assert (parts.length == 3 || parts.length == 4);
        if (parts.length == 4) {
            className = parts[3] + "/" + className;
        }
        switch (className) {
            case "invoice_item": {
                return "invoiceitem";
            }
            case "file_upload": {
                return "file";
            }
        }
        return className;
    }

    protected static String singleClassUrl(Class<?> clazz) {
        return ApiResource.singleClassUrl(clazz, Stripe.getApiBase());
    }

    protected static String singleClassUrl(Class<?> clazz, String apiBase) {
        return String.format("%s/v1/%s", apiBase, ApiResource.className(clazz));
    }

    protected static String classUrl(Class<?> clazz) {
        return ApiResource.classUrl(clazz, Stripe.getApiBase());
    }

    protected static String classUrl(Class<?> clazz, String apiBase) {
        return String.format("%ss", ApiResource.singleClassUrl(clazz, apiBase));
    }

    protected static String instanceUrl(Class<?> clazz, String id) throws InvalidRequestException {
        return ApiResource.instanceUrl(clazz, id, Stripe.getApiBase());
    }

    protected static String instanceUrl(Class<?> clazz, String id, String apiBase) throws InvalidRequestException {
        return String.format("%s/%s", ApiResource.classUrl(clazz, apiBase), ApiResource.urlEncode(id));
    }

    protected static String subresourceUrl(Class<?> clazz, String id, Class<?> subClazz) throws InvalidRequestException {
        return ApiResource.subresourceUrl(clazz, id, subClazz, Stripe.getApiBase());
    }

    private static String subresourceUrl(Class<?> clazz, String id, Class<?> subClazz, String apiBase) throws InvalidRequestException {
        return String.format("%s/%s/%ss", ApiResource.classUrl(clazz, apiBase), ApiResource.urlEncode(id), ApiResource.className(subClazz));
    }

    public static String urlEncode(String str) {
        if (str == null) {
            return null;
        }
        try {
            return URLEncoder.encode(str, CHARSET.name()).replaceAll("%5B", "[").replaceAll("%5D", "]");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is unknown");
        }
    }

    public static String urlEncodeId(String id) throws InvalidRequestException {
        if (id == null) {
            throw new InvalidRequestException("Invalid null ID found for url path formatting. This can be because your string ID argument to the API method is null, or the ID field in your stripe object instance is null. Please contact support@stripe.com on the latter case. ", null, null, null, 0, null);
        }
        return ApiResource.urlEncode(id);
    }

    public static <T extends StripeObjectInterface> T request(RequestMethod method, String url, ApiRequestParams params, Class<T> clazz, RequestOptions options) throws StripeException {
        ApiResource.checkNullTypedParams(url, params);
        return ApiResource.request(method, url, params.toMap(), clazz, options);
    }

    public static <T extends StripeObjectInterface> T request(RequestMethod method, String url, Map<String, Object> params, Class<T> clazz, RequestOptions options) throws StripeException {
        return stripeResponseGetter.request(method, url, params, clazz, options);
    }

    public static InputStream requestStream(RequestMethod method, String url, ApiRequestParams params, RequestOptions options) throws StripeException {
        ApiResource.checkNullTypedParams(url, params);
        return ApiResource.requestStream(method, url, params.toMap(), options);
    }

    public static InputStream requestStream(RequestMethod method, String url, Map<String, Object> params, RequestOptions options) throws StripeException {
        return stripeResponseGetter.requestStream(method, url, params, options);
    }

    public static <T extends StripeCollectionInterface<?>> T requestCollection(String url, ApiRequestParams params, Class<T> clazz, RequestOptions options) throws StripeException {
        ApiResource.checkNullTypedParams(url, params);
        return ApiResource.requestCollection(url, params.toMap(), clazz, options);
    }

    public static <T extends StripeCollectionInterface<?>> T requestCollection(String url, Map<String, Object> params, Class<T> clazz, RequestOptions options) throws StripeException {
        StripeCollectionInterface collection = (StripeCollectionInterface)ApiResource.request(RequestMethod.GET, url, params, clazz, options);
        if (collection != null) {
            collection.setRequestOptions(options);
            collection.setRequestParams(params);
        }
        return (T)collection;
    }

    public static <T extends StripeSearchResultInterface<?>> T requestSearchResult(String url, ApiRequestParams params, Class<T> clazz, RequestOptions options) throws StripeException {
        ApiResource.checkNullTypedParams(url, params);
        return ApiResource.requestSearchResult(url, params.toMap(), clazz, options);
    }

    public static <T extends StripeSearchResultInterface<?>> T requestSearchResult(String url, Map<String, Object> params, Class<T> clazz, RequestOptions options) throws StripeException {
        StripeSearchResultInterface searchResult = (StripeSearchResultInterface)ApiResource.request(RequestMethod.GET, url, params, clazz, options);
        if (searchResult != null) {
            searchResult.setRequestOptions(options);
            searchResult.setRequestParams(params);
        }
        return (T)searchResult;
    }

    public static void checkNullTypedParams(String url, ApiRequestParams params) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Found null params for %s. Please pass empty params using param builder via `builder().build()` instead.", url));
        }
    }

    public static <T extends HasId> ExpandableField<T> setExpandableFieldId(String newId, ExpandableField<T> currentObject) {
        if (currentObject == null || currentObject.isExpanded() && !Objects.equals(currentObject.getId(), newId)) {
            return new ExpandableField<Object>(newId, null);
        }
        return new ExpandableField<T>(newId, currentObject.getExpanded());
    }

    public static enum RequestMethod {
        GET,
        POST,
        DELETE;

    }
}

