/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.local;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.TransportTubeFactory;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.http.DeploymentDescriptorParser;
import com.sun.xml.ws.transport.http.ResourceLoader;
import com.sun.xml.ws.transport.local.FileSystemResourceLoader;
import com.sun.xml.ws.transport.local.LocalAsyncTransportTube;
import com.sun.xml.ws.transport.local.LocalTransportTube;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalTransportFactory
extends TransportTubeFactory {
    public Tube doCreate(@NotNull ClientTubeAssemblerContext context) {
        URI adrs = context.getAddress().getURI();
        if (!adrs.getScheme().equals("local") && !adrs.getScheme().equals("local-async")) {
            return null;
        }
        return adrs.getScheme().equals("local") ? new LocalTransportTube(adrs, LocalTransportFactory.createServerService(adrs), context.getCodec()) : new LocalAsyncTransportTube(adrs, LocalTransportFactory.createServerService(adrs), context.getCodec());
    }

    protected static WSEndpoint createServerService(URI adrs) {
        try {
            String outputDir = adrs.getPath();
            List<WSEndpoint> endpoints = LocalTransportFactory.parseEndpoints(outputDir);
            WSEndpoint endpoint = endpoints.get(0);
            if (endpoints.size() > 1) {
                for (WSEndpoint rei : endpoints) {
                    if (!rei.getPort().getName().getLocalPart().equals(adrs.getQuery())) continue;
                    endpoint = rei;
                    break;
                }
            }
            return endpoint;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    protected static List<WSEndpoint> parseEndpoints(String outputDir) throws IOException {
        String riFile = outputDir + "/WEB-INF/sun-jaxws.xml";
        DeploymentDescriptorParser parser = new DeploymentDescriptorParser(Thread.currentThread().getContextClassLoader(), (ResourceLoader)new FileSystemResourceLoader(new File(outputDir)), null, (DeploymentDescriptorParser.AdapterFactory)new DeploymentDescriptorParser.AdapterFactory<WSEndpoint>(){

            public WSEndpoint createAdapter(String name, String urlPattern, WSEndpoint<?> endpoint) {
                return endpoint;
            }
        });
        return parser.parse(new File(riFile));
    }
}

