/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding;

import com.sun.xml.bind.DatatypeConverterImpl;
import com.sun.xml.messaging.saaj.packaging.mime.util.OutputUtil;
import com.sun.xml.stream.writers.UTF8OutputStreamWriter;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Attachment;
import com.sun.xml.ws.api.message.AttachmentSet;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.ContentType;
import com.sun.xml.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.api.streaming.XMLStreamWriterFactory;
import com.sun.xml.ws.encoding.ContentTypeImpl;
import com.sun.xml.ws.encoding.MimeCodec;
import com.sun.xml.ws.encoding.MimeMultipartParser;
import com.sun.xml.ws.encoding.StreamSOAPCodec;
import com.sun.xml.ws.message.MimeAttachmentSet;
import com.sun.xml.ws.message.stream.StreamAttachment;
import com.sun.xml.ws.util.xml.XMLStreamReaderFilter;
import com.sun.xml.ws.util.xml.XMLStreamWriterFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.jvnet.staxex.Base64Data;
import org.jvnet.staxex.NamespaceContextEx;
import org.jvnet.staxex.XMLStreamReaderEx;
import org.jvnet.staxex.XMLStreamWriterEx;

public class MtomCodec
extends MimeCodec {
    public static final String XOP_XML_MIME_TYPE = "application/xop+xml";
    private final com.sun.xml.ws.api.pipe.StreamSOAPCodec codec;
    private String boundary;
    private final String soapXopContentType;
    private String messageContentType;
    private UTF8OutputStreamWriter osWriter;
    private final MTOMFeature mtomFeature;
    private final List<ByteArrayBuffer> mtomAttachmentStream = new ArrayList<ByteArrayBuffer>();
    private static final String XOP_PREF = "<Include xmlns=\"http://www.w3.org/2004/08/xop/include\" href=\"cid:";
    private static final String XOP_SUFF = "\"/>";
    private static final String XOP_LOCALNAME = "Include";
    private static final String XOP_NAMESPACEURI = "http://www.w3.org/2004/08/xop/include";

    MtomCodec(SOAPVersion version, com.sun.xml.ws.api.pipe.StreamSOAPCodec codec, WebServiceFeature mtomFeature) {
        super(version);
        this.codec = codec;
        this.createConteTypeHeader();
        this.soapXopContentType = "application/xop+xml;charset=utf-8;type=\"" + version.contentType + "\"";
        this.mtomFeature = mtomFeature == null ? new MTOMFeature() : (MTOMFeature)mtomFeature;
    }

    private void createConteTypeHeader() {
        this.boundary = "uuid:" + UUID.randomUUID().toString();
        String boundaryParameter = "boundary=\"" + this.boundary + "\"";
        this.messageContentType = "multipart/related;type=\"application/xop+xml\";" + boundaryParameter + ";start-info=\"" + this.version.contentType + "\"";
    }

    public ContentType getStaticContentType(Packet packet) {
        return this.getContentType(packet);
    }

    private ContentType getContentType(Packet packet) {
        switch (this.version) {
            case SOAP_11: {
                return new ContentTypeImpl(this.messageContentType, packet.soapAction == null ? "" : packet.soapAction, null);
            }
            case SOAP_12: {
                if (packet.soapAction != null) {
                    this.messageContentType = this.messageContentType + ";action=\"" + packet.soapAction + "\"";
                }
                return new ContentTypeImpl(this.messageContentType, null, null);
            }
        }
        return null;
    }

    public ContentType encode(Packet packet, OutputStream out) throws IOException {
        this.mtomAttachmentStream.clear();
        ContentType contentType = this.getContentType(packet);
        this.osWriter = new UTF8OutputStreamWriter(out);
        if (packet.getMessage() != null) {
            try {
                OutputUtil.writeln((String)("--" + this.boundary), (OutputStream)out);
                OutputUtil.writeln((String)("Content-Type: " + this.soapXopContentType), (OutputStream)out);
                OutputUtil.writeln((String)"Content-Transfer-Encoding: binary", (OutputStream)out);
                OutputUtil.writeln((OutputStream)out);
                MtomStreamWriter writer = new MtomStreamWriter(XMLStreamWriterFactory.create(out));
                packet.getMessage().writeTo(writer);
                XMLStreamWriterFactory.recycle(writer);
                OutputUtil.writeln((OutputStream)out);
                for (ByteArrayBuffer bos : this.mtomAttachmentStream) {
                    bos.write(out);
                }
                this.writeAttachments(packet.getMessage().getAttachments(), out);
                OutputUtil.writeAsAscii((String)("--" + this.boundary), (OutputStream)out);
                OutputUtil.writeAsAscii((String)"--", (OutputStream)out);
            }
            catch (XMLStreamException e) {
                throw new WebServiceException((Throwable)e);
            }
        }
        this.createConteTypeHeader();
        return contentType;
    }

    private void writeMimeHeaders(String contentType, String contentId, OutputStream out) throws IOException {
        OutputUtil.writeln((String)("Content-Type: " + contentType), (OutputStream)out);
        String cid = contentId;
        if (cid != null && cid.length() > 0 && cid.charAt(0) != '<') {
            cid = '<' + cid + '>';
        }
        OutputUtil.writeln((String)("Content-Id: " + cid), (OutputStream)out);
        OutputUtil.writeln((String)"Content-Transfer-Encoding: binary", (OutputStream)out);
        OutputUtil.writeln((OutputStream)out);
    }

    private void writeAttachments(AttachmentSet attachments, OutputStream out) throws IOException {
        for (Attachment att : attachments) {
            OutputUtil.writeln((String)("--" + this.boundary), (OutputStream)out);
            this.writeMimeHeaders(att.getContentType(), att.getContentId(), out);
            att.writeTo(out);
            OutputUtil.writeln((OutputStream)out);
        }
    }

    public ContentType encode(Packet packet, WritableByteChannel buffer) {
        throw new UnsupportedOperationException();
    }

    public MtomCodec copy() {
        return new MtomCodec(this.version, (com.sun.xml.ws.api.pipe.StreamSOAPCodec)this.codec.copy(), (WebServiceFeature)this.mtomFeature);
    }

    private String encodeCid() {
        String cid = "example.jaxws.sun.com";
        String name = UUID.randomUUID() + "@";
        return name + cid;
    }

    protected void decode(MimeMultipartParser mpp, Packet packet) throws IOException {
        MtomXMLStreamReaderEx mtomReader = new MtomXMLStreamReaderEx(mpp, XMLStreamReaderFactory.create(null, mpp.getRootPart().asInputStream(), true));
        if (this.codec instanceof StreamSOAPCodec) {
            packet.setMessage(((StreamSOAPCodec)this.codec).decode((XMLStreamReader)((Object)mtomReader), new MimeAttachmentSet(mpp)));
        } else {
            packet.setMessage(this.codec.decode((XMLStreamReader)((Object)mtomReader)));
        }
    }

    private static class MtomXMLStreamReaderEx
    extends XMLStreamReaderFilter
    implements XMLStreamReaderEx {
        private final MimeMultipartParser mimeMP;
        private boolean xopReferencePresent = false;
        private Base64Data base64AttData;
        private int textLength;
        private int textStart;
        private char[] base64EncodedText;

        public MtomXMLStreamReaderEx(MimeMultipartParser mimeMP, XMLStreamReader reader) {
            super(reader);
            this.mimeMP = mimeMP;
        }

        public CharSequence getPCDATA() throws XMLStreamException {
            if (this.xopReferencePresent) {
                return this.base64AttData;
            }
            return this.reader.getText();
        }

        public NamespaceContextEx getNamespaceContext() {
            NamespaceContext nsContext = this.reader.getNamespaceContext();
            return new MtomNamespaceContextEx(nsContext);
        }

        public String getElementTextTrim() throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        public int getTextLength() {
            if (this.xopReferencePresent) {
                return this.textLength;
            }
            return this.reader.getTextLength();
        }

        public int getTextStart() {
            if (this.xopReferencePresent) {
                return 0;
            }
            return this.reader.getTextStart();
        }

        public int getEventType() {
            if (this.xopReferencePresent) {
                return 4;
            }
            return super.getEventType();
        }

        public int next() throws XMLStreamException {
            int event = this.reader.next();
            if (event == 1 && this.reader.getLocalName().equals(MtomCodec.XOP_LOCALNAME) && this.reader.getNamespaceURI().equals(MtomCodec.XOP_NAMESPACEURI)) {
                String href = this.reader.getAttributeValue(null, "href");
                try {
                    StreamAttachment att = this.getAttachment(href);
                    if (att != null) {
                        this.base64AttData = att.asBase64Data();
                        this.textLength = this.base64AttData.getDataLen();
                    }
                    this.textStart = 0;
                    this.xopReferencePresent = true;
                }
                catch (IOException e) {
                    throw new WebServiceException((Throwable)e);
                }
                try {
                    this.reader.next();
                }
                catch (XMLStreamException e) {
                    throw new WebServiceException((Throwable)e);
                }
                return 4;
            }
            if (this.xopReferencePresent) {
                this.xopReferencePresent = false;
                this.textStart = 0;
                this.textLength = 0;
                this.base64EncodedText = null;
            }
            return event;
        }

        private String decodeCid(String cid) {
            try {
                cid = URLDecoder.decode(cid, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                return cid;
            }
            return cid;
        }

        private boolean needToDecode(String cid) {
            int numChars = cid.length();
            int i = 0;
            while (i < numChars) {
                char c = cid.charAt(i++);
                switch (c) {
                    case '%': {
                        return true;
                    }
                }
            }
            return false;
        }

        private StreamAttachment getAttachment(String cid) throws IOException {
            StreamAttachment att;
            if (cid.startsWith("cid:")) {
                cid = cid.substring(4, cid.length());
            }
            if ((att = this.mimeMP.getAttachmentPart(cid)) == null && this.needToDecode(cid)) {
                cid = this.decodeCid(cid);
                return this.mimeMP.getAttachmentPart(cid);
            }
            return att;
        }

        public char[] getTextCharacters() {
            if (this.xopReferencePresent) {
                char[] chars = new char[this.base64AttData.length()];
                this.base64AttData.writeTo(chars, 0);
                this.textLength = chars.length;
                return chars;
            }
            return this.reader.getTextCharacters();
        }

        public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
            if (this.xopReferencePresent) {
                int event = this.reader.getEventType();
                if (event != 4) {
                    throw new XMLStreamException("Invalid state: Expected CHARACTERS found :");
                }
                if (target == null) {
                    throw new NullPointerException("target char array can't be null");
                }
                if (targetStart < 0 || length < 0 || sourceStart < 0 || targetStart >= target.length || targetStart + length > target.length) {
                    throw new IndexOutOfBoundsException();
                }
                if (this.base64EncodedText != null) {
                    this.base64EncodedText = new char[this.base64AttData.length()];
                    this.base64AttData.writeTo(this.base64EncodedText, 0);
                    this.textLength = this.base64EncodedText.length;
                    this.textStart = 0;
                }
                if (this.textStart + sourceStart > this.textLength) {
                    throw new IndexOutOfBoundsException();
                }
                int available = this.textLength - sourceStart;
                if (available < 0) {
                    throw new IndexOutOfBoundsException("sourceStart is greater thannumber of characters associated with this event");
                }
                int copiedLength = Math.min(available, length);
                System.arraycopy(this.base64EncodedText, this.getTextStart() + sourceStart, target, targetStart, copiedLength);
                this.textStart = sourceStart;
                return copiedLength;
            }
            return this.reader.getTextCharacters(sourceStart, target, targetStart, length);
        }

        public String getText() {
            if (this.xopReferencePresent) {
                String text = this.base64AttData.toString();
                this.textLength = text.length();
            }
            return this.reader.getText();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class MtomNamespaceContextEx
        implements NamespaceContextEx {
            private NamespaceContext nsContext;

            public MtomNamespaceContextEx(NamespaceContext nsContext) {
                this.nsContext = nsContext;
            }

            public Iterator<NamespaceContextEx.Binding> iterator() {
                throw new UnsupportedOperationException();
            }

            public String getNamespaceURI(String prefix) {
                return this.nsContext.getNamespaceURI(prefix);
            }

            public String getPrefix(String namespaceURI) {
                return this.nsContext.getPrefix(namespaceURI);
            }

            public Iterator getPrefixes(String namespaceURI) {
                return this.nsContext.getPrefixes(namespaceURI);
            }
        }
    }

    private class MtomStreamWriter
    extends XMLStreamWriterFilter
    implements XMLStreamWriterEx {
        public MtomStreamWriter(XMLStreamWriter w) {
            super(w);
        }

        public void writeBinary(byte[] data, int start, int len, String contentType) throws XMLStreamException {
            if (MtomCodec.this.mtomFeature.getThreshold() > len - start) {
                this.writeCharacters(DatatypeConverterImpl._printBase64Binary((byte[])data, (int)start, (int)len));
                return;
            }
            try {
                ByteArrayBuffer bos = new ByteArrayBuffer(data, start, len, contentType);
                MtomCodec.this.mtomAttachmentStream.add(bos);
                this.writer.flush();
                this.writer.writeCharacters("");
                MtomCodec.this.osWriter.write(MtomCodec.XOP_PREF + bos.contentId + MtomCodec.XOP_SUFF);
            }
            catch (IOException e) {
                throw new WebServiceException((Throwable)e);
            }
            catch (XMLStreamException e) {
                throw new WebServiceException((Throwable)e);
            }
        }

        public void writeBinary(DataHandler dataHandler) throws XMLStreamException {
            Base64Data data = new Base64Data();
            data.set(dataHandler);
            this.writePCDATA((CharSequence)data);
        }

        public OutputStream writeBinary(String contentType) throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        public void writePCDATA(CharSequence data) throws XMLStreamException {
            if (data == null) {
                return;
            }
            if (data instanceof Base64Data) {
                Base64Data binaryData = (Base64Data)data;
                this.writeBinary(binaryData.getExact(), 0, binaryData.getDataLen(), binaryData.getMimeType());
                return;
            }
            this.writeCharacters(((Object)data).toString());
        }

        public NamespaceContextEx getNamespaceContext() {
            NamespaceContext nsContext = this.writer.getNamespaceContext();
            return new MtomNamespaceContextEx(nsContext);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class MtomNamespaceContextEx
        implements NamespaceContextEx {
            private NamespaceContext nsContext;

            public MtomNamespaceContextEx(NamespaceContext nsContext) {
                this.nsContext = nsContext;
            }

            public Iterator<NamespaceContextEx.Binding> iterator() {
                throw new UnsupportedOperationException();
            }

            public String getNamespaceURI(String prefix) {
                return this.nsContext.getNamespaceURI(prefix);
            }

            public String getPrefix(String namespaceURI) {
                return this.nsContext.getPrefix(namespaceURI);
            }

            public Iterator getPrefixes(String namespaceURI) {
                return this.nsContext.getPrefixes(namespaceURI);
            }
        }
    }

    private class ByteArrayBuffer {
        private final byte[] buff;
        private final int off;
        private final int len;
        private final String contentType;
        final String contentId;

        ByteArrayBuffer(byte[] buff, int off, int len, String contentType) {
            this.buff = buff;
            this.off = off;
            this.len = len;
            this.contentType = contentType;
            this.contentId = MtomCodec.this.encodeCid();
        }

        void write(OutputStream os) throws IOException {
            OutputUtil.writeln((String)("--" + MtomCodec.this.boundary), (OutputStream)os);
            MtomCodec.this.writeMimeHeaders(this.contentType, this.contentId, os);
            os.write(this.buff, this.off, this.len);
            OutputUtil.writeln((OutputStream)os);
        }
    }
}

