/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding;

import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.pipe.ContentType;
import com.sun.xml.ws.encoding.ContentTypeImpl;
import com.sun.xml.ws.encoding.StreamSOAPCodec;
import com.sun.xml.ws.message.stream.StreamHeader;
import com.sun.xml.ws.message.stream.StreamHeader11;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StreamSOAP11Codec
extends StreamSOAPCodec {
    public static final String SOAP11_MIME_TYPE = "text/xml";
    public static final String SOAP11_CONTENT_TYPE = "text/xml; charset=utf-8";
    private static final List<String> expectedContentTypes = Collections.singletonList("text/xml");
    public static final ContentTypeImpl defaultContentType = new ContentTypeImpl("text/xml; charset=utf-8", "\"\"");

    StreamSOAP11Codec() {
        super(SOAPVersion.SOAP_11);
    }

    @Override
    public String getMimeType() {
        return SOAP11_MIME_TYPE;
    }

    @Override
    protected final StreamHeader createHeader(XMLStreamReader reader, XMLStreamBuffer mark) {
        return new StreamHeader11(reader, mark);
    }

    @Override
    protected ContentType getContentType(String soapAction) {
        if (soapAction == null || soapAction.length() == 0) {
            return defaultContentType;
        }
        if (soapAction.charAt(0) != '\"' && soapAction.charAt(soapAction.length() - 1) != '\"') {
            soapAction = "\"" + soapAction + "\"";
        }
        return new ContentTypeImpl(SOAP11_CONTENT_TYPE, soapAction);
    }

    @Override
    protected List<String> getExpectedContentTypes() {
        return expectedContentTypes;
    }
}

