/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server;

import com.sun.xml.ws.api.server.DocumentAddressResolver;
import com.sun.xml.ws.api.server.PortAddressResolver;
import com.sun.xml.ws.api.server.SDDocument;
import com.sun.xml.ws.api.server.SDDocumentFilter;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.server.ServerRtException;
import com.sun.xml.ws.server.ServiceDefinitionImpl;
import com.sun.xml.ws.server.WSDLPatcher;
import com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.ws.wsdl.parser.ParserUtil;
import com.sun.xml.ws.wsdl.parser.WSDLConstants;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SDDocumentImpl
extends SDDocumentSource
implements SDDocument {
    private static final String NS_XSD = "http://www.w3.org/2001/XMLSchema";
    private static final QName SCHEMA_INCLUDE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "include");
    private static final QName SCHEMA_IMPORT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "import");
    private final QName rootName;
    private final SDDocumentSource source;
    ServiceDefinitionImpl owner;
    private final URL url;
    private final Set<URL> imports;
    private static final XMLInputFactory xif = XMLInputFactory.newInstance();
    private static final XMLOutputFactory xof = XMLOutputFactory.newInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SDDocumentImpl create(SDDocumentSource src, QName serviceName, QName portTypeName) {
        URL systemId = src.getSystemId();
        try {
            QName rootName;
            XMLStreamReader reader;
            block17: {
                block16: {
                    reader = src.read(xif);
                    XMLStreamReaderUtil.nextElementContent(reader);
                    rootName = reader.getName();
                    if (rootName.equals(WSDLConstants.QNAME_SCHEMA)) break block16;
                    if (!rootName.equals(WSDLConstants.QNAME_DEFINITIONS)) {
                        SDDocumentImpl sDDocumentImpl = new SDDocumentImpl(rootName, systemId, src);
                        return sDDocumentImpl;
                    }
                    break block17;
                    finally {
                        reader.close();
                    }
                }
                String tns = ParserUtil.getMandatoryNonEmptyAttribute(reader, "targetNamespace");
                HashSet<URL> importedDocs = new HashSet<URL>();
                while (true) {
                    String importedDoc;
                    Object name;
                    if (XMLStreamReaderUtil.nextContent(reader) == 8) {
                        name = new SchemaImpl(rootName, systemId, src, tns, importedDocs);
                        return name;
                    }
                    if (reader.getEventType() != 1 || !SCHEMA_INCLUDE_QNAME.equals(name = reader.getName()) && !SCHEMA_IMPORT_QNAME.equals(name) || (importedDoc = reader.getAttributeValue(null, "schemaLocation")) == null) continue;
                    importedDocs.add(new URL(src.getSystemId(), importedDoc));
                }
            }
            String tns = ParserUtil.getMandatoryNonEmptyAttribute(reader, "targetNamespace");
            boolean hasPortType = false;
            boolean hasService = false;
            HashSet<URL> importedDocs = new HashSet<URL>();
            while (true) {
                String importedDoc;
                if (XMLStreamReaderUtil.nextContent(reader) == 8) {
                    WSDLImpl wSDLImpl = new WSDLImpl(rootName, systemId, src, tns, hasPortType, hasService, importedDocs);
                    return wSDLImpl;
                }
                if (reader.getEventType() != 1) continue;
                QName name = reader.getName();
                if (WSDLConstants.QNAME_PORT_TYPE.equals(name)) {
                    String pn = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
                    if (portTypeName == null || !portTypeName.getLocalPart().equals(pn) || !portTypeName.getNamespaceURI().equals(tns)) continue;
                    hasPortType = true;
                    continue;
                }
                if (WSDLConstants.QNAME_SERVICE.equals(name)) {
                    String sn = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
                    QName sqn = new QName(tns, sn);
                    if (!serviceName.equals(sqn)) continue;
                    hasService = true;
                    continue;
                }
                if (WSDLConstants.QNAME_IMPORT.equals(name)) {
                    importedDoc = reader.getAttributeValue(null, "location");
                    if (importedDoc == null) continue;
                    importedDocs.add(new URL(src.getSystemId(), importedDoc));
                    continue;
                }
                if (!SCHEMA_INCLUDE_QNAME.equals(name) && !SCHEMA_IMPORT_QNAME.equals(name) || (importedDoc = reader.getAttributeValue(null, "schemaLocation")) == null) continue;
                importedDocs.add(new URL(src.getSystemId(), importedDoc));
            }
        }
        catch (IOException e) {
            throw new ServerRtException("runtime.parser.wsdl", systemId, e);
        }
        catch (XMLStreamException e) {
            throw new ServerRtException("runtime.parser.wsdl", systemId, e);
        }
    }

    protected SDDocumentImpl(QName rootName, URL url, SDDocumentSource source) {
        this(rootName, url, source, new HashSet<URL>());
    }

    protected SDDocumentImpl(QName rootName, URL url, SDDocumentSource source, Set<URL> imports) {
        assert (url != null);
        this.rootName = rootName;
        this.source = source;
        this.url = url;
        this.imports = imports;
    }

    @Override
    public QName getRootName() {
        return this.rootName;
    }

    @Override
    public boolean isWSDL() {
        return false;
    }

    @Override
    public boolean isSchema() {
        return false;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public XMLStreamReader read(XMLInputFactory xif) throws IOException, XMLStreamException {
        return this.source.read(xif);
    }

    @Override
    public URL getSystemId() {
        return this.url;
    }

    public Set<URL> getImports() {
        return this.imports;
    }

    @Override
    public void writeTo(PortAddressResolver portAddressResolver, DocumentAddressResolver resolver, OutputStream os) throws IOException {
        try {
            XMLStreamWriter w = xof.createXMLStreamWriter(os, "utf-8");
            w.writeStartDocument("utf-8", "1.0");
            this.writeTo(portAddressResolver, resolver, w);
            w.writeEndDocument();
            w.flush();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Override
    public void writeTo(PortAddressResolver portAddressResolver, DocumentAddressResolver resolver, XMLStreamWriter out) throws XMLStreamException, IOException {
        for (SDDocumentFilter f : this.owner.filters) {
            out = f.filter(this, out);
        }
        new WSDLPatcher(this.owner.owner, this, portAddressResolver, resolver).bridge(this.source.read(xif), out);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WSDLImpl
    extends SDDocumentImpl
    implements SDDocument.WSDL {
        private final String targetNamespace;
        private final boolean hasPortType;
        private final boolean hasService;

        public WSDLImpl(QName rootName, URL url, SDDocumentSource source, String targetNamespace, boolean hasPortType, boolean hasService, Set<URL> imports) {
            super(rootName, url, source, imports);
            this.targetNamespace = targetNamespace;
            this.hasPortType = hasPortType;
            this.hasService = hasService;
        }

        @Override
        public String getTargetNamespace() {
            return this.targetNamespace;
        }

        @Override
        public boolean hasPortType() {
            return this.hasPortType;
        }

        @Override
        public boolean hasService() {
            return this.hasService;
        }

        @Override
        public boolean isWSDL() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SchemaImpl
    extends SDDocumentImpl
    implements SDDocument.Schema {
        private final String targetNamespace;

        public SchemaImpl(QName rootName, URL url, SDDocumentSource source, String targetNamespace, Set<URL> imports) {
            super(rootName, url, source, imports);
            this.targetNamespace = targetNamespace;
        }

        @Override
        public String getTargetNamespace() {
            return this.targetNamespace;
        }

        @Override
        public boolean isSchema() {
            return true;
        }
    }
}

