/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.client;

import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.client.ClientTransportException;
import com.sun.xml.ws.resources.ClientMessages;
import com.sun.xml.ws.transport.Headers;
import com.sun.xml.ws.transport.http.client.CookieJar;
import com.sun.xml.ws.util.ByteArrayBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HttpClientTransport {
    private static String LAST_ENDPOINT;
    private static boolean redirect;
    private static final int START_REDIRECT_COUNT = 3;
    private static int redirectCount;
    int statusCode;
    private final Map<String, List<String>> reqHeaders;
    private Map<String, List<String>> respHeaders = null;
    private OutputStream outputStream;
    private boolean https;
    HttpURLConnection httpConnection = null;
    EndpointAddress endpoint = null;
    Packet context = null;
    CookieJar cookieJar = null;
    boolean isFailure = false;

    public HttpClientTransport(Packet packet, Map<String, List<String>> reqHeaders) {
        this.endpoint = packet.endpointAddress;
        this.context = packet;
        this.reqHeaders = reqHeaders;
    }

    public OutputStream getOutput() {
        try {
            this.httpConnection = this.createHttpConnection();
            this.cookieJar = this.sendCookieAsNeeded();
            if (this.requiresOutputStream()) {
                this.outputStream = this.httpConnection.getOutputStream();
            }
            this.connectForResponse();
        }
        catch (Exception ex) {
            throw new ClientTransportException(ClientMessages.localizableHTTP_CLIENT_FAILED(ex), ex);
        }
        return this.outputStream;
    }

    public void closeOutput() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
            this.outputStream.close();
        }
    }

    public InputStream getInput() {
        InputStream in;
        try {
            in = this.readResponse();
        }
        catch (IOException e) {
            if (this.statusCode == 204 || this.isFailure && this.statusCode != 500) {
                try {
                    throw new ClientTransportException(ClientMessages.localizableHTTP_STATUS_CODE(this.statusCode, this.httpConnection.getResponseMessage()));
                }
                catch (IOException ex) {
                    throw new ClientTransportException(ClientMessages.localizableHTTP_STATUS_CODE(this.statusCode, ex));
                }
            }
            throw new ClientTransportException(ClientMessages.localizableHTTP_CLIENT_FAILED(e), e);
        }
        this.httpConnection = null;
        return in;
    }

    public Map<String, List<String>> getHeaders() {
        if (this.respHeaders != null) {
            return this.respHeaders;
        }
        this.isFailure = this.checkResponseCode();
        this.respHeaders = this.collectResponseMimeHeaders();
        this.saveCookieAsNeeded(this.cookieJar);
        return this.respHeaders;
    }

    protected InputStream readResponse() throws IOException {
        InputStream contentIn = this.isFailure ? this.httpConnection.getErrorStream() : this.httpConnection.getInputStream();
        ByteArrayBuffer bab = new ByteArrayBuffer();
        if (contentIn != null) {
            bab.write(contentIn);
            bab.close();
        }
        int length = this.httpConnection.getContentLength() == -1 ? bab.size() : this.httpConnection.getContentLength();
        return bab.newInputStream(0, length);
    }

    public Map<String, List<String>> collectResponseMimeHeaders() {
        Headers headers = new Headers();
        headers.putAll(this.httpConnection.getHeaderFields());
        return headers;
    }

    protected void connectForResponse() throws IOException {
        this.httpConnection.connect();
    }

    protected boolean checkResponseCode() {
        boolean isFailure = false;
        try {
            this.statusCode = this.httpConnection.getResponseCode();
            if (this.httpConnection.getResponseCode() == 500) {
                isFailure = true;
            } else {
                if (this.httpConnection.getResponseCode() == 401) {
                    throw new ClientTransportException(ClientMessages.localizableHTTP_CLIENT_UNAUTHORIZED(this.httpConnection.getResponseMessage()));
                }
                if (this.httpConnection.getResponseCode() == 404) {
                    throw new ClientTransportException(ClientMessages.localizableHTTP_NOT_FOUND(this.httpConnection.getResponseMessage()));
                }
                if (this.statusCode == 302 || this.statusCode == 301) {
                    isFailure = true;
                    if (!redirect || redirectCount <= 0) {
                        throw new ClientTransportException(ClientMessages.localizableHTTP_STATUS_CODE(this.statusCode, this.getStatusMessage()));
                    }
                } else {
                    if (this.statusCode < 200 || this.statusCode >= 303 && this.statusCode < 500) {
                        throw new ClientTransportException(ClientMessages.localizableHTTP_STATUS_CODE(this.statusCode, this.getStatusMessage()));
                    }
                    if (this.statusCode >= 500) {
                        isFailure = true;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new WebServiceException((Throwable)e);
        }
        return isFailure;
    }

    private String getStatusMessage() throws IOException {
        String location;
        int statusCode = this.httpConnection.getResponseCode();
        String message = this.httpConnection.getResponseMessage();
        if ((statusCode == 201 || statusCode >= 300 && statusCode != 304 && statusCode < 400) && (location = this.httpConnection.getHeaderField("Location")) != null) {
            message = message + " - Location: " + location;
        }
        return message;
    }

    protected CookieJar sendCookieAsNeeded() {
        Boolean shouldMaintainSessionProperty = (Boolean)this.context.invocationProperties.get("javax.xml.ws.session.maintain");
        if (shouldMaintainSessionProperty == null) {
            return null;
        }
        if (shouldMaintainSessionProperty.booleanValue()) {
            CookieJar cookieJar = (CookieJar)this.context.invocationProperties.get("com.sun.xml.ws.client.http.CookieJar");
            if (cookieJar == null) {
                cookieJar = new CookieJar();
                this.context.proxy.getRequestContext().put("com.sun.xml.ws.client.http.CookieJar", cookieJar);
            }
            cookieJar.applyRelevantCookies(this.httpConnection);
            return cookieJar;
        }
        return null;
    }

    protected void saveCookieAsNeeded(CookieJar cookieJar) {
        if (cookieJar != null) {
            cookieJar.recordAnyCookies(this.httpConnection);
        }
    }

    protected HttpURLConnection createHttpConnection() throws IOException {
        String redirectProperty;
        boolean verification = false;
        String verificationProperty = (String)this.context.invocationProperties.get("com.sun.xml.ws.client.http.HostnameVerificationProperty");
        if (verificationProperty != null && verificationProperty.equalsIgnoreCase("true")) {
            verification = true;
        }
        if ((redirectProperty = (String)this.context.invocationProperties.get("com.sun.xml.ws.client.http.RedirectRequestProperty")) != null && redirectProperty.equalsIgnoreCase("false")) {
            redirect = false;
        }
        this.checkEndpoints();
        HttpURLConnection httpConnection = this.createConnection();
        if (httpConnection instanceof HttpsURLConnection) {
            this.https = true;
        }
        if (!verification && httpConnection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)httpConnection).setHostnameVerifier(new HttpClientVerifier());
        }
        this.writeBasicAuthAsNeeded(this.context, this.reqHeaders);
        httpConnection.setAllowUserInteraction(true);
        httpConnection.setDoOutput(true);
        httpConnection.setDoInput(true);
        String method = "POST";
        String requestMethod = (String)this.context.invocationProperties.get("javax.xml.ws.http.request.method");
        method = requestMethod != null ? requestMethod : method;
        httpConnection.setRequestMethod(method);
        Integer reqTimeout = (Integer)this.context.invocationProperties.get("com.sun.xml.ws.request.timeout");
        if (reqTimeout != null) {
            httpConnection.setReadTimeout(reqTimeout);
        }
        for (Map.Entry<String, List<String>> entry : this.reqHeaders.entrySet()) {
            httpConnection.addRequestProperty(entry.getKey(), entry.getValue().get(0));
        }
        return httpConnection;
    }

    public boolean isSecure() {
        return this.https;
    }

    private HttpURLConnection createConnection() throws IOException {
        return (HttpURLConnection)this.endpoint.openConnection();
    }

    private boolean checkForRedirect(int statusCode) {
        return (statusCode == 301 || statusCode == 302) && redirect && redirectCount-- > 0;
    }

    private void checkEndpoints() {
        if (!LAST_ENDPOINT.equalsIgnoreCase(this.endpoint.toString())) {
            redirectCount = 3;
            LAST_ENDPOINT = this.endpoint.toString();
        }
    }

    private void writeBasicAuthAsNeeded(Packet context, Map<String, List<String>> reqHeaders) {
        String pw;
        String user = (String)context.invocationProperties.get("javax.xml.ws.security.auth.username");
        if (user != null && (pw = (String)context.invocationProperties.get("javax.xml.ws.security.auth.password")) != null) {
            StringBuffer buf = new StringBuffer(user);
            buf.append(":");
            buf.append(pw);
            String creds = DatatypeConverter.printBase64Binary((byte[])buf.toString().getBytes());
            reqHeaders.put("Authorization", Collections.singletonList("Basic " + creds));
        }
    }

    private boolean requiresOutputStream() {
        return !this.httpConnection.getRequestMethod().equalsIgnoreCase("GET") && !this.httpConnection.getRequestMethod().equalsIgnoreCase("HEAD") && !this.httpConnection.getRequestMethod().equalsIgnoreCase("DELETE");
    }

    public HttpURLConnection getConnection() {
        return this.httpConnection;
    }

    static {
        try {
            JAXBContext.newInstance((Class[])new Class[0]).createUnmarshaller();
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
        LAST_ENDPOINT = "";
        redirect = true;
        redirectCount = 3;
    }

    static class HttpClientVerifier
    implements HostnameVerifier {
        HttpClientVerifier() {
        }

        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    }
}

