/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.client;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.ContentType;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.transport.http.client.HttpClientTransport;
import com.sun.xml.ws.transport.http.client.HttpResponseProperties;
import com.sun.xml.ws.util.ByteArrayBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpTransportPipe
extends AbstractTubeImpl {
    private final Codec codec;
    public static boolean dump;

    public HttpTransportPipe(Codec codec) {
        this.codec = codec;
    }

    private HttpTransportPipe(HttpTransportPipe that, TubeCloner cloner) {
        this(that.codec.copy());
        cloner.add(that, this);
    }

    @Override
    public NextAction processException(@NotNull Throwable t) {
        throw new IllegalStateException("HttpTransportPipe's processException shouldn't be called.");
    }

    @Override
    public NextAction processRequest(@NotNull Packet request) {
        return this.doReturnWith(this.process(request));
    }

    @Override
    public NextAction processResponse(@NotNull Packet response) {
        throw new IllegalStateException("HttpTransportPipe's processResponse shouldn't be called.");
    }

    @Override
    public Packet process(Packet request) {
        try {
            ByteArrayBuffer buf;
            HashMap<String, List<String>> reqHeaders = (HashMap<String, List<String>>)request.invocationProperties.get("javax.xml.ws.http.request.headers");
            if (reqHeaders == null) {
                reqHeaders = new HashMap<String, List<String>>();
            }
            HttpClientTransport con = new HttpClientTransport(request, reqHeaders);
            request.addSatellite(new HttpResponseProperties(con));
            ContentType ct = this.codec.getStaticContentType(request);
            if (ct == null) {
                buf = new ByteArrayBuffer();
                ct = this.codec.encode(request, buf);
                reqHeaders.put("Content-Length", Collections.singletonList(Integer.toString(buf.size())));
                reqHeaders.put("Content-Type", Collections.singletonList(ct.getContentType()));
                if (ct.getAcceptHeader() != null) {
                    reqHeaders.put("Accept", Collections.singletonList(ct.getAcceptHeader()));
                }
                this.writeSOAPAction(reqHeaders, ct.getSOAPActionHeader(), request);
                if (dump) {
                    this.dump(buf, "HTTP request", reqHeaders);
                }
                buf.writeTo(con.getOutput());
            } else {
                reqHeaders.put("Content-Type", Collections.singletonList(ct.getContentType()));
                if (ct.getAcceptHeader() != null) {
                    reqHeaders.put("Accept", Collections.singletonList(ct.getAcceptHeader()));
                }
                this.writeSOAPAction(reqHeaders, ct.getSOAPActionHeader(), request);
                if (dump) {
                    buf = new ByteArrayBuffer();
                    this.codec.encode(request, buf);
                    this.dump(buf, "HTTP request", reqHeaders);
                    OutputStream out = con.getOutput();
                    if (out != null) {
                        buf.writeTo(out);
                    }
                } else {
                    this.codec.encode(request, con.getOutput());
                }
            }
            con.closeOutput();
            Map<String, List<String>> respHeaders = con.getHeaders();
            if (con.statusCode == 202) {
                return request.createClientResponse(null);
            }
            String contentType = this.getContentType(respHeaders);
            Packet reply = request.createClientResponse(null);
            reply.wasTransportSecure = con.isSecure();
            InputStream response = con.getInput();
            if (dump) {
                ByteArrayBuffer buf2 = new ByteArrayBuffer();
                buf2.write(response);
                this.dump(buf2, "HTTP response " + con.statusCode, respHeaders);
                response = buf2.newInputStream();
            }
            this.codec.decode(response, contentType, reply);
            return reply;
        }
        catch (WebServiceException wex) {
            throw wex;
        }
        catch (Exception ex) {
            throw new WebServiceException((Throwable)ex);
        }
    }

    private void writeSOAPAction(Map<String, List<String>> reqHeaders, String soapAction, Packet packet) {
        boolean use;
        Boolean useAction = (Boolean)packet.invocationProperties.get("javax.xml.ws.soap.http.soapaction.use");
        String sAction = null;
        boolean bl = use = useAction != null ? useAction : false;
        if (use) {
            sAction = packet.soapAction;
        }
        if (sAction != null) {
            reqHeaders.put("SOAPAction", Collections.singletonList(sAction));
        } else if (soapAction != null) {
            reqHeaders.put("SOAPAction", Collections.singletonList(soapAction));
        }
    }

    private String getContentType(Map<String, List<String>> headers) {
        List<String> keys = headers.get("Content-type");
        if (keys == null) {
            throw new WebServiceException("No Content-type in the header!");
        }
        return keys.get(0);
    }

    @Override
    public void preDestroy() {
    }

    @Override
    public HttpTransportPipe copy(TubeCloner cloner) {
        return new HttpTransportPipe(this, cloner);
    }

    private void dump(ByteArrayBuffer buf, String caption, Map<String, List<String>> headers) throws IOException {
        System.out.println("---[" + caption + "]---");
        for (Map.Entry<String, List<String>> header : headers.entrySet()) {
            if (header.getValue().isEmpty()) {
                System.out.println(header.getValue());
                continue;
            }
            for (String value : header.getValue()) {
                System.out.println(header.getKey() + ": " + value);
            }
        }
        buf.writeTo(System.out);
        System.out.println("--------------------");
    }

    static {
        boolean b;
        try {
            b = Boolean.getBoolean(HttpTransportPipe.class.getName() + ".dump");
        }
        catch (Throwable t) {
            b = false;
        }
        dump = b;
    }
}

