/*
 * Copyright (c) 1997, 2022 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package com.sun.xml.ws.spi.db;

import jakarta.xml.ws.WebServiceException;

/**
 * This is the Gtter of a bean property. 
 * 
 * @author shih-chang.chen@oracle.com
 * @exclude
 */
public abstract class PropertyGetterBase implements PropertyGetter {
    protected Class type;

    /**
     * Default constructor.
     */
    protected PropertyGetterBase() {}

    @Override
    public Class getType() {
        return type;
    }
    
    static public boolean getterPattern(java.lang.reflect.Method method) {
        if (!method.getReturnType().equals(void.class) &&
            (method.getParameterTypes() == null ||
             method.getParameterTypes().length == 0)) {
            if (method.getName().startsWith("get") &&
                method.getName().length() > 3) {
                return true;
            } else {
                return (method.getReturnType().equals(boolean.class) || method.getReturnType().equals(Boolean.class)) &&
                        method.getName().startsWith("is") &&
                        method.getName().length() > 2;
            }
        } 
        return false;
    }
    
    static void verifyWrapperType(Class wrapperType) {
        String className = wrapperType.getName();
        if (className.startsWith("java.") || className.startsWith("javax.")) {
            throw new WebServiceException("Invalid wrapper type " + className);
        }
    }
}
