/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files.apple;

import com.swoval.concurrent.ThreadFactory;
import com.swoval.files.LinkOption;
import com.swoval.files.Registerable;
import com.swoval.files.apple.FileEvent;
import com.swoval.files.apple.FileEventsApi;
import com.swoval.files.apple.Flags;
import com.swoval.functional.Consumer;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class MacOSXWatchService
implements WatchService,
AutoCloseable,
Registerable {
    private final double watchLatency;
    private final int queueSize;
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final LinkedBlockingQueue<MacOSXWatchKey> readyKeys = new LinkedBlockingQueue();
    private final Map<Path, MacOSXWatchKey> registered = new HashMap<Path, MacOSXWatchKey>();
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory("com.swoval.files.apple.MacOSXWatchService-executor-thread"));
    private final Set<Path> streams = new HashSet<Path>();
    private final Consumer<String> dropEvent = new Consumer<String>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(String string) {
            Map map = MacOSXWatchService.this.registered;
            synchronized (map) {
                Path path = Paths.get(string, new String[0]);
                MacOSXWatchService.this.streams.remove(path);
                MacOSXWatchKey macOSXWatchKey = (MacOSXWatchKey)MacOSXWatchService.this.registered.get(path);
                if (macOSXWatchKey != null) {
                    macOSXWatchKey.setStreamId(-1);
                }
            }
        }
    };
    private final Consumer<FileEvent> onFileEvent = new Consumer<FileEvent>(){

        @Override
        public void accept(final FileEvent fileEvent) {
            MacOSXWatchService.this.executor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Path path = Paths.get(fileEvent.fileName, new String[0]);
                    Map map = MacOSXWatchService.this.registered;
                    synchronized (map) {
                        MacOSXWatchKey macOSXWatchKey = (MacOSXWatchKey)MacOSXWatchService.this.registered.get(path);
                        MacOSXWatchKey macOSXWatchKey2 = macOSXWatchKey == null ? (MacOSXWatchKey)MacOSXWatchService.this.registered.get(path.getParent()) : macOSXWatchKey;
                        boolean bl = Files.exists(path, new java.nio.file.LinkOption[]{LinkOption.NOFOLLOW_LINKS});
                        if (macOSXWatchKey2 != null) {
                            if (bl && macOSXWatchKey2.reportModifyEvents()) {
                                MacOSXWatchService.this.createEvent(macOSXWatchKey2, StandardWatchEventKinds.ENTRY_MODIFY, path);
                            } else if (!bl && macOSXWatchKey2.reportDeleteEvents()) {
                                MacOSXWatchService.this.createEvent(macOSXWatchKey2, StandardWatchEventKinds.ENTRY_DELETE, path);
                            }
                        }
                    }
                }
            });
        }
    };
    private final FileEventsApi watcher = FileEventsApi.apply(this.onFileEvent, this.dropEvent);

    public MacOSXWatchService(double d, int n) throws InterruptedException {
        this.watchLatency = d;
        this.queueSize = n;
    }

    public MacOSXWatchService() throws InterruptedException {
        this(0.01, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        FileEventsApi fileEventsApi = this.watcher;
        synchronized (fileEventsApi) {
            if (this.open.compareAndSet(true, false)) {
                this.watcher.close();
                this.executor.shutdownNow();
                Iterator<Path> iterator = new ArrayList<Path>(this.registered.keySet()).iterator();
                while (iterator.hasNext()) {
                    this.unregisterImpl(iterator.next());
                }
                this.registered.clear();
                try {
                    this.executor.awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public WatchKey poll() {
        if (this.isOpen()) {
            return this.readyKeys.poll();
        }
        throw new ClosedWatchServiceException();
    }

    @Override
    public WatchKey poll(long l, TimeUnit timeUnit) throws InterruptedException {
        if (this.isOpen()) {
            return this.readyKeys.poll(l, timeUnit);
        }
        throw new ClosedWatchServiceException();
    }

    @Override
    public WatchKey take() throws InterruptedException {
        if (this.isOpen()) {
            return this.readyKeys.take();
        }
        throw new ClosedWatchServiceException();
    }

    private void createEvent(MacOSXWatchKey macOSXWatchKey, WatchEvent.Kind<Path> kind, Path path) {
        Event<Path> event = new Event<Path>(kind, 1, macOSXWatchKey.watchable.relativize(path));
        macOSXWatchKey.addEvent(event);
        if (!this.readyKeys.contains(macOSXWatchKey)) {
            this.readyKeys.offer(macOSXWatchKey);
        }
    }

    private boolean isOpen() {
        return this.open.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WatchKey register(Path path, WatchEvent.Kind<?> ... kindArray) throws IOException {
        FileEventsApi fileEventsApi = this.watcher;
        synchronized (fileEventsApi) {
            if (this.isOpen()) {
                Map<Path, MacOSXWatchKey> map = this.registered;
                synchronized (map) {
                    MacOSXWatchKey macOSXWatchKey;
                    Path path2 = path.toRealPath(new java.nio.file.LinkOption[0]);
                    MacOSXWatchKey macOSXWatchKey2 = this.registered.get(path2);
                    if (macOSXWatchKey2 == null) {
                        int n = new Flags.Create().setNoDefer().setFileEvents().getValue();
                        int n2 = -2;
                        Iterator<Path> iterator = this.streams.iterator();
                        while (iterator.hasNext() && n2 != -1) {
                            if (!path2.startsWith(iterator.next())) continue;
                            n2 = -1;
                        }
                        if (n2 != -1) {
                            this.streams.add(path2);
                            try {
                                n2 = this.watcher.createStream(path2.toString(), this.watchLatency, n);
                            }
                            catch (FileEventsApi.ClosedFileEventsApiException closedFileEventsApiException) {
                                this.close();
                                throw closedFileEventsApiException;
                            }
                        }
                        macOSXWatchKey = new MacOSXWatchKey(this, path2, this.queueSize, n2, kindArray);
                        this.registered.put(path2, macOSXWatchKey);
                    } else {
                        macOSXWatchKey = macOSXWatchKey2;
                    }
                    return macOSXWatchKey;
                }
            }
            throw new ClosedWatchServiceException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterImpl(Path path) {
        Map<Path, MacOSXWatchKey> map = this.registered;
        synchronized (map) {
            MacOSXWatchKey macOSXWatchKey = this.registered.get(path);
            if (macOSXWatchKey != null) {
                this.registered.remove(path);
                macOSXWatchKey.setStreamId(-1);
                if (macOSXWatchKey.getStreamId() != -1) {
                    this.watcher.stopStream(macOSXWatchKey.getStreamId());
                }
            }
        }
    }

    public void unregister(Path path) {
        if (!this.isOpen()) {
            throw new ClosedWatchServiceException();
        }
        this.unregisterImpl(path);
    }

    private static class Event<T>
    implements WatchEvent<T> {
        private final WatchEvent.Kind<T> _kind;
        private final int _count;
        private final T _context;

        Event(WatchEvent.Kind<T> kind, int n, T t) {
            this._kind = kind;
            this._count = n;
            this._context = t;
        }

        @Override
        public WatchEvent.Kind<T> kind() {
            return this._kind;
        }

        @Override
        public int count() {
            return this._count;
        }

        @Override
        public T context() {
            return this._context;
        }

        public String toString() {
            return "Event(" + this._context + ", " + this._kind + ")";
        }
    }

    private static class MacOSXWatchKey
    implements WatchKey {
        private final ArrayBlockingQueue<WatchEvent<?>> events;
        private final AtomicInteger overflow = new AtomicInteger(0);
        private final AtomicBoolean valid = new AtomicBoolean(true);
        private final MacOSXWatchService service;
        private int streamId;
        private final boolean reportCreateEvents;
        private final boolean reportModifyEvents;
        private final boolean reportDeleteEvents;
        private final Path watchable;

        public int getStreamId() {
            return this.streamId;
        }

        public void setStreamId(int n) {
            this.streamId = n;
        }

        public boolean reportCreateEvents() {
            return this.reportCreateEvents;
        }

        public boolean reportModifyEvents() {
            return this.reportModifyEvents;
        }

        public boolean reportDeleteEvents() {
            return this.reportDeleteEvents;
        }

        MacOSXWatchKey(MacOSXWatchService macOSXWatchService, Path path, int n, int n2, WatchEvent.Kind<?> ... kindArray) {
            this.service = macOSXWatchService;
            this.events = new ArrayBlockingQueue(n);
            this.streamId = n2;
            this.watchable = path;
            HashSet hashSet = new HashSet();
            for (int i = 0; i < kindArray.length; ++i) {
                hashSet.add(kindArray[i]);
            }
            this.reportCreateEvents = hashSet.contains(StandardWatchEventKinds.ENTRY_CREATE);
            this.reportModifyEvents = hashSet.contains(StandardWatchEventKinds.ENTRY_MODIFY);
            this.reportDeleteEvents = hashSet.contains(StandardWatchEventKinds.ENTRY_DELETE);
        }

        @Override
        public void cancel() {
            try {
                this.service.unregister(this.watchable);
            }
            catch (ClosedWatchServiceException closedWatchServiceException) {
                // empty catch block
            }
            this.valid.set(false);
        }

        @Override
        public Watchable watchable() {
            return this.watchable;
        }

        @Override
        public boolean isValid() {
            return this.valid.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<WatchEvent<?>> pollEvents() {
            MacOSXWatchKey macOSXWatchKey = this;
            synchronized (macOSXWatchKey) {
                int n = this.overflow.getAndSet(0);
                ArrayList<Event<Path>> arrayList = new ArrayList<Event<Path>>(this.events.size() + n > 0 ? 1 : 0);
                this.events.drainTo(arrayList);
                if (n != 0) {
                    arrayList.add(new Event<Path>(StandardWatchEventKinds.OVERFLOW, n, this.watchable));
                }
                return Collections.unmodifiableList(arrayList);
            }
        }

        @Override
        public boolean reset() {
            return true;
        }

        public String toString() {
            return "MacOSXWatchKey(" + this.watchable + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addEvent(Event<Path> event) {
            MacOSXWatchKey macOSXWatchKey = this;
            synchronized (macOSXWatchKey) {
                if (!this.events.offer(event)) {
                    this.overflow.incrementAndGet();
                }
            }
        }
    }
}

