/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.jobrestrictions.jobs;

import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.Messages;
import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.jobs.JobRestrictionPropertyConfig;
import hudson.AbortException;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

public class JobRestrictionProperty
extends JobProperty {
    JobRestrictionPropertyConfig config;

    @DataBoundConstructor
    public JobRestrictionProperty(JobRestrictionPropertyConfig config) {
        this.config = config;
    }

    public JobRestrictionPropertyConfig getConfig() {
        return this.config;
    }

    public boolean prebuild(AbstractBuild build, BuildListener listener) {
        for (Object cause : build.getCauses()) {
            try {
                this.validateCause((Cause)cause, listener);
            }
            catch (AbortException ex) {
                listener.fatalError("[Job Restrictions] - Build will be aborted: " + ex.getMessage());
                return false;
            }
        }
        return true;
    }

    private void validateCause(Cause cause, BuildListener listener) throws AbortException {
        if (this.config != null) {
            this.config.validateCause(cause, listener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public String getDisplayName() {
            return Messages.jobs_JobRestrictionProperty_DisplayName();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return true;
        }
    }
}

