/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership;

import com.synopsys.arc.jenkins.plugins.ownership.util.AbstractOwnershipHelper;
import com.synopsys.arc.jenkins.plugins.ownership.util.IdStrategyComparator;
import com.synopsys.arc.jenkins.plugins.ownership.util.OwnershipDescriptionHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.ModelObject;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.ownership.model.OwnershipHelperLocator;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class OwnershipDescription
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(OwnershipDescription.class.getName());
    public static final OwnershipDescription DISABLED_DESCR = new OwnershipDescription(false, "");
    @Whitelisted
    boolean ownershipEnabled;
    String primaryOwnerId;
    @Whitelisted
    Set<String> coownersIds;

    @Deprecated
    public OwnershipDescription(boolean ownershipEnabled, @Nonnull String primaryOwnerId) {
        this(ownershipEnabled, primaryOwnerId, null);
    }

    public OwnershipDescription(boolean ownershipEnabled, @Nullable String primaryOwnerId, @Nullable Collection<String> secondaryOwnerIds) {
        this.ownershipEnabled = ownershipEnabled;
        this.primaryOwnerId = primaryOwnerId;
        this.coownersIds = secondaryOwnerIds != null ? new TreeSet<String>(secondaryOwnerIds) : new TreeSet();
    }

    public void assign(@Nonnull OwnershipDescription descr) {
        this.ownershipEnabled = descr.ownershipEnabled;
        this.primaryOwnerId = descr.primaryOwnerId;
        this.coownersIds = descr.coownersIds;
    }

    public String toString() {
        if (!this.ownershipEnabled) {
            return "ownership:disabled";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("primary owner=");
        builder.append(this.primaryOwnerId);
        if (!this.coownersIds.isEmpty()) {
            builder.append(" secondary owners:[");
            for (String coownerId : this.coownersIds) {
                builder.append(coownerId);
                builder.append(' ');
            }
            builder.append(']');
        }
        return builder.toString();
    }

    @Whitelisted
    public boolean isOwnershipEnabled() {
        return this.ownershipEnabled;
    }

    @Whitelisted
    @Nonnull
    public String getPrimaryOwnerId() {
        return this.ownershipEnabled ? this.primaryOwnerId : User.getUnknown().getId();
    }

    @CheckForNull
    public User getPrimaryOwner() {
        return this.ownershipEnabled ? User.getById((String)this.primaryOwnerId, (boolean)false) : null;
    }

    @Nonnull
    @Deprecated
    public Set<String> getCoownersIds() {
        return this.getSecondaryOwnerIds();
    }

    @Nonnull
    @Whitelisted
    public Set<String> getSecondaryOwnerIds() {
        return this.coownersIds;
    }

    @Nonnull
    @Deprecated
    @SuppressFBWarnings(value={"NM_METHOD_NAMING_CONVENTION"}, justification="deprecated")
    public static OwnershipDescription Parse(JSONObject formData) throws Descriptor.FormException {
        return OwnershipDescription.parseJSON(formData);
    }

    @Nonnull
    public static OwnershipDescription parseJSON(JSONObject formData) throws Descriptor.FormException {
        String primaryOwnerId = formData.getString("primaryOwner");
        TreeSet<String> secondaryOwnerIds = new TreeSet<String>();
        if (formData.has("coOwners")) {
            JSONObject coOwners = formData.optJSONObject("coOwners");
            if (coOwners == null) {
                for (Object obj : formData.getJSONArray("coOwners")) {
                    OwnershipDescription.addUser(secondaryOwnerIds, (JSONObject)obj);
                }
            } else {
                OwnershipDescription.addUser(secondaryOwnerIds, coOwners);
            }
        }
        return new OwnershipDescription(true, primaryOwnerId, secondaryOwnerIds);
    }

    private static void addUser(Set<String> target, JSONObject userObj) throws Descriptor.FormException {
        String userId = Util.fixEmptyAndTrim((String)userObj.getString("coOwner"));
        if (userId != null) {
            target.add(userId);
        }
    }

    public boolean isOwner(User user, boolean includeSecondaryOwners) {
        if (user == null) {
            return false;
        }
        if (this.isPrimaryOwner(user)) {
            return true;
        }
        if (includeSecondaryOwners) {
            TreeSet<String> coowners = new TreeSet<String>(new IdStrategyComparator());
            coowners.addAll(this.coownersIds);
            return coowners.contains(user.getId());
        }
        return false;
    }

    @Whitelisted
    public boolean hasPrimaryOwner() {
        return this.ownershipEnabled && this.getPrimaryOwner() != null;
    }

    public boolean isPrimaryOwner(@CheckForNull User user) {
        return user != null && user == this.getPrimaryOwner();
    }

    @Deprecated
    @Nonnull
    public String getOwnerId() {
        return this.getPrimaryOwnerId();
    }

    @Nonnull
    @Deprecated
    public String getOwnerEmail() {
        return this.getPrimaryOwnerEmail();
    }

    @Nonnull
    @Whitelisted
    public String getPrimaryOwnerEmail() {
        return OwnershipDescriptionHelper.getOwnerEmail(this);
    }

    @Deprecated
    @Nonnull
    public Set<String> getCoOwnerIds() {
        return this.coownersIds;
    }

    @Deprecated
    @Nonnull
    public Set<String> getCoOwnerEmails() {
        return OwnershipDescriptionHelper.getSecondaryOwnerEmails(this, false);
    }

    @Whitelisted
    @Nonnull
    public Set<String> getSecondaryOwnerEmails() {
        return OwnershipDescriptionHelper.getSecondaryOwnerEmails(this, false);
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + (this.ownershipEnabled ? 1 : 0);
        hash = 41 * hash + (this.primaryOwnerId != null ? this.primaryOwnerId.hashCode() : 0);
        hash = 41 * hash + (this.coownersIds != null ? this.coownersIds.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OwnershipDescription other = (OwnershipDescription)obj;
        if (this.ownershipEnabled != other.ownershipEnabled) {
            return false;
        }
        if (!this.ownershipEnabled) {
            return true;
        }
        if (this.primaryOwnerId == null ? other.primaryOwnerId != null : !this.primaryOwnerId.equals(other.primaryOwnerId)) {
            return false;
        }
        return this.coownersIds == other.coownersIds || this.coownersIds != null && this.coownersIds.equals(other.coownersIds);
    }

    protected Object readResolve() throws ObjectStreamException {
        this.checkUnsecuredConfiguration();
        return this;
    }

    private void checkUnsecuredConfiguration() throws ObjectStreamException {
        Authentication authentication = Jenkins.getAuthentication();
        if (authentication == ACL.SYSTEM) {
            return;
        }
        StaplerRequest request = Stapler.getCurrentRequest();
        if (request != null) {
            AccessControlled context = (AccessControlled)request.findAncestorObject(AccessControlled.class);
            if (context != null) {
                AbstractOwnershipHelper<AccessControlled> helper = OwnershipHelperLocator.locate(context);
                if (helper != null) {
                    OwnershipDescription d = helper.getOwnershipDescription(context);
                    if (!helper.hasLocallyDefinedOwnership(context) || !Objects.equals(d, this)) {
                        this.throwIfMissingPermission(context, helper.getRequiredPermission());
                    }
                    return;
                }
                LOGGER.log(Level.WARNING, "Cannot locate OwnershipHelperClass for object {0}. Jenkins.ADMINISTER permissions will be required to change ownership", context);
            } else {
                LOGGER.log(Level.WARNING, "Ownership Description is used outside the object context. Jenkins.ADMINISTER permissions will be required to change ownership");
            }
        }
        this.throwIfMissingPermission((AccessControlled)Jenkins.getActiveInstance(), Jenkins.ADMINISTER);
    }

    private void throwIfMissingPermission(@Nonnull AccessControlled context, Permission permission) throws ObjectStreamException {
        try {
            context.checkPermission(permission);
        }
        catch (AccessDeniedException e) {
            String name = context instanceof ModelObject ? ((ModelObject)context).getDisplayName() : context.toString();
            InvalidObjectException ex = new InvalidObjectException(String.format("Cannot modify permissions of %s of type %s: %s", name, context.getClass(), e.getMessage()));
            ex.addSuppressed(e);
            throw ex;
        }
    }

    public static boolean isEnabled(OwnershipDescription descr) {
        return descr != null && descr.ownershipEnabled;
    }
}

