/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership;

import com.synopsys.arc.jenkins.plugins.ownership.Messages;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipAction;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipPluginConfiguration;
import com.synopsys.arc.jenkins.plugins.ownership.extensions.ItemOwnershipPolicy;
import com.synopsys.arc.jenkins.plugins.ownership.extensions.OwnershipLayoutFormatterProvider;
import com.synopsys.arc.jenkins.plugins.ownership.extensions.item_ownership_policy.AssignCreatorPolicy;
import com.synopsys.arc.jenkins.plugins.ownership.extensions.item_ownership_policy.DropOwnershipPolicy;
import com.synopsys.arc.jenkins.plugins.ownership.security.itemspecific.ItemSpecificSecurity;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionList;
import hudson.Plugin;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import hudson.tasks.MailAddressResolver;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class OwnershipPlugin
extends Plugin {
    public static final String LOG_PREFIX = "[OwnershipPlugin] - ";
    private static final Logger LOGGER = Logger.getLogger(OwnershipPlugin.class.getName());
    public static final String FAST_RESOLVER_ID = "Fast resolver for UI (recommended)";
    private static final PermissionGroup PERMISSIONS = new PermissionGroup(OwnershipPlugin.class, Messages._OwnershipPlugin_ManagePermissions_Title());
    public static final Permission MANAGE_ITEMS_OWNERSHIP = new Permission(PERMISSIONS, "Jobs", Messages._OwnershipPlugin_ManagePermissions_JobDescription(), Permission.CONFIGURE, PermissionScope.ITEM);
    public static final Permission MANAGE_SLAVES_OWNERSHIP = new Permission(PERMISSIONS, "Nodes", Messages._OwnershipPlugin_ManagePermissions_SlaveDescription(), Permission.CONFIGURE, PermissionScope.COMPUTER);
    private boolean requiresConfigureRights;
    @Deprecated
    private transient boolean assignOnCreate;
    private final List<OwnershipAction> pluginActions = new ArrayList<OwnershipAction>();
    public String mailResolverClassName;
    private ItemSpecificSecurity defaultJobsSecurity;
    private OwnershipPluginConfiguration configuration;

    @Deprecated
    @SuppressFBWarnings(value={"NM_METHOD_NAMING_CONVENTION"}, justification="deprecated")
    public static OwnershipPlugin Instance() {
        return OwnershipPlugin.getInstance();
    }

    public static OwnershipPlugin getInstance() {
        OwnershipPlugin plugin;
        Jenkins j = Jenkins.getInstance();
        OwnershipPlugin ownershipPlugin = plugin = j != null ? (OwnershipPlugin)j.getPlugin(OwnershipPlugin.class) : null;
        if (plugin == null) {
            throw new IllegalStateException("Cannot get the plugin's instance. Jenkins or the plugin have not been initialized yet");
        }
        return plugin;
    }

    public void start() throws Exception {
        this.load();
        this.reinitActionsList();
        Jenkins.getActiveInstance().getActions().addAll(this.pluginActions);
    }

    protected void load() throws IOException {
        super.load();
        if (this.configuration == null) {
            ItemOwnershipPolicy itemOwnershipPolicy = this.assignOnCreate ? new AssignCreatorPolicy() : new DropOwnershipPolicy();
            this.configuration = new OwnershipPluginConfiguration(itemOwnershipPolicy);
            this.save();
        }
    }

    public boolean isRequiresConfigureRights() {
        return this.requiresConfigureRights;
    }

    @Deprecated
    public boolean isAssignOnCreate() {
        return this.getConfiguration().getItemOwnershipPolicy() instanceof AssignCreatorPolicy;
    }

    @CheckForNull
    public ItemSpecificSecurity getDefaultJobsSecurity() {
        return this.defaultJobsSecurity;
    }

    public OwnershipPluginConfiguration getConfiguration() {
        return this.configuration;
    }

    @Nonnull
    public ItemSpecificSecurity.ItemSpecificDescriptor getItemSpecificDescriptor() {
        return ItemSpecificSecurity.DESCRIPTOR;
    }

    public void configure(boolean requiresConfigureRights, String mailResolverClassName, ItemSpecificSecurity defaultJobsSecurity, OwnershipPluginConfiguration configuration) throws IOException {
        this.requiresConfigureRights = requiresConfigureRights;
        this.mailResolverClassName = mailResolverClassName;
        this.defaultJobsSecurity = defaultJobsSecurity;
        this.configuration = configuration;
        this.reinitActionsList();
        this.save();
        Jenkins.getActiveInstance().getActions().addAll(this.pluginActions);
    }

    public void configure(StaplerRequest req, JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
        Jenkins.getActiveInstance().getActions().removeAll(this.pluginActions);
        this.requiresConfigureRights = formData.getBoolean("requiresConfigureRights");
        this.configuration = (OwnershipPluginConfiguration)req.bindJSON(OwnershipPluginConfiguration.class, formData);
        if (formData.containsKey((Object)"enableResolverRestrictions")) {
            JSONObject mailResolversConf = formData.getJSONObject("enableResolverRestrictions");
            this.mailResolverClassName = Util.fixEmptyAndTrim((String)mailResolversConf.getString("mailResolverClassName"));
        } else {
            this.mailResolverClassName = null;
        }
        if (formData.containsKey((Object)"defaultJobsSecurity")) {
            this.defaultJobsSecurity = this.getItemSpecificDescriptor().newInstance(req, formData.getJSONObject("defaultJobsSecurity"));
        }
        this.reinitActionsList();
        this.save();
        Jenkins.getActiveInstance().getActions().addAll(this.pluginActions);
    }

    private void reinitActionsList() {
        this.pluginActions.clear();
    }

    @Nonnull
    public static String getDefaultOwner() {
        User current = User.current();
        return current != null ? current.getId() : "";
    }

    public boolean hasMailResolverRestriction() {
        return this.mailResolverClassName != null;
    }

    @CheckForNull
    public String getMailResolverClassName() {
        return this.mailResolverClassName;
    }

    @Nonnull
    public OwnershipLayoutFormatterProvider getOwnershipLayoutFormatterProvider() {
        return OwnershipLayoutFormatterProvider.DEFAULT_PROVIDER;
    }

    public FormValidation doCheckUser(@QueryParameter String userId) {
        if ((userId = Util.fixEmptyAndTrim((String)userId)) == null) {
            return FormValidation.error((String)"Field is empty. Field will be ignored");
        }
        User usr = User.getById((String)userId, (boolean)false);
        if (usr == null) {
            return FormValidation.warning((String)("User " + userId + " is not registered in Jenkins"));
        }
        return FormValidation.ok();
    }

    @CheckForNull
    public String resolveEmail(User user) {
        try {
            if (this.hasMailResolverRestriction()) {
                if (this.mailResolverClassName.equals(FAST_RESOLVER_ID)) {
                    return MailAddressResolver.resolveFast((User)user);
                }
                Class<?> resolverClass = Class.forName(this.mailResolverClassName);
                MailAddressResolver res = (MailAddressResolver)MailAddressResolver.all().get(resolverClass);
                if (res != null) {
                    return res.findMailAddressFor(user);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return MailAddressResolver.resolve((User)user);
    }

    @Nonnull
    public Collection<String> getPossibleMailResolvers() {
        ExtensionList extensions = MailAddressResolver.all();
        ArrayList<String> items = new ArrayList<String>(extensions.size());
        items.add(FAST_RESOLVER_ID);
        for (MailAddressResolver resolver : extensions) {
            items.add(resolver.getClass().getCanonicalName());
        }
        return items;
    }

    public static Logger getLogger() {
        return LOGGER;
    }
}

