/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.jobs;

import com.synopsys.arc.jenkins.plugins.ownership.Messages;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.util.AbstractOwnershipHelper;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.User;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.ownership.model.OwnershipHelperLocator;
import org.kohsuke.stapler.DataBoundConstructor;

public class JobOwnerColumn
extends ListViewColumn {
    @DataBoundConstructor
    public JobOwnerColumn() {
    }

    @Nonnull
    public String getJobOwner(Item item) {
        OwnershipDescription description = this.getDescription(item);
        return description != null ? description.getPrimaryOwnerId() : User.getUnknown().getId();
    }

    public boolean isOwnerExists(Item item) {
        OwnershipDescription description = this.getDescription(item);
        return description != null ? description.hasPrimaryOwner() : false;
    }

    @CheckForNull
    private OwnershipDescription getDescription(Item item) {
        AbstractOwnershipHelper<Item> helper = OwnershipHelperLocator.locate(item);
        if (helper == null) {
            return null;
        }
        return helper.getOwnershipDescription(item);
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public boolean shownByDefault() {
            return false;
        }

        public String getDisplayName() {
            return Messages.JobOwnership_Column_Title();
        }
    }
}

