/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.jobs;

import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipPlugin;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipPluginConfiguration;
import com.synopsys.arc.jenkins.plugins.ownership.jobs.JobOwnerJobProperty;
import com.synopsys.arc.jenkins.plugins.ownership.security.itemspecific.ItemSpecificSecurity;
import com.synopsys.arc.jenkins.plugins.ownership.util.AbstractOwnershipHelper;
import com.synopsys.arc.jenkins.plugins.ownership.util.UserCollectionFilter;
import com.synopsys.arc.jenkins.plugins.ownership.util.userFilters.AccessRightsFilter;
import hudson.Extension;
import hudson.matrix.MatrixConfiguration;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.User;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.ownership.model.OwnershipHelperLocator;
import org.jenkinsci.plugins.ownership.model.OwnershipInfo;
import org.jenkinsci.plugins.ownership.model.jobs.JobOwnershipDescriptionSource;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class JobOwnerHelper
extends AbstractOwnershipHelper<Job<?, ?>> {
    public static final JobOwnerHelper Instance = new JobOwnerHelper();

    @CheckForNull
    public static JobOwnerJobProperty getOwnerProperty(@Nonnull Job<?, ?> job) {
        JobProperty prop = job.getProperty(JobOwnerJobProperty.class);
        if (prop != null) {
            return (JobOwnerJobProperty)prop;
        }
        if (job instanceof MatrixConfiguration) {
            return JobOwnerHelper.getOwnerProperty(((MatrixConfiguration)job).getParent());
        }
        return null;
    }

    public static boolean isUserExists(@Nonnull User user) {
        assert (user != null);
        return JobOwnerHelper.isUserExists(user.getId());
    }

    public static boolean isUserExists(@Nonnull String userIdOrFullName) {
        return User.getById((String)userIdOrFullName, (boolean)false) != null;
    }

    @Override
    @Nonnull
    public OwnershipDescription getOwnershipDescription(@Nonnull Job<?, ?> job) {
        return this.getOwnershipInfo(job).getDescription();
    }

    @Override
    public Permission getRequiredPermission() {
        return OwnershipPlugin.MANAGE_ITEMS_OWNERSHIP;
    }

    @Override
    public boolean hasLocallyDefinedOwnership(@Nonnull Job<?, ?> job) {
        return JobOwnerHelper.getOwnerProperty(job) != null;
    }

    @Override
    public OwnershipInfo getOwnershipInfo(Job<?, ?> job) {
        OwnershipDescription d;
        JobOwnerJobProperty prop = JobOwnerHelper.getOwnerProperty(job);
        if (prop != null && (d = prop.getOwnership()).isOwnershipEnabled()) {
            return new OwnershipInfo(d, new JobOwnershipDescriptionSource(job));
        }
        if (!OwnershipPluginConfiguration.get().getInheritanceOptions().isBlockInheritanceFromItemGroups()) {
            ItemGroup parent = job.getParent();
            AbstractOwnershipHelper<ItemGroup> located = OwnershipHelperLocator.locate(parent);
            while (located != null) {
                OwnershipInfo fromParent = located.getOwnershipInfo(parent);
                if (fromParent.getDescription().isOwnershipEnabled()) {
                    return fromParent;
                }
                if (parent instanceof Item) {
                    Item parentItem = (Item)parent;
                    parent = parentItem.getParent();
                    located = OwnershipHelperLocator.locate(parent);
                    continue;
                }
                located = null;
            }
        }
        return OwnershipInfo.DISABLED_INFO;
    }

    public static void setOwnership(@Nonnull Job<?, ?> job, @CheckForNull OwnershipDescription descr) throws IOException {
        JobOwnerJobProperty prop = JobOwnerHelper.getOwnerProperty(job);
        if (prop == null) {
            prop = new JobOwnerJobProperty(descr, null);
            job.addProperty((JobProperty)prop);
        } else {
            prop.setOwnershipDescription(descr);
        }
    }

    public static void setProjectSpecificSecurity(@Nonnull Job<?, ?> job, @CheckForNull ItemSpecificSecurity security) throws IOException {
        JobOwnerJobProperty prop = JobOwnerHelper.getOwnerProperty(job);
        if (prop == null) {
            throw new IOException("Ownership is not configured for " + job);
        }
        prop.setItemSpecificSecurity(security);
    }

    @Override
    @Nonnull
    public Collection<User> getPossibleOwners(@Nonnull Job<?, ?> item) {
        if (OwnershipPlugin.getInstance().isRequiresConfigureRights()) {
            AccessRightsFilter filter = new AccessRightsFilter((AccessControlled)item, Job.CONFIGURE);
            return UserCollectionFilter.filterUsers(User.getAll(), true, filter);
        }
        return User.getAll();
    }

    @Override
    public String getItemTypeName(Job<?, ?> item) {
        return "job";
    }

    @Override
    public String getItemDisplayName(Job<?, ?> item) {
        return item.getFullDisplayName();
    }

    @Override
    public String getItemURL(Job<?, ?> item) {
        return item.getUrl();
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static class LocatorImpl
    extends OwnershipHelperLocator<Job<?, ?>> {
        @Override
        public AbstractOwnershipHelper<Job<?, ?>> findHelper(Object item) {
            if (item instanceof Job) {
                return Instance;
            }
            return null;
        }
    }
}

