/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.jobs;

import com.synopsys.arc.jenkins.plugins.ownership.IOwnershipHelper;
import com.synopsys.arc.jenkins.plugins.ownership.IOwnershipItem;
import com.synopsys.arc.jenkins.plugins.ownership.Messages;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipPlugin;
import com.synopsys.arc.jenkins.plugins.ownership.jobs.JobOwnerHelper;
import com.synopsys.arc.jenkins.plugins.ownership.security.itemspecific.ItemSpecificSecurity;
import com.synopsys.arc.jenkins.plugins.ownership.util.UserCollectionFilter;
import com.synopsys.arc.jenkins.plugins.ownership.util.ui.OwnershipLayoutFormatter;
import com.synopsys.arc.jenkins.plugins.ownership.util.userFilters.AccessRightsFilter;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.User;
import hudson.security.AccessControlled;
import hudson.util.XStream2;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class JobOwnerJobProperty
extends JobProperty<Job<?, ?>>
implements IOwnershipItem<Job<?, ?>> {
    @CheckForNull
    OwnershipDescription ownership;
    @CheckForNull
    ItemSpecificSecurity itemSpecificSecurity;

    @DataBoundConstructor
    public JobOwnerJobProperty(OwnershipDescription ownershipDescription, ItemSpecificSecurity security) {
        this.ownership = ownershipDescription;
        this.itemSpecificSecurity = security;
    }

    @Override
    public OwnershipDescription getOwnership() {
        return this.ownership != null ? this.ownership : OwnershipDescription.DISABLED_DESCR;
    }

    @CheckForNull
    public ItemSpecificSecurity getItemSpecificSecurity() {
        return this.itemSpecificSecurity != null ? this.itemSpecificSecurity : OwnershipPlugin.getInstance().getDefaultJobsSecurity();
    }

    public boolean hasItemSpecificSecurity() {
        return this.itemSpecificSecurity != null;
    }

    public String getDisplayName(User usr) {
        return JobOwnerHelper.Instance.getDisplayName(usr);
    }

    public Collection<User> getUsers() {
        AccessRightsFilter filter = new AccessRightsFilter((AccessControlled)this.owner, Job.CONFIGURE);
        Collection<User> res = UserCollectionFilter.filterUsers(User.getAll(), true, filter);
        return res;
    }

    @Override
    public IOwnershipHelper<Job<?, ?>> helper() {
        return JobOwnerHelper.Instance;
    }

    @Override
    public Job<?, ?> getDescribedItem() {
        return this.owner;
    }

    public JobProperty<?> reconfigure(StaplerRequest req, JSONObject form) throws Descriptor.FormException {
        return new JobOwnerJobProperty(this.ownership, this.itemSpecificSecurity);
    }

    public OwnershipLayoutFormatter<Job<?, ?>> getLayoutFormatter() {
        return OwnershipPlugin.getInstance().getOwnershipLayoutFormatterProvider().getLayoutFormatter(this.getDescribedItem());
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append(this.ownership != null ? this.ownership.toString() : "ownership not set");
        bldr.append(" ");
        bldr.append(this.itemSpecificSecurity != null ? "with specific permissions" : "without specific permissions");
        return bldr.toString();
    }

    public void doOwnersSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, UnsupportedEncodingException, ServletException, Descriptor.FormException {
        JSONObject formData = req.getSubmittedForm();
        JSONObject jsonOwnership = formData.getJSONObject("owners");
        this.setOwnershipDescription(OwnershipDescription.parseJSON(jsonOwnership));
    }

    public void setOwnershipDescription(@CheckForNull OwnershipDescription descr) throws IOException {
        this.ownership = descr;
        this.owner.save();
    }

    public void setItemSpecificSecurity(@CheckForNull ItemSpecificSecurity security) throws IOException {
        this.itemSpecificSecurity = security;
        this.owner.save();
    }

    static {
        try {
            Method m = XStream2.class.getMethod("addCriticalField", Class.class, String.class);
            m.invoke((Object)Items.XSTREAM2, JobOwnerJobProperty.class, "ownership");
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public String getDisplayName() {
            return Messages.JobOwnership_Config_SectionTitle();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return true;
        }
    }
}

