/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.jobs;

import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipPlugin;
import com.synopsys.arc.jenkins.plugins.ownership.extensions.ItemOwnershipPolicy;
import com.synopsys.arc.jenkins.plugins.ownership.jobs.JobOwnerHelper;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.listeners.ItemListener;
import java.io.IOException;

@Extension
public class OwnershipItemListener
extends ItemListener {
    public void onCopied(Item src, Item item) {
        OwnershipDescription d = this.getPolicy().onCopied(src, item);
        this.modifyOwnership(item, d);
    }

    public void onCreated(Item item) {
        OwnershipDescription d = this.getPolicy().onCreated(item);
        this.modifyOwnership(item, d);
    }

    private ItemOwnershipPolicy getPolicy() {
        return OwnershipPlugin.getInstance().getConfiguration().getItemOwnershipPolicy();
    }

    private void modifyOwnership(Item item, OwnershipDescription ownership) {
        if (item instanceof Job) {
            Job job = (Job)item;
            try {
                JobOwnerHelper.setOwnership(job, ownership);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

