/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.jobs;

import com.synopsys.arc.jenkins.plugins.ownership.Messages;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.util.AbstractOwnershipHelper;
import com.synopsys.arc.jenkins.plugins.ownership.util.UserWrapper;
import com.synopsys.arc.jenkins.plugins.ownership.util.userFilters.UserComparator;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.TopLevelItem;
import hudson.model.User;
import hudson.model.View;
import hudson.views.ViewJobFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.ownership.model.OwnershipHelperLocator;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class OwnershipJobFilter
extends ViewJobFilter {
    private static final String MACRO_ME = "@Me";
    String ownerId;
    boolean acceptsCoowners;

    public String getOwnerName() {
        return this.ownerId;
    }

    @Deprecated
    public boolean isAcceptsCoowners() {
        return this.acceptsCoowners;
    }

    public boolean isAcceptSecondaryOwners() {
        return this.acceptsCoowners;
    }

    public boolean isSelected(UserWrapper usr) {
        return this.ownerId.equals(usr.getId());
    }

    @DataBoundConstructor
    public OwnershipJobFilter(String ownerName, boolean acceptCoowners) {
        this.ownerId = ownerName;
        this.acceptsCoowners = acceptCoowners;
    }

    public List<TopLevelItem> filter(List<TopLevelItem> added, List<TopLevelItem> all, View filteringView) {
        ArrayList<TopLevelItem> newList = new ArrayList<TopLevelItem>();
        UserWrapper userWrapper = new UserWrapper(this.ownerId);
        for (TopLevelItem item : added) {
            OwnershipDescription ownership;
            AbstractOwnershipHelper<TopLevelItem> helper = OwnershipHelperLocator.locate(item);
            if (helper == null || !(ownership = helper.getOwnershipDescription(item)).isOwnershipEnabled()) continue;
            boolean matches = false;
            if (userWrapper.meetsMacro(ownership.getPrimaryOwnerId())) {
                matches = true;
            }
            if (this.acceptsCoowners && !matches) {
                for (String coOwnerId : ownership.getSecondaryOwnerIds()) {
                    if (!userWrapper.meetsMacro(coOwnerId)) continue;
                    matches = true;
                    break;
                }
            }
            if (!matches) continue;
            newList.add(item);
        }
        return newList;
    }

    @Nonnull
    public static Collection<UserWrapper> getAvailableUsers() {
        UserComparator comparator = new UserComparator();
        LinkedList userList = new LinkedList(User.getAll());
        Collections.sort(userList, comparator);
        ArrayList<UserWrapper> res = new ArrayList<UserWrapper>(userList.size() + 1);
        res.add(new UserWrapper(MACRO_ME));
        for (User user : userList) {
            res.add(new UserWrapper(user));
        }
        return res;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ViewJobFilter> {
        public String getDisplayName() {
            return Messages.JobOwnership_Filter_DisplayName();
        }

        public ViewJobFilter newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String jobOwner = formData.getString("jobOwner");
            boolean acceptCoowners = formData.getBoolean("acceptsCoowners");
            OwnershipJobFilter instance = new OwnershipJobFilter(jobOwner, acceptCoowners);
            return instance;
        }
    }
}

