/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.nodes;

import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipPlugin;
import com.synopsys.arc.jenkins.plugins.ownership.nodes.NodeOwnerHelper;
import com.synopsys.arc.jenkins.plugins.ownership.util.AbstractOwnershipHelper;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.User;
import hudson.security.Permission;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.ownership.model.OwnershipHelperLocator;
import org.jenkinsci.plugins.ownership.model.OwnershipInfo;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class ComputerOwnerHelper
extends AbstractOwnershipHelper<Computer> {
    static final ComputerOwnerHelper INSTANCE = new ComputerOwnerHelper();

    public static ComputerOwnerHelper getInstance() {
        return INSTANCE;
    }

    @Override
    public OwnershipDescription getOwnershipDescription(@Nonnull Computer item) {
        Node node = item.getNode();
        return node != null ? NodeOwnerHelper.Instance.getOwnershipDescription(node) : OwnershipDescription.DISABLED_DESCR;
    }

    @Override
    public OwnershipInfo getOwnershipInfo(Computer item) {
        Node node = item.getNode();
        return node != null ? NodeOwnerHelper.Instance.getOwnershipInfo(node) : OwnershipInfo.DISABLED_INFO;
    }

    @Override
    public Collection<User> getPossibleOwners(@Nonnull Computer computer) {
        Node node = computer.getNode();
        return node != null ? NodeOwnerHelper.Instance.getPossibleOwners(node) : Collections.emptyList();
    }

    public static void setOwnership(@Nonnull Computer computer, @CheckForNull OwnershipDescription descr) throws IOException {
        Node node = computer.getNode();
        if (node == null) {
            throw new IOException("Cannot set ownership. Probably, the node has been renamed or deleted.");
        }
        NodeOwnerHelper.setOwnership(node, descr);
    }

    @Override
    public Permission getRequiredPermission() {
        return OwnershipPlugin.MANAGE_SLAVES_OWNERSHIP;
    }

    @Override
    public boolean hasLocallyDefinedOwnership(@Nonnull Computer computer) {
        Node node = computer.getNode();
        if (node == null) {
            return false;
        }
        return NodeOwnerHelper.Instance.hasLocallyDefinedOwnership(node);
    }

    @Override
    public String getItemTypeName(Computer item) {
        return "computer";
    }

    @Override
    public String getItemDisplayName(Computer item) {
        return item.getDisplayName();
    }

    @Override
    public String getItemURL(Computer item) {
        return item.getUrl();
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static class LocatorImpl
    extends OwnershipHelperLocator<Computer> {
        @Override
        public AbstractOwnershipHelper<Computer> findHelper(Object item) {
            if (item instanceof Computer) {
                return INSTANCE;
            }
            return null;
        }
    }
}

