/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.nodes;

import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipPlugin;
import com.synopsys.arc.jenkins.plugins.ownership.nodes.ComputerOwnerHelper;
import com.synopsys.arc.jenkins.plugins.ownership.nodes.OwnerNodeProperty;
import com.synopsys.arc.jenkins.plugins.ownership.util.AbstractOwnershipHelper;
import com.synopsys.arc.jenkins.plugins.ownership.util.UserCollectionFilter;
import com.synopsys.arc.jenkins.plugins.ownership.util.userFilters.AccessRightsFilter;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.User;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.ownership.model.OwnershipHelperLocator;
import org.jenkinsci.plugins.ownership.model.OwnershipInfo;
import org.jenkinsci.plugins.ownership.model.nodes.NodeOwnershipDescriptionSource;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class NodeOwnerHelper
extends AbstractOwnershipHelper<Node> {
    public static final NodeOwnerHelper Instance = new NodeOwnerHelper();
    static final String ITEM_TYPE_NAME = "node";

    @CheckForNull
    public static OwnerNodeProperty getOwnerProperty(@Nonnull Node node) {
        return (OwnerNodeProperty)node.getNodeProperties().get(OwnerNodeProperty.class);
    }

    @Override
    public OwnershipDescription getOwnershipDescription(@CheckForNull Node item) {
        if (item == null) {
            return OwnershipDescription.DISABLED_DESCR;
        }
        OwnerNodeProperty prop = NodeOwnerHelper.getOwnerProperty(item);
        return prop != null ? prop.getOwnership() : OwnershipDescription.DISABLED_DESCR;
    }

    @Override
    public OwnershipInfo getOwnershipInfo(Node item) {
        if (item == null) {
            return OwnershipInfo.DISABLED_INFO;
        }
        OwnerNodeProperty prop = NodeOwnerHelper.getOwnerProperty(item);
        return prop != null ? new OwnershipInfo(OwnershipDescription.DISABLED_DESCR, new NodeOwnershipDescriptionSource(item)) : OwnershipInfo.DISABLED_INFO;
    }

    @Override
    public Permission getRequiredPermission() {
        return OwnershipPlugin.MANAGE_SLAVES_OWNERSHIP;
    }

    @Override
    public boolean hasLocallyDefinedOwnership(@Nonnull Node node) {
        return NodeOwnerHelper.getOwnerProperty(node) != null;
    }

    @Override
    public Collection<User> getPossibleOwners(Node item) {
        if (OwnershipPlugin.getInstance().isRequiresConfigureRights()) {
            AccessRightsFilter filter = new AccessRightsFilter((AccessControlled)item, Computer.CONFIGURE);
            return UserCollectionFilter.filterUsers(User.getAll(), true, filter);
        }
        return User.getAll();
    }

    public static void setOwnership(@Nonnull Node node, @CheckForNull OwnershipDescription descr) throws IOException {
        OwnerNodeProperty prop = NodeOwnerHelper.getOwnerProperty(node);
        if (prop == null) {
            prop = new OwnerNodeProperty(node, descr);
            node.getNodeProperties().add((Object)prop);
        } else {
            prop.setOwnershipDescription(descr);
        }
    }

    @Override
    public String getItemTypeName(Node item) {
        return ITEM_TYPE_NAME;
    }

    @Override
    public String getItemDisplayName(Node item) {
        return item.getDisplayName();
    }

    @Override
    public String getItemURL(Node item) {
        Computer c = item.toComputer();
        return c != null ? ComputerOwnerHelper.INSTANCE.getItemURL(c) : null;
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static class LocatorImpl
    extends OwnershipHelperLocator<Node> {
        @Override
        public AbstractOwnershipHelper<Node> findHelper(Object item) {
            if (item instanceof Node) {
                return Instance;
            }
            return null;
        }
    }
}

