/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.nodes;

import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipPlugin;
import com.synopsys.arc.jenkins.plugins.ownership.nodes.NodeOwnerHelper;
import com.synopsys.arc.jenkins.plugins.ownership.nodes.OwnerNodeProperty;
import com.synopsys.arc.jenkins.plugins.ownership.util.AbstractOwnershipHelper;
import com.synopsys.arc.jenkins.plugins.ownership.util.UserCollectionFilter;
import com.synopsys.arc.jenkins.plugins.ownership.util.userFilters.IUserFilter;
import hudson.Extension;
import hudson.model.Node;
import hudson.model.User;
import hudson.security.Permission;
import hudson.slaves.NodeProperty;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.ownership.model.OwnershipHelperLocator;
import org.jenkinsci.plugins.ownership.model.OwnershipInfo;
import org.jenkinsci.plugins.ownership.model.nodes.NodeOwnershipDescriptionSource;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class NodeOwnerPropertyHelper
extends AbstractOwnershipHelper<NodeProperty> {
    static final NodeOwnerPropertyHelper Instance = new NodeOwnerPropertyHelper();

    @CheckForNull
    private static OwnerNodeProperty getOwnerProperty(@CheckForNull NodeProperty node) {
        return (OwnerNodeProperty)node;
    }

    @Override
    @Nonnull
    public OwnershipDescription getOwnershipDescription(@CheckForNull NodeProperty item) {
        OwnerNodeProperty prop = NodeOwnerPropertyHelper.getOwnerProperty(item);
        OwnershipDescription descr = prop != null ? prop.getOwnership() : null;
        return descr != null ? descr : OwnershipDescription.DISABLED_DESCR;
    }

    @Override
    public OwnershipInfo getOwnershipInfo(NodeProperty item) {
        OwnerNodeProperty prop = NodeOwnerPropertyHelper.getOwnerProperty(item);
        OwnershipDescription descr = prop != null ? prop.getOwnership() : null;
        return descr != null ? new OwnershipInfo(descr, new NodeOwnershipDescriptionSource(this.getNode(item))) : OwnershipInfo.DISABLED_INFO;
    }

    @Override
    @Nonnull
    public Collection<User> getPossibleOwners(NodeProperty item) {
        if (OwnershipPlugin.getInstance().isRequiresConfigureRights()) {
            return UserCollectionFilter.filterUsers(User.getAll(), true, new IUserFilter[0]);
        }
        return User.getAll();
    }

    @CheckForNull
    private Node getNode(@Nonnull NodeProperty item) {
        if (item instanceof OwnerNodeProperty) {
            OwnerNodeProperty prop = (OwnerNodeProperty)item;
            return prop.getNode();
        }
        return null;
    }

    @Override
    public Permission getRequiredPermission() {
        return OwnershipPlugin.MANAGE_SLAVES_OWNERSHIP;
    }

    @Override
    public boolean hasLocallyDefinedOwnership(@Nonnull NodeProperty item) {
        return true;
    }

    @Override
    public String getItemTypeName(NodeProperty item) {
        return "node";
    }

    @Override
    public String getItemDisplayName(NodeProperty item) {
        Node node = this.getNode(item);
        return node != null ? NodeOwnerHelper.Instance.getItemDisplayName(node) : "unknown node";
    }

    @Override
    public String getItemURL(NodeProperty item) {
        Node node = this.getNode(item);
        return node != null ? NodeOwnerHelper.Instance.getItemURL(node) : null;
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static class LocatorImpl
    extends OwnershipHelperLocator<NodeProperty> {
        @Override
        public AbstractOwnershipHelper<NodeProperty> findHelper(Object item) {
            if (item instanceof NodeProperty) {
                return Instance;
            }
            return null;
        }
    }
}

