/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.nodes;

import com.synopsys.arc.jenkins.plugins.ownership.IOwnershipHelper;
import com.synopsys.arc.jenkins.plugins.ownership.IOwnershipItem;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipPlugin;
import com.synopsys.arc.jenkins.plugins.ownership.nodes.NodeOwnerPropertyHelper;
import com.synopsys.arc.jenkins.plugins.ownership.nodes.NodeOwnerWrapper;
import com.synopsys.arc.jenkins.plugins.ownership.util.ui.OwnershipLayoutFormatter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.slaves.SlaveComputer;
import hudson.util.XStream2;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class OwnerNodeProperty
extends NodeProperty<Node>
implements IOwnershipItem<NodeProperty> {
    private OwnershipDescription ownership;
    private String nodeName;

    @DataBoundConstructor
    public OwnerNodeProperty(NodeOwnerWrapper slaveOwnership) {
        this(null, slaveOwnership != null ? slaveOwnership.getDescription() : null);
    }

    public OwnerNodeProperty(Node node, OwnershipDescription ownership) {
        this.setNode(node);
        this.nodeName = node != null ? node.getNodeName() : null;
        this.ownership = ownership != null ? ownership : OwnershipDescription.DISABLED_DESCR;
    }

    @Override
    public OwnershipDescription getOwnership() {
        return this.ownership != null ? this.ownership : OwnershipDescription.DISABLED_DESCR;
    }

    public void setOwnershipDescription(OwnershipDescription descr) {
        this.ownership = descr;
        this.getDescriptor().save();
    }

    @CheckForNull
    public Node getNode() {
        if (this.node == null) {
            this.setNode(Jenkins.getActiveInstance().getNode(this.nodeName));
        }
        return this.node;
    }

    public NodePropertyDescriptor getDescriptor() {
        return super.getDescriptor();
    }

    @Override
    public IOwnershipHelper<NodeProperty> helper() {
        return NodeOwnerPropertyHelper.Instance;
    }

    public NodeProperty<?> reconfigure(StaplerRequest req, JSONObject form) throws Descriptor.FormException {
        return new OwnerNodeProperty(DescriptorImpl.getNodePropertyOwner(req), this.getOwnership());
    }

    @Override
    public NodeProperty getDescribedItem() {
        return this;
    }

    public OwnershipLayoutFormatter<Node> getLayoutFormatter() {
        return OwnershipPlugin.getInstance().getOwnershipLayoutFormatterProvider().getLayoutFormatter(this.getNode());
    }

    static {
        try {
            Method m = XStream2.class.getMethod("addCriticalField", Class.class, String.class);
            m.invoke((Object)Jenkins.XSTREAM2, OwnerNodeProperty.class, "ownership");
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends NodePropertyDescriptor {
        private static Node getNodePropertyOwner(StaplerRequest req) {
            List ancestors = req.getAncestors();
            if (ancestors.isEmpty()) {
                assert (false) : "StaplerRequest is empty";
                return null;
            }
            Object node = ((Ancestor)ancestors.get(ancestors.size() - 1)).getObject();
            if (SlaveComputer.class.isAssignableFrom(node.getClass())) {
                return ((SlaveComputer)node).getNode();
            }
            assert (false) : "StaplerRequest should have Node ancestor";
            return null;
        }

        @SuppressFBWarnings(value={"NP_NONNULL_RETURN_VIOLATION"}, justification="TODO: should be fixed, see jenkinsci PR #1880")
        public String getDisplayName() {
            return null;
        }

        public boolean isApplicable(Class<? extends Node> Type2) {
            return true;
        }
    }
}

