/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.nodes;

import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.nodes.ComputerOwnerHelper;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.node_monitors.AbstractNodeMonitorDescriptor;
import hudson.node_monitors.NodeMonitor;
import hudson.slaves.OfflineCause;
import java.io.IOException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.ExportedBean;

public class OwnershipNodeMonitor
extends NodeMonitor {
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public AbstractNodeMonitorDescriptor<?> getDescriptor() {
        return DESCRIPTOR;
    }

    @ExportedBean
    public static class Data
    extends OfflineCause {
        private final OwnershipDescription ownershipDescription;

        public Data(OwnershipDescription ownershipDescription) {
            this.ownershipDescription = ownershipDescription;
        }

        public OwnershipDescription getOwnershipDescription() {
            return this.ownershipDescription;
        }

        public String toString() {
            return this.ownershipDescription.getPrimaryOwnerId();
        }
    }

    public static class DescriptorImpl
    extends AbstractNodeMonitorDescriptor<Data> {
        DescriptorImpl() {
            super(600000L);
        }

        protected Data monitor(Computer c) throws IOException, InterruptedException {
            OwnershipDescription ownership = ComputerOwnerHelper.getInstance().getOwnershipDescription(c);
            return new Data(ownership);
        }

        public String getDisplayName() {
            return "Ownership";
        }

        public NodeMonitor newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new OwnershipNodeMonitor();
        }
    }
}

