/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.security.authorizeproject;

import com.synopsys.arc.jenkins.plugins.ownership.Messages;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.jobs.JobOwnerHelper;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.User;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectStrategy;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectStrategyDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

public class OwnershipAuthorizeProjectStrategy
extends AuthorizeProjectStrategy {
    @DataBoundConstructor
    public OwnershipAuthorizeProjectStrategy() {
    }

    public Authentication authenticate(Job<?, ?> job, Queue.Item item) {
        OwnershipDescription d = JobOwnerHelper.Instance.getOwnershipDescription(job);
        if (!d.hasPrimaryOwner()) {
            return Jenkins.ANONYMOUS;
        }
        User owner = User.getById((String)d.getPrimaryOwnerId(), (boolean)false);
        if (owner == null) {
            return Jenkins.ANONYMOUS;
        }
        try {
            return owner.impersonate();
        }
        catch (UsernameNotFoundException ex) {
            return Jenkins.ANONYMOUS;
        }
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends AuthorizeProjectStrategyDescriptor {
        public String getDisplayName() {
            return Messages.Security_AuthorizeProject_OwnershipAuthorizeProjectStrategy_DisplayName();
        }
    }
}

