/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.security.itemspecific;

import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.security.AuthorizationMatrixProperty;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class ItemSpecificSecurity
implements Describable<ItemSpecificSecurity>,
Cloneable {
    @Nonnull
    private AuthorizationMatrixProperty permissionsMatrix;
    public static final ItemSpecificDescriptor DESCRIPTOR = new ItemSpecificDescriptor();

    @DataBoundConstructor
    public ItemSpecificSecurity(@CheckForNull AuthorizationMatrixProperty permissionsMatrix) {
        this.permissionsMatrix = permissionsMatrix != null ? permissionsMatrix : new AuthorizationMatrixProperty(new TreeMap());
    }

    public ItemSpecificDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    @Nonnull
    public AuthorizationMatrixProperty getPermissionsMatrix() {
        return this.permissionsMatrix;
    }

    public ItemSpecificSecurity clone() {
        try {
            ItemSpecificSecurity newItem = (ItemSpecificSecurity)super.clone();
            newItem.permissionsMatrix = new AuthorizationMatrixProperty(this.permissionsMatrix.getGrantedPermissions());
            return newItem;
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(ItemSpecificSecurity.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Extension
    public static class ItemSpecificDescriptor
    extends Descriptor<ItemSpecificSecurity> {
        public String getDisplayName() {
            return "Item-specific security";
        }

        public ItemSpecificSecurity newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            AuthorizationMatrixProperty prop = null;
            if (formData.containsKey((Object)"permissionsMatrix")) {
                Descriptor d = Jenkins.getActiveInstance().getDescriptor(AuthorizationMatrixProperty.class);
                prop = (AuthorizationMatrixProperty)d.newInstance(req, formData.getJSONObject("permissionsMatrix"));
            }
            return new ItemSpecificSecurity(prop);
        }
    }
}

