/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.security.jobrestrictions;

import com.synopsys.arc.jenkins.plugins.ownership.Messages;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.jobs.JobOwnerHelper;
import com.synopsys.arc.jenkins.plugins.ownership.util.IdStrategyComparator;
import com.synopsys.arc.jenkins.plugins.ownership.util.ui.UserSelector;
import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.restrictions.JobRestriction;
import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.restrictions.JobRestrictionDescriptor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.kohsuke.stapler.DataBoundConstructor;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="JobRestriction should not be serializable, not required for Xstream")
public class OwnersListJobRestriction
extends JobRestriction {
    private static final JobOwnerHelper helper = new JobOwnerHelper();
    private final List<UserSelector> usersList;
    private final boolean acceptsCoOwners;
    private transient Set<String> usersMap = null;

    @DataBoundConstructor
    public OwnersListJobRestriction(List<UserSelector> usersList, boolean acceptsCoOwners) {
        this.usersList = usersList;
        this.acceptsCoOwners = acceptsCoOwners;
        this.updateUsersMap();
    }

    protected final synchronized void updateUsersMap() {
        if (this.usersMap == null) {
            this.usersMap = new TreeSet<String>(new IdStrategyComparator());
            for (UserSelector selector : this.usersList) {
                String userId = Util.fixEmptyAndTrim((String)selector.getSelectedUserId());
                if (userId == null || this.usersMap.contains(userId)) continue;
                this.usersMap.add(userId);
            }
        }
    }

    public List<UserSelector> getUsersList() {
        return this.usersList;
    }

    @Deprecated
    public boolean isAcceptsCoOwners() {
        return this.acceptsCoOwners;
    }

    public boolean isAcceptSecondaryOwners() {
        return this.acceptsCoOwners;
    }

    public boolean canTake(Queue.BuildableItem item) {
        if (item.task instanceof Job) {
            Job job = (Job)item.task;
            OwnershipDescription descr = helper.getOwnershipDescription(job);
            return this.canTake(descr);
        }
        return true;
    }

    public boolean canTake(Run run) {
        OwnershipDescription descr = helper.getOwnershipDescription(run.getParent());
        return this.canTake(descr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canTake(OwnershipDescription descr) {
        if (!descr.isOwnershipEnabled()) {
            return false;
        }
        OwnersListJobRestriction ownersListJobRestriction = this;
        synchronized (ownersListJobRestriction) {
            this.updateUsersMap();
            if (this.usersMap.contains(descr.getPrimaryOwnerId())) {
                return true;
            }
            TreeSet<String> itemCoOwners = new TreeSet<String>(new IdStrategyComparator());
            itemCoOwners.addAll(descr.getSecondaryOwnerIds());
            if (this.acceptsCoOwners && !itemCoOwners.isEmpty()) {
                for (String userID : this.usersMap) {
                    if (!itemCoOwners.contains(userID)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends JobRestrictionDescriptor {
        public String getDisplayName() {
            return Messages.Security_JobRestrictions_OwnershipRestriction_DisplayName();
        }
    }
}

